/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;

public class PopupMenuManager {
    private JPopupMenu popup;
    private EventHandler eventHandler;

    public PopupMenuManager(JPopupMenu popup, Container c) {
        this.popup = popup;
        this.eventHandler = new EventHandler();
        c.addMouseListener(this.eventHandler);
        this.setupMouseListener(c);
    }

    private void setupMouseListener(Container c) {
        c.addMouseListener(this.eventHandler);
        if (c instanceof JFrame) {
            c = ((JFrame)c).getContentPane();
        }
        if (c instanceof JApplet) {
            c = ((JApplet)c).getContentPane();
        }
        Component[] control = c.getComponents();
        int i = 0;
        while (i < control.length) {
            control[i].addMouseListener(this.eventHandler);
            if (control[i] instanceof Container) {
                this.setupMouseListener((Container)control[i]);
            }
            ++i;
        }
    }

    void showPopup(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.popup.show(me.getComponent(), me.getX(), me.getY());
        }
    }

    class EventHandler
    extends MouseAdapter {
        EventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PopupMenuManager.this.showPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PopupMenuManager.this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            PopupMenuManager.this.showPopup(e);
        }
    }
}

