/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.rules.AbstractPropertyValueRule;
import com.jmorgan.rules.CompoundRule;
import com.jmorgan.rules.Rule;
import com.jmorgan.swing.util.AbstractComponentStyleController;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;

public class PropertyValueComponentStyleController
extends AbstractComponentStyleController
implements PropertyChangeListener {
    private ArrayList<Rule> rules = new ArrayList();
    private String stylesToApplyIfTrue;
    private String stylesToApplyIfFalse;

    public PropertyValueComponentStyleController() {
    }

    public PropertyValueComponentStyleController(Component ... components) {
        super(components);
    }

    @Override
    public void addComponents(Component ... components) {
        super.addComponents(components);
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.addPropertyChangeListener(this);
            ++n2;
        }
    }

    public void addRules(Rule ... rules) {
        this.rules.addAll(Arrays.asList(rules));
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void applyIfTrue(String name) {
        this.stylesToApplyIfTrue = name;
    }

    public void applyIfFalse(String name) {
        this.stylesToApplyIfFalse = name;
    }

    public void apply() {
        for (Component component : this.getComponents()) {
            boolean allRulesTrue = true;
            for (Rule rule : this.rules) {
                this.setComponentOnRule(component, rule);
                if (rule.isTrue()) continue;
                allRulesTrue = false;
                break;
            }
            if (allRulesTrue) {
                this.applyStyles(this.stylesToApplyIfTrue, component);
                continue;
            }
            this.applyStyles(this.stylesToApplyIfFalse, component);
        }
    }

    private void setComponentOnRule(Component component, Rule rule) {
        if (rule instanceof AbstractPropertyValueRule) {
            AbstractPropertyValueRule pvRule = (AbstractPropertyValueRule)rule;
            pvRule.setBean(component);
        } else if (rule instanceof CompoundRule) {
            CompoundRule childRule = (CompoundRule)rule;
            ArrayList<Rule> rules = childRule.getRules();
            for (Rule r : rules) {
                this.setComponentOnRule(component, r);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.apply();
    }
}

