/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMFrame;
import com.jmorgan.swing.event.AdjustmentEventInvoker;
import com.jmorgan.util.ArrayUtility;
import java.util.HashMap;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class ScrollSynchronizer {
    private HashMap<Integer, JScrollPane> scrollPanes;
    private boolean internalChanging;
    private AsynchMethodInvoker<Void> setInternalStateThread;

    public ScrollSynchronizer() {
    }

    public ScrollSynchronizer(JScrollPane ... scrollPanes) {
        this();
        if (!ArrayUtility.isEmpty(scrollPanes)) {
            JScrollPane[] jScrollPaneArray = scrollPanes;
            int n = scrollPanes.length;
            int n2 = 0;
            while (n2 < n) {
                JScrollPane scrollPane = jScrollPaneArray[n2];
                this.addScrollPane(scrollPane);
                ++n2;
            }
        }
    }

    public void addScrollPane(JScrollPane scrollPane) {
        if (scrollPane == null) {
            return;
        }
        if (this.scrollPanes == null) {
            this.scrollPanes = new HashMap();
        }
        int index = this.scrollPanes.size();
        this.scrollPanes.put(index, scrollPane);
        JScrollBar horizontalScrollBar = scrollPane.getHorizontalScrollBar();
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        new AdjustmentEventInvoker(horizontalScrollBar, this, "horizontalScrollChanged", index);
        new AdjustmentEventInvoker(verticalScrollBar, this, "verticalScrollChanged", index);
    }

    @Reflected
    private void horizontalScrollChanged(int scrollPaneIndex) {
        this.synchronizeScollbars(scrollPaneIndex, false);
    }

    @Reflected
    private void verticalScrollChanged(int scrollPaneIndex) {
        this.synchronizeScollbars(scrollPaneIndex, true);
    }

    private void synchronizeScollbars(int scrollPaneIndex, boolean isVerticalScroll) {
        if (this.internalChanging) {
            return;
        }
        this.internalChanging = true;
        try {
            try {
                JScrollPane scrollPaneChanged = this.scrollPanes.get(scrollPaneIndex);
                JScrollBar changedScrollBar = isVerticalScroll ? scrollPaneChanged.getVerticalScrollBar() : scrollPaneChanged.getHorizontalScrollBar();
                BoundedRangeModel changedModel = changedScrollBar.getModel();
                double changedMax = changedModel.getMaximum();
                double changedValue = changedModel.getValue();
                double relativePosition = changedValue == 0.0 ? 0.0 : changedValue / changedMax;
                for (int index : this.scrollPanes.keySet()) {
                    if (index == scrollPaneIndex) continue;
                    JScrollPane scrollPane = this.scrollPanes.get(index);
                    JScrollBar scrollBar = isVerticalScroll ? scrollPane.getVerticalScrollBar() : scrollPane.getHorizontalScrollBar();
                    BoundedRangeModel model = scrollBar.getModel();
                    if (changedValue == 0.0) {
                        model.setValue(0);
                        continue;
                    }
                    int max = model.getMaximum();
                    double newValue = (double)max * relativePosition;
                    model.setValue((int)newValue);
                }
            }
            catch (Exception exception) {
                if (this.setInternalStateThread != null) {
                    this.setInternalStateThread.cancel();
                }
                this.setInternalStateThread = new AsynchMethodInvoker((Object)this, "setInternalChanging", (Object)false, 50);
            }
        }
        finally {
            if (this.setInternalStateThread != null) {
                this.setInternalStateThread.cancel();
            }
            this.setInternalStateThread = new AsynchMethodInvoker((Object)this, "setInternalChanging", (Object)false, 50);
        }
    }

    @Reflected
    private void setInternalChanging(boolean state) {
        this.internalChanging = state;
        this.setInternalStateThread = null;
        JMFrame frame = GUIApplication.getGUIApplication().getApplicationFrame();
        if (frame != null) {
            frame.invalidate();
        }
    }
}

