/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.beans.util.PropertyBinder;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.event.FocusEventInvoker;
import com.jmorgan.swing.util.HoverBorderController;
import com.jmorgan.swing.util.HoverTooltipController;
import com.jmorgan.swing.util.VisualComponentEditorPopup;
import com.jmorgan.util.Comparison;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class VisualComponentEditor
extends JMBean
implements MouseListener,
MouseMotionListener,
ContainerListener {
    private JComponent component;
    private Cursor originalCursor;
    private Cursor overCursor;
    private Cursor normalCursor;
    private Cursor moveCursor;
    private Cursor nResizeCursor;
    private Cursor wResizeCursor;
    private Cursor eResizeCursor;
    private Cursor sResizeCursor;
    private Cursor neResizeCursor;
    private Cursor nwResizeCursor;
    private Cursor seResizeCursor;
    private Cursor swResizeCursor;
    private Border highlightBorder;
    private HoverBorderController hoverBorderController;
    private HoverTooltipController hoverTooltipController;
    private Point dragLocationOffset;
    private int hotEdgeSize;
    private boolean atLeftEdge;
    private boolean atTopEdge;
    private boolean atRightEdge;
    private boolean atBottomEdge;
    private JMTextField labelEditor;
    private VisualComponentEditorPopup popupMenu;
    private boolean enabled = true;
    private ArrayList<EventListener> forwardListeners;

    public VisualComponentEditor(JComponent component) {
        this(component, new Cursor(0), new Cursor(12));
    }

    public VisualComponentEditor(JComponent component, Cursor normalCursor, Cursor overCursor) {
        this.setNormalCursor(normalCursor);
        this.setOverCursor(overCursor);
        this.setHighlightBorder(BorderFactory.createLineBorder(Color.ORANGE));
        this.moveCursor = new Cursor(13);
        this.nResizeCursor = new Cursor(8);
        this.wResizeCursor = new Cursor(10);
        this.eResizeCursor = new Cursor(11);
        this.sResizeCursor = new Cursor(9);
        this.neResizeCursor = new Cursor(7);
        this.nwResizeCursor = new Cursor(6);
        this.seResizeCursor = new Cursor(5);
        this.swResizeCursor = new Cursor(4);
        this.setHotEdgeSize(5);
        this.setComponent(component);
        this.forwardListeners = new ArrayList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.hoverBorderController.setEnabled(enabled);
        this.hoverTooltipController.setEnabled(enabled);
        if (!this.enabled) {
            this.component.setCursor(this.originalCursor);
            this.component.setBorder(this.hoverBorderController.getOldBorder());
            this.component.setToolTipText(this.hoverTooltipController.getOldTip());
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(JComponent component) {
        if (this.component != null) {
            this.cleanupEditorElements();
        }
        this.component = component;
        if (this.component == null) {
            return;
        }
        this.originalCursor = this.component.getCursor();
        if (this.hoverBorderController == null) {
            this.hoverBorderController = new HoverBorderController(this.highlightBorder);
        }
        this.hoverBorderController.addComponent(this.component);
        if (this.hoverTooltipController == null) {
            Object toolTip = "Right-Click for menu";
            if (BeanService.hasProperty(this.component, "text")) {
                toolTip = (String)toolTip + ", Double-Click to edit text";
            }
            this.hoverTooltipController = new HoverTooltipController((String)toolTip);
        }
        this.hoverTooltipController.addComponent(this.component);
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        this.setupContainerListener();
    }

    private void cleanupEditorElements() {
        this.component.setCursor(this.originalCursor);
        this.component.setBorder(this.hoverBorderController.getOldBorder());
        this.hoverBorderController.removeComponent(this.component);
        this.component.setToolTipText(this.hoverTooltipController.getOldTip());
        this.hoverTooltipController.removeComponent(this.component);
        this.component.removeMouseListener(this);
        this.component.removeMouseMotionListener(this);
        Container container = this.component.getParent();
        if (container != null) {
            if (this.component instanceof JTabbedPane) {
                Component[] components;
                Component[] componentArray = components = container.getComponents();
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    String cName = c.getName();
                    if (cName != null && cName.startsWith("surrogateEditableComponent")) {
                        container.remove(c);
                    }
                    ++n2;
                }
            }
            if (this.labelEditor != null) {
                container.remove(this.labelEditor);
            }
            container.removeContainerListener(this);
        }
    }

    @Reflected
    public void setupContainerListener() {
        Container container = this.component.getParent();
        if (container == null) {
            new AsynchMethodInvoker((Object)this, "setupContainerListener", 100);
        } else {
            container.addContainerListener(this);
        }
    }

    public Cursor getOverCursor() {
        return this.overCursor;
    }

    public void setOverCursor(Cursor overCursor) {
        this.overCursor = overCursor;
    }

    public Cursor getNormalCursor() {
        return this.normalCursor;
    }

    public void setNormalCursor(Cursor normalCursor) {
        this.normalCursor = normalCursor;
    }

    public Border getHighlightBorder() {
        return this.highlightBorder;
    }

    public void setHighlightBorder(Border highlightBorder) {
        this.highlightBorder = highlightBorder;
    }

    public int getHotEdgeSize() {
        return this.hotEdgeSize;
    }

    public void setHotEdgeSize(int hotEdgeSize) {
        this.hotEdgeSize = hotEdgeSize;
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        Dimension size = this.component.getSize();
        Point location = this.component.getLocation();
        Rectangle bounds = new Rectangle(location, size);
        Rectangle boundsToSet = new Rectangle(bounds);
        if (this.atLeftEdge) {
            boundsToSet.x = location.x + e.getX() - this.dragLocationOffset.x;
            boundsToSet.width += bounds.x - boundsToSet.x;
        }
        if (this.atTopEdge) {
            boundsToSet.y = location.y + e.getY() - this.dragLocationOffset.y;
            boundsToSet.height += bounds.y - boundsToSet.y;
        }
        if (this.atBottomEdge) {
            boundsToSet.height = size.height + e.getY() - this.dragLocationOffset.y;
            this.dragLocationOffset.y -= bounds.height - boundsToSet.height;
        }
        if (this.atRightEdge) {
            boundsToSet.width = size.width + e.getX() - this.dragLocationOffset.x;
            this.dragLocationOffset.x -= bounds.width - boundsToSet.width;
        }
        if (!(this.atLeftEdge || this.atTopEdge || this.atBottomEdge || this.atRightEdge)) {
            boundsToSet.x = location.x + e.getX() - this.dragLocationOffset.x;
            boundsToSet.y = location.y + e.getY() - this.dragLocationOffset.y;
        }
        if (boundsToSet.width < this.hotEdgeSize) {
            boundsToSet.width = this.hotEdgeSize;
        }
        if (boundsToSet.height < this.hotEdgeSize) {
            boundsToSet.height = this.hotEdgeSize;
        }
        this.component.setBounds(boundsToSet);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        Dimension size = this.component.getSize();
        Point mouseLocation = e.getPoint();
        this.atLeftEdge = Comparison.isBetween(mouseLocation.x, 0, this.hotEdgeSize);
        this.atTopEdge = Comparison.isBetween(mouseLocation.y, 0, this.hotEdgeSize);
        this.atRightEdge = Comparison.isBetween((Object)mouseLocation.x, (Object)(size.width - this.hotEdgeSize), size);
        this.atBottomEdge = Comparison.isBetween((Object)mouseLocation.y, (Object)(size.height - this.hotEdgeSize), size);
        Cursor cursorToSet = this.overCursor;
        if (this.atLeftEdge) {
            cursorToSet = this.atTopEdge ? this.nwResizeCursor : (this.atBottomEdge ? this.swResizeCursor : this.wResizeCursor);
        } else if (this.atRightEdge) {
            cursorToSet = this.atTopEdge ? this.neResizeCursor : (this.atBottomEdge ? this.seResizeCursor : this.eResizeCursor);
        } else if (this.atTopEdge) {
            cursorToSet = this.nResizeCursor;
        } else if (this.atBottomEdge) {
            cursorToSet = this.sResizeCursor;
        }
        this.component.setCursor(cursorToSet);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        if (e.getClickCount() == 2 && this.isLabelEditable()) {
            this.labelEditor = new JMTextField();
            this.labelEditor.setVisible(false);
            this.component.getParent().add(this.labelEditor);
            JComponent editComponent = this.getComponentToEdit();
            this.labelEditor.setSize(editComponent.getSize());
            this.labelEditor.setLocation(editComponent.getLocation());
            this.labelEditor.setBorder(editComponent.getBorder());
            this.labelEditor.setBackground(editComponent.getBackground());
            this.labelEditor.setForeground(editComponent.getForeground());
            this.labelEditor.setHorizontalAlignment(this.getComponentTextAlignment());
            editComponent.getParent().setComponentZOrder(this.labelEditor, 0);
            this.labelEditor.setText(this.getComponentLabel());
            new PropertyBinder(this.labelEditor, "text", this, "label");
            MethodInvoker getTextPointer = new MethodInvoker((Object)this.labelEditor, "getText", new Object[0]);
            FocusEventInvoker fei = new FocusEventInvoker(this.labelEditor, 2, (Object)this, "setLabel", getTextPointer);
            fei.setInvokeSynchronously(true);
            this.labelEditor.setVisible(true);
            this.labelEditor.requestFocus();
            new AsynchMethodInvoker((Object)this.labelEditor, "selectAll", 250);
        }
    }

    private boolean isLabelEditable() {
        return this.component instanceof JLabel || this.component instanceof JButton || this.component instanceof JRadioButton || this.component instanceof JCheckBox || this.component instanceof JTabbedPane;
    }

    @Reflected
    private void setLabel(String label) {
        if (this.labelEditor == null) {
            return;
        }
        this.setComponentLabel(label);
        this.labelEditor.setVisible(false);
        this.labelEditor.getParent().remove(this.labelEditor);
        this.labelEditor = null;
    }

    private JComponent getComponentToEdit() {
        if (this.component instanceof JLabel || this.component instanceof JButton) {
            return this.component;
        }
        if (this.component instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)this.component;
            Rectangle tpLocation = tabbedPane.getBounds();
            Rectangle r = tabbedPane.getUI().getTabBounds(tabbedPane, tabbedPane.getSelectedIndex());
            r.x += tpLocation.x;
            r.y += tpLocation.y;
            JLabel surrogate = new JLabel();
            surrogate.setName("surrogateEditableComponent" + tabbedPane.getSelectedIndex());
            surrogate.setBounds(r);
            this.component.getParent().add(surrogate);
            return surrogate;
        }
        return this.component;
    }

    private String getComponentLabel() {
        if (this.component instanceof JLabel) {
            return ((JLabel)this.component).getText();
        }
        if (this.component instanceof JCheckBox) {
            return ((JCheckBox)this.component).getText();
        }
        if (this.component instanceof JRadioButton) {
            return ((JRadioButton)this.component).getText();
        }
        if (this.component instanceof JButton) {
            return ((JButton)this.component).getText();
        }
        if (this.component instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)this.component;
            return tabbedPane.getTitleAt(tabbedPane.getSelectedIndex());
        }
        return "";
    }

    private int getComponentTextAlignment() {
        if (this.component instanceof JLabel) {
            return ((JLabel)this.component).getHorizontalAlignment();
        }
        if (this.component instanceof JButton) {
            return ((JButton)this.component).getHorizontalAlignment();
        }
        return 0;
    }

    private void setComponentLabel(String text) {
        if (this.component instanceof JLabel) {
            ((JLabel)this.component).setText(text);
        } else if (this.component instanceof JButton) {
            ((JButton)this.component).setText(text);
        } else if (this.component instanceof JRadioButton) {
            ((JRadioButton)this.component).setText(text);
        } else if (this.component instanceof JCheckBox) {
            ((JCheckBox)this.component).setText(text);
        } else if (this.component instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)this.component;
            tabbedPane.setTitleAt(tabbedPane.getSelectedIndex(), text);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        this.dragLocationOffset = e.getPoint();
        if (!this.isMouseAtEdge(this.dragLocationOffset)) {
            this.component.setCursor(this.moveCursor);
        }
        this.forwardListenerEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        if (!this.isMouseAtEdge(this.dragLocationOffset)) {
            this.component.setCursor(this.overCursor);
        }
        if (e.isPopupTrigger() || e.getButton() == 3) {
            if (this.popupMenu == null) {
                this.popupMenu = new VisualComponentEditorPopup(this.component);
            }
            this.popupMenu.setMenuState();
            this.popupMenu.show(this.component, e.getX(), e.getY());
        }
    }

    private boolean isMouseAtEdge(Point mouseLocation) {
        Dimension size = this.component.getSize();
        boolean atLeftEdge = Comparison.isBetween(mouseLocation.x, 0, this.hotEdgeSize);
        boolean atTopEdge = Comparison.isBetween(mouseLocation.y, 0, this.hotEdgeSize);
        boolean atRightEdge = Comparison.isBetween((Object)mouseLocation.x, (Object)(size.width - this.hotEdgeSize), size);
        boolean atBottomEdge = Comparison.isBetween((Object)mouseLocation.y, (Object)(size.height - this.hotEdgeSize), size);
        return atLeftEdge || atTopEdge || atRightEdge || atBottomEdge;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component component = e.getChild();
        if (component == this.component) {
            this.setComponent(null);
        }
    }

    public void addMouseListener(MouseListener listener) {
        this.forwardListeners.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.forwardListeners.remove(listener);
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.forwardListeners.add(listener);
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.forwardListeners.remove(listener);
    }

    public void forwardListenerEvent(EventObject event) {
        for (EventListener listener : this.forwardListeners) {
            if (listener instanceof MouseListener && event instanceof MouseEvent) {
                ((MouseListener)listener).mousePressed((MouseEvent)event);
            }
            if (!(listener instanceof MouseMotionListener) || !(event instanceof MouseEvent)) continue;
            ((MouseMotionListener)listener).mouseDragged((MouseEvent)event);
        }
    }
}

