/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.text;

import com.jmorgan.text.LargeNumberFormatRule;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;

public class LargeNumberFormat
extends NumberFormat {
    private ArrayList<LargeNumberFormatRule> formattingRules;
    private String defaultFormat;
    private NumberFormat defaultFormatter;

    public LargeNumberFormat() {
        this.setDefaultFormat("#0");
    }

    public LargeNumberFormat(String defaultFormat) {
        this();
        this.setDefaultFormat(defaultFormat);
    }

    public String getDefaultFormat() {
        return this.defaultFormat;
    }

    public void setDefaultFormat(String defaultFormat) {
        this.defaultFormat = defaultFormat;
        if (this.defaultFormat != null) {
            this.defaultFormatter = new DecimalFormat(defaultFormat);
        }
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (this.formattingRules == null) {
            throw new IllegalStateException("No formatting rules have been set.  You must provide at least one formatting rule for an instance of " + this.getClass().getName());
        }
        for (LargeNumberFormatRule rule : this.formattingRules) {
            if (!rule.appliesToNumber(number)) continue;
            NumberFormat format = rule.getNumberFormat();
            double numberToFormat = rule.getNumberToFormat(number);
            if (rule.getPrefix() != null) {
                toAppendTo.append(rule.getPrefix());
            }
            toAppendTo.append(format.format(numberToFormat));
            if (rule.getSuffix() != null) {
                toAppendTo.append(rule.getSuffix());
            }
            return toAppendTo;
        }
        toAppendTo.append(this.defaultFormatter.format(number));
        return toAppendTo;
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((double)number, toAppendTo, pos);
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        System.out.println("LargeNumberFormat.parse(source, parsePosition)");
        return null;
    }

    public void addLargeNumberFormatRule(LargeNumberFormatRule rule) {
        if (rule == null) {
            return;
        }
        if (this.formattingRules == null) {
            this.formattingRules = new ArrayList();
        }
        this.formattingRules.add(rule);
    }

    public void createStandardFormattingRules(String standardFormat) {
        this.addLargeNumberFormatRule(new LargeNumberFormatRule(1000.0, 999999.0, 1000.0, standardFormat, "K"));
        this.addLargeNumberFormatRule(new LargeNumberFormatRule(1000000.0, 9.99999999E8, 1000000.0, standardFormat, "M"));
        this.addLargeNumberFormatRule(new LargeNumberFormatRule(1.0E9, 9.99999999999E11, 1.0E9, standardFormat, "B"));
        this.addLargeNumberFormatRule(new LargeNumberFormatRule(1.0E12, 9.99999999999999E14, 1.0E12, standardFormat, "T"));
        this.addLargeNumberFormatRule(new LargeNumberFormatRule(-999999.0, -1000.0, 1000.0, standardFormat, "K"));
        this.addLargeNumberFormatRule(new LargeNumberFormatRule(-9.99999999E8, -1000000.0, 1000000.0, standardFormat, "M"));
        this.addLargeNumberFormatRule(new LargeNumberFormatRule(-9.99999999999E11, -1.0E9, 1.0E9, standardFormat, "B"));
        this.addLargeNumberFormatRule(new LargeNumberFormatRule(-9.99999999999999E14, -1.0E12, 1.0E12, standardFormat, "T"));
    }
}

