/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.text;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class LargeNumberFormatRule
extends JMBean
implements Comparable<LargeNumberFormatRule> {
    private double minimum;
    private double maximum;
    private double divisor;
    private String format;
    private String prefix;
    private String suffix;
    private NumberFormat numberFormat;

    public LargeNumberFormatRule() {
        this.setDivisor(1.0);
    }

    public LargeNumberFormatRule(double minimum, double maximum, String format) {
        this(minimum, maximum, 1.0, format, null, null);
    }

    public LargeNumberFormatRule(double minimum, double maximum, double divisor, String format) {
        this(minimum, maximum, divisor, format, null, null);
    }

    public LargeNumberFormatRule(double minimum, double maximum, double divisor, String format, String suffix) {
        this(minimum, maximum, divisor, format, null, suffix);
    }

    public LargeNumberFormatRule(double minimum, double maximum, double divisor, String format, String prefix, String suffix) {
        this();
        this.setMinimum(minimum);
        this.setMaximum(maximum);
        this.setDivisor(divisor);
        this.setFormat(format);
        this.setPrefix(prefix);
        this.setSuffix(suffix);
    }

    public boolean appliesToNumber(double number) {
        return number >= this.minimum && number <= this.maximum;
    }

    public double getNumberToFormat(double number) {
        if (this.divisor == 0.0) {
            return number;
        }
        return number / this.divisor;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    public double getDivisor() {
        return this.divisor;
    }

    public void setDivisor(double divisor) {
        this.divisor = divisor;
    }

    public NumberFormat getNumberFormat() {
        if (this.numberFormat == null && this.format != null) {
            this.numberFormat = new DecimalFormat(this.format);
        }
        return this.numberFormat;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.numberFormat = null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public int compareTo(LargeNumberFormatRule that) {
        if (that == null) {
            return 1;
        }
        if (this.equals(that)) {
            return 0;
        }
        int cmp = (int)(this.minimum - that.minimum);
        if (cmp != 0) {
            return cmp;
        }
        cmp = (int)(this.maximum - that.maximum);
        if (cmp != 0) {
            return cmp;
        }
        cmp = (int)(this.divisor - that.divisor);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compare((Comparable)((Object)this.format), (Comparable)((Object)that.format));
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compare((Comparable)((Object)this.prefix), (Comparable)((Object)that.prefix));
        if (cmp != 0) {
            return cmp;
        }
        return this.compare((Comparable)((Object)this.suffix), (Comparable)((Object)that.suffix));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof LargeNumberFormatRule) {
            LargeNumberFormatRule that = (LargeNumberFormatRule)o;
            return this.minimum == that.minimum && this.maximum == that.maximum && this.divisor == that.divisor && this.areEqual(this.format, that.format) && this.areEqual(this.prefix, that.prefix) && this.areEqual(this.suffix, that.suffix);
        }
        return false;
    }

    @Override
    public String toString() {
        return BeanService.toString(this, ", ");
    }
}

