/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.text;

import com.jmorgan.text.Validator;
import com.jmorgan.util.NumberUtility;

public class NumericalRangeValidator
implements Validator {
    private Number minimum;
    private Number maximum;
    private double minimumValue;
    private double maximumValue;

    public NumericalRangeValidator(Number minimum, Number maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Number minimum) {
        this.minimum = minimum;
        this.minimumValue = minimum.doubleValue();
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Number maximum) {
        this.maximum = maximum;
        this.maximumValue = maximum.doubleValue();
    }

    @Override
    public boolean isCompatibleWith(Object value) {
        return value == null || value instanceof Number;
    }

    @Override
    public boolean isValid(Object value) {
        double number = 0.0;
        if (value instanceof Number) {
            number = ((Number)value).doubleValue();
        } else if (value instanceof String && NumberUtility.isNumber((String)value)) {
            number = Double.parseDouble((String)value);
        } else {
            return true;
        }
        return number >= this.minimumValue && number <= this.maximumValue;
    }

    @Override
    public String getValidationInfo() {
        return String.format("The value must be in the range from %d to %d", this.minimum, this.maximum);
    }
}

