/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.tools;

import com.jmorgan.tools.DiffEntry;
import com.jmorgan.tools.DiffSubjectListener;
import com.jmorgan.util.table.Table;
import java.util.ArrayList;

public class DiffTool<SubjectType> {
    protected Table subjects;
    private ArrayList<DiffSubjectListener<SubjectType>> diffSubjectListeners;
    private boolean suppressChangeEvents;

    protected DiffTool() {
    }

    @SafeVarargs
    protected DiffTool(ArrayList<SubjectType> ... subjects) {
        this();
        this.setSubjects(subjects);
    }

    public Table getSubjects() {
        return this.subjects;
    }

    public void setSubjects(ArrayList<SubjectType> ... subjects) {
        this.subjectsChanging();
        if (this.subjects != null) {
            this.subjects.clear();
            if (subjects == null) {
                this.subjects = null;
                this.subjectsChanged();
                return;
            }
        }
        this.subjects = new Table();
        int columns = subjects.length;
        int c = 0;
        while (c < columns) {
            ArrayList<SubjectType> subject = subjects[c];
            int rows = subject.size();
            int r = 0;
            while (r < rows) {
                this.subjects.setValueAt(r, c, subject.get(r));
                ++r;
            }
            ++c;
        }
        this.subjectsChanged();
    }

    private void subjectsChanging() {
        if (this.diffSubjectListeners == null || this.suppressChangeEvents) {
            return;
        }
        for (DiffSubjectListener<SubjectType> listener : this.diffSubjectListeners) {
            listener.diffSubjectsChanging(this, this.subjects);
        }
    }

    private void subjectsChanged() {
        if (this.diffSubjectListeners == null || this.suppressChangeEvents) {
            return;
        }
        for (DiffSubjectListener<SubjectType> listener : this.diffSubjectListeners) {
            listener.diffSubjectsChanged(this, this.subjects);
        }
    }

    public void processDiff() {
        int rows = this.subjects.getRowCount();
        int cols = this.subjects.getColumnCount();
        Table diffTable = new Table(rows, cols);
        int col = 0;
        while (col < cols) {
            int row = 0;
            while (row < rows) {
                Object value = this.subjects.getValueAt(row, col);
                if (value != null) {
                    DiffEntry<Object> diffEntry = new DiffEntry<Object>(value, row);
                    diffTable.setValueAt(row, col, diffEntry);
                }
                ++row;
            }
            ++col;
        }
        System.out.println(diffTable.toString());
        int rowCount = diffTable.getRowCount();
        int colCount = diffTable.getColumnCount();
        int sc = 0;
        int tc = 1;
        while (tc < colCount) {
            int r = 0;
            while (r < rowCount) {
                DiffEntry masterEntry = (DiffEntry)diffTable.getValueAt(r, sc);
                if (masterEntry != null) {
                    int matchingRow = this.findMatchingRow(diffTable, masterEntry, r, tc);
                    if (matchingRow == -1) {
                        int rightIndex;
                        int masterIndex;
                        DiffEntry rightEntry = (DiffEntry)diffTable.getValueAt(r, tc);
                        if (rightEntry != null && (masterIndex = masterEntry.getIndex()) != (rightIndex = rightEntry.getIndex())) {
                            int difference = 0;
                            int targetColumn = 0;
                            if (masterIndex < rightIndex) {
                                difference = rightIndex - masterIndex;
                                targetColumn = tc;
                            } else {
                                difference = masterIndex - rightIndex;
                                targetColumn = sc;
                            }
                            int targetRow = r + difference;
                            diffTable.move(r, targetColumn, rowCount, targetColumn, targetRow, targetColumn);
                            rowCount = diffTable.getRowCount();
                        }
                    } else if (matchingRow > r) {
                        diffTable.move(r, sc, rowCount, sc, matchingRow, sc);
                        rowCount = diffTable.getRowCount();
                        System.out.println(diffTable.toString());
                    } else if (matchingRow < r) {
                        diffTable.move(matchingRow, tc, rowCount, tc, r, tc);
                        rowCount = diffTable.getRowCount();
                        System.out.println(diffTable.toString());
                    }
                }
                ++r;
            }
            ++tc;
        }
        diffTable.truncateRows();
        rowCount = diffTable.getRowCount();
        int r = rowCount - 1;
        while (r >= 0) {
            if (diffTable.isRowEmpty(r)) {
                diffTable.deleteRow(r);
            }
            --r;
        }
        System.out.println(diffTable.toString());
    }

    private int findMatchingRow(Table diffTable, DiffEntry<SubjectType> masterEntry, int row, int col) {
        int rowCount = diffTable.getRowCount();
        int nextColumn = col;
        int masterEntryHash = masterEntry.getHash();
        DiffEntry nextEntry = null;
        DiffEntry prevEntry = null;
        int forwardRow = row;
        int reverseRow = row - 1;
        while (forwardRow < rowCount || reverseRow >= 0) {
            if (forwardRow < rowCount && (nextEntry = (DiffEntry)diffTable.getValueAt(forwardRow, nextColumn)) != null && masterEntryHash == nextEntry.getHash()) {
                return forwardRow;
            }
            if (reverseRow >= 0 && (prevEntry = (DiffEntry)diffTable.getValueAt(reverseRow, nextColumn)) != null && masterEntryHash == prevEntry.getHash()) {
                return reverseRow;
            }
            ++forwardRow;
            --reverseRow;
        }
        return -1;
    }

    public void addDiffSubjectListener(DiffSubjectListener<SubjectType> listener) {
        if (listener == null) {
            return;
        }
        if (this.diffSubjectListeners == null) {
            this.diffSubjectListeners = new ArrayList();
        }
        this.diffSubjectListeners.add(listener);
    }

    public void removeDiffSubjectListener(DiffSubjectListener<SubjectType> listener) {
        if (listener == null) {
            return;
        }
        if (this.diffSubjectListeners == null || this.diffSubjectListeners.size() == 0) {
            return;
        }
        this.diffSubjectListeners.remove(listener);
    }
}

