/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.AnyObjectComparator;
import java.util.Collection;

public final class Comparison {
    private static AnyObjectComparator objComparator = new AnyObjectComparator();

    private Comparison() {
    }

    public static boolean isBetween(byte value, byte min, byte max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(short value, short min, short max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(char value, char min, char max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(long value, long min, long max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(float value, float min, float max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(Object value, Object min, Object max) {
        int minCmp = objComparator.compare(value, min);
        if (minCmp == 0) {
            return true;
        }
        int maxCmp = objComparator.compare(value, max);
        if (maxCmp == 0) {
            return true;
        }
        return minCmp > 0 && maxCmp < 0;
    }

    public static boolean isBetweenIgnoreCase(String value, String min, String max) {
        int minCmp = value.compareToIgnoreCase(min);
        if (minCmp == 0) {
            return true;
        }
        int maxCmp = value.compareToIgnoreCase(max);
        if (maxCmp == 0) {
            return true;
        }
        return minCmp > 0 && maxCmp < 0;
    }

    public static boolean isIn(byte v, byte[] list) {
        if (ArrayUtility.isEmpty(list)) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (v == list[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIn(char v, char[] list) {
        if (ArrayUtility.isEmpty(list)) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (v == list[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIn(short v, short[] list) {
        if (ArrayUtility.isEmpty(list)) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (v == list[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIn(int v, int[] list) {
        if (ArrayUtility.isEmpty(list)) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (v == list[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIn(long v, long[] list) {
        if (ArrayUtility.isEmpty(list)) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (v == list[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIn(float v, float[] list) {
        if (ArrayUtility.isEmpty(list)) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (v == list[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIn(double v, double[] list) {
        if (ArrayUtility.isEmpty(list)) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (v == list[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isInIgnoreCase(String s, String[] list) {
        if (ArrayUtility.isEmpty(list)) {
            return false;
        }
        if (s != null) {
            s = s.toLowerCase();
        }
        int i = 0;
        while (i < list.length) {
            if (s.equalsIgnoreCase(list[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <T> boolean isIn(T v, T[] list) {
        if (ArrayUtility.isEmpty(list)) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (v == null && list[i] == null) {
                return true;
            }
            if (v != null && v.equals(list[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <T> boolean isIn(T v, Collection<T> list) {
        if (CollectionUtility.isEmpty(list)) {
            return false;
        }
        for (T o : list) {
            if (o == null && v == null) {
                return true;
            }
            if (v == null || !v.equals(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(String source, String[] prefixes) {
        if (StringUtility.isEmpty(source) || ArrayUtility.isEmpty(prefixes)) {
            return false;
        }
        boolean matches = false;
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (prefix != null && source.startsWith(prefix)) {
                matches = true;
                break;
            }
            ++n2;
        }
        return matches;
    }
}

