/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import java.text.DecimalFormat;

public final class NumberUtility {
    private static final String[] TENS_NAMES = new String[]{"", " ten", " twenty", " thirty", " forty", " fifty", " sixty", " seventy", " eighty", " ninety"};
    private static final String[] NUM_NAMES = new String[]{"", " one", " two", " three", " four", " five", " six", " seven", " eight", " nine", " ten", " eleven", " twelve", " thirteen", " fourteen", " fifteen", " sixteen", " seventeen", " eighteen", " nineteen"};

    private NumberUtility() {
    }

    public boolean isBoolean(String s) {
        if (s == null) {
            return false;
        }
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("no");
    }

    public static boolean isNumber(String s) {
        return NumberUtility.isDouble(s);
    }

    public static boolean isInteger(String s) {
        if (s == null) {
            return false;
        }
        try {
            Integer.parseInt(s.trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isLong(String s) {
        if (s == null) {
            return false;
        }
        try {
            Long.parseLong(s.trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isFloat(String s) {
        if (s == null) {
            return false;
        }
        try {
            Float.parseFloat(s);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isDouble(String s) {
        if (s == null) {
            return false;
        }
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static byte[] getBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
        return bytes;
    }

    public static byte[] getBytes(long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
        return bytes;
    }

    public static String convertToText(long number) {
        if (number == 0L) {
            return "zero";
        }
        String snumber = Long.toString(number);
        String mask = "000000000000";
        DecimalFormat df = new DecimalFormat(mask);
        snumber = df.format(number);
        int billions = Integer.parseInt(snumber.substring(0, 3));
        int millions = Integer.parseInt(snumber.substring(3, 6));
        int hundredThousands = Integer.parseInt(snumber.substring(6, 9));
        int thousands = Integer.parseInt(snumber.substring(9, 12));
        Object result = switch (billions) {
            case 0 -> "";
            case 1 -> NumberUtility.convertLessThanOneThousand(billions) + " billion ";
            default -> NumberUtility.convertLessThanOneThousand(billions) + " billion ";
        };
        result = (String)result + (String)(switch (millions) {
            case 0 -> "";
            case 1 -> NumberUtility.convertLessThanOneThousand(millions) + " million ";
            default -> NumberUtility.convertLessThanOneThousand(millions) + " million ";
        });
        result = (String)result + (String)(switch (hundredThousands) {
            case 0 -> "";
            case 1 -> "one thousand ";
            default -> NumberUtility.convertLessThanOneThousand(hundredThousands) + " thousand ";
        });
        String tradThousand = NumberUtility.convertLessThanOneThousand(thousands);
        result = (String)result + tradThousand;
        return ((String)result).replaceAll("^\\s+", "").replaceAll("\\b\\s{2,}\\b", " ");
    }

    private static String convertLessThanOneThousand(int number) {
        Object soFar;
        if (number < 0) {
            number = 0;
        }
        if (number % 100 < 20) {
            soFar = NUM_NAMES[number % 100];
            number /= 100;
        } else {
            soFar = NUM_NAMES[number % 10];
            soFar = TENS_NAMES[(number /= 10) % 10] + (String)soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return NUM_NAMES[number] + " hundred" + (String)soFar;
    }
}

