/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.beans.JMBean;

public class TimeProfiler
extends JMBean {
    public static final int NANOSECOND_ACCURACY = 0;
    public static final int MILLISECOND_ACCURACY = 1;
    private long sessionTime;
    private String sessionName;
    private long lastCheckpoint;
    private int accuracy;
    private String accuracyDisplay;

    public TimeProfiler() {
        this("Time Profiler", 0);
    }

    public TimeProfiler(int accuracy) {
        this("Time Profiler", accuracy);
    }

    public TimeProfiler(String sessionName) {
        this(sessionName, 0);
    }

    public TimeProfiler(String sessionName, int accuracy) {
        this.setAccuracy(accuracy);
        this.lastCheckpoint = this.sessionTime = this.getTime();
        this.sessionName = sessionName;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(int accuracy) {
        if (accuracy != this.accuracy) {
            if (this.accuracy == 0) {
                this.sessionTime /= 1000L;
                this.lastCheckpoint /= 1000L;
            } else {
                this.sessionTime *= 1000L;
                this.lastCheckpoint *= 1000L;
            }
        }
        switch (accuracy) {
            case 1: {
                this.accuracy = accuracy;
                this.accuracyDisplay = "ms";
                break;
            }
            default: {
                this.accuracy = accuracy;
                this.accuracyDisplay = "ns";
            }
        }
    }

    public long getCheckpoint() {
        long now = this.getTime();
        long elapsed = now - this.lastCheckpoint;
        this.lastCheckpoint = now;
        return elapsed;
    }

    public long getSessionTime() {
        long now = this.getTime();
        return now - this.sessionTime;
    }

    private long getTime() {
        return this.accuracy == 0 ? System.nanoTime() : System.currentTimeMillis();
    }

    public long showCheckpoint(String message) {
        long checkPoint = this.getCheckpoint();
        System.out.printf("%s checkpoint - %s: %d%s\n", this.sessionName, message, checkPoint, this.accuracyDisplay);
        return checkPoint;
    }

    public long showSessionTime(String message) {
        long sessionTime = this.getSessionTime();
        System.out.printf("%s session time - %s: %d%s\n", this.sessionName, message, sessionTime, this.accuracyDisplay);
        return sessionTime;
    }
}

