/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Vector;

public abstract class CachedCollection<E>
implements Collection<E> {
    protected static final int _defaultCapacity = 1000;
    protected int capacity;
    protected int size;
    protected Vector<E> localQueue;
    protected Vector<File> cacheFiles;

    protected CachedCollection() {
        this(1000);
    }

    protected CachedCollection(int capacity) {
        this.setCapacity(capacity);
        this.localQueue = new Vector(capacity);
        this.cacheFiles = new Vector(capacity);
        this.size = 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getActiveSize() {
        return this.localQueue.size();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void setCapacity(int capacity) {
        if (capacity < 10) {
            throw new IllegalArgumentException("CachedCollection.setCapacity(capacity = " + capacity + "): Capacity cannot be less than 10");
        }
        this.capacity = capacity;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            return false;
        }
        this.localQueue.add(e);
        ++this.size;
        if (this.localQueue.size() == this.capacity) {
            this.saveList();
        }
        return true;
    }

    public void add(int index, E element) {
        throw new UnsupportedOperationException("CachedCollection.add(int, Object) is not supported by cached collections");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    public boolean addAll(int index, Collection<? extends E> collection) {
        for (E e : collection) {
            this.add(index, e);
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.localQueue.clear();
        for (File file : this.cacheFiles) {
            file.delete();
        }
    }

    @Override
    public E[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        if (this.size == 0) {
            return false;
        }
        for (E element : this.localQueue) {
            if (!element.equals(o)) continue;
            return true;
        }
        for (File file : this.cacheFiles) {
            Vector<E> cache = this.loadFromFile(file);
            for (E element : cache) {
                if (!element.equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    protected Vector<E> loadFromFile(File file) {
        block9: {
            Vector vector;
            if (this.size == 0) {
                return this.localQueue;
            }
            FileInputStream fin = new FileInputStream(file);
            BufferedInputStream bin = new BufferedInputStream(fin, 65535);
            ObjectInputStream ooin = new ObjectInputStream(bin);
            try {
                Vector savedElements;
                vector = savedElements = (Vector)ooin.readObject();
            }
            catch (Throwable throwable) {
                try {
                    ooin.close();
                    bin.close();
                    fin.close();
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    break block9;
                }
                catch (EOFException e) {
                    e.printStackTrace();
                    break block9;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block9;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            ooin.close();
            bin.close();
            fin.close();
            return vector;
        }
        return new Vector();
    }

    private void saveList() {
        if (this.localQueue.size() == 0) {
            return;
        }
        File file = this.createCacheFile();
        this.cacheFiles.add(file);
        try {
            FileOutputStream fout = new FileOutputStream(file, true);
            BufferedOutputStream bout = new BufferedOutputStream(fout, 65535);
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(this.localQueue);
            this.localQueue.clear();
            oout.flush();
            oout.close();
            bout.flush();
            bout.close();
            fout.flush();
            fout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected File createCacheFile() {
        try {
            File file = File.createTempFile(this.getTempFilePrefix(), ".tmp");
            file.deleteOnExit();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract String getTempFilePrefix();
}

