/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.AggregatorFunction;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionService;
import java.util.Collection;

public class CollectionAggregator<T>
extends CollectionService<T> {
    private Index<String, AggregatorFunction<?>> aggregatorFunctionMap = new Index();

    public CollectionAggregator(Collection<T> collection) throws NullPointerException {
        super(collection);
    }

    public void addAggregatorFunction(AggregatorFunction<?> function) {
        this.addAggregatorFunction("*", function);
    }

    public void addAggregatorFunction(String propertyName, AggregatorFunction<?> function) {
        CollectionAggregator.validatePropertyParameter(propertyName);
        if (function == null) {
            throw new NullPointerException("The aggregator function provided to CollectionAggregator.addAggregation() cannot be null.");
        }
        this.aggregatorFunctionMap.put(propertyName, function);
    }

    public Collection<AggregatorFunction<?>> getAggregatorFunctions() {
        return this.getAggregatorFunctions("*");
    }

    public Collection<AggregatorFunction<?>> getAggregatorFunctions(String propertyName) {
        CollectionAggregator.validatePropertyParameter(propertyName);
        Collection<AggregatorFunction<?>> functions = this.aggregatorFunctionMap.get(propertyName);
        return functions;
    }

    private static void validatePropertyParameter(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("The property name provided to CollectionAggregator.addAggregation() cannot be null.");
        }
        if (propertyName.trim().length() == 0) {
            throw new IllegalArgumentException("The property name provided to CollectionAggregator.addAggregation() cannot be blank.");
        }
    }

    public void aggregate() {
        for (String key : this.aggregatorFunctionMap.getKeys()) {
            for (AggregatorFunction<?> function : this.aggregatorFunctionMap.get(key)) {
                function.start();
            }
        }
        this.iterateCollection();
    }

    @Override
    protected void processElement(T element) {
        for (String key : this.aggregatorFunctionMap.getKeys()) {
            for (AggregatorFunction<?> function : this.aggregatorFunctionMap.get(key)) {
                if (key.equals("*")) {
                    function.aggregate(element);
                    continue;
                }
                function.aggregate(BeanService.getPropertyValue(element, key));
            }
        }
    }
}

