/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.comparator.AnyObjectComparator;
import java.util.ArrayList;

class OrderedListNode<E> {
    private static AnyObjectComparator comparator = new AnyObjectComparator();
    private int hashCode;
    private OrderedListNode<E> previousNode;
    private E element;
    private ArrayList<E> equalsNodes = new ArrayList();
    private OrderedListNode<E> nextNode;

    OrderedListNode() {
    }

    OrderedListNode(E element) {
        this();
        this.setHashCode(element == null ? 0 : element.hashCode());
        this.element = element;
        this.equalsNodes.add(element);
    }

    public void addElement(E element) {
        int thatHash = element.hashCode();
        if (this.hashCode == thatHash) {
            this.equalsNodes.add(element);
        } else {
            int cmp = comparator.compare(this.element, element);
            if (cmp < 0) {
                if (this.previousNode == null) {
                    this.previousNode = new OrderedListNode<E>(element);
                } else {
                    this.previousNode.addElement(element);
                }
            } else if (this.nextNode == null) {
                this.nextNode = new OrderedListNode<E>(element);
            } else {
                this.nextNode.addElement(element);
            }
        }
    }

    public E getNodeElement() {
        return this.equalsNodes.get(0);
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public OrderedListNode<E> getPreviousNode() {
        return this.previousNode;
    }

    public void setPreviousNode(OrderedListNode<E> previousNode) {
        this.previousNode = previousNode;
    }

    public ArrayList<E> getEqualsNodes() {
        return this.equalsNodes;
    }

    public void setEqualsNodes(ArrayList<E> equalsNodes) {
        this.equalsNodes = equalsNodes;
    }

    public OrderedListNode<E> getNextNode() {
        return this.nextNode;
    }

    public void setNextNode(OrderedListNode<E> nextNode) {
        this.nextNode = nextNode;
    }
}

