/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.collection.ListNotUniqueException;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.AnyObjectComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public class OrderedSet<E>
extends UniqueArrayList<E>
implements SortedSet<E> {
    private Comparator<? super E> comparator;
    private boolean changeSinceLastSort = false;

    public OrderedSet() {
        this.comparator = this.getDefaultComparator();
    }

    public OrderedSet(Collection<? extends E> c) {
        super(c);
        this.changeSinceLastSort = true;
        this.comparator = this.getDefaultComparator();
    }

    public OrderedSet(Comparator<? super E> comparator) {
        this.setComparator(comparator);
    }

    public OrderedSet(SortedSet<E> set) {
        this.changeSinceLastSort = true;
        this.addAll(set);
        this.setComparator(set.comparator());
    }

    @Override
    public Iterator<E> iterator() {
        System.out.println("OrderedSet.iterator() called");
        this.sort();
        return super.iterator();
    }

    @Override
    public boolean add(E o) {
        this.changeSinceLastSort = true;
        return super.add(o);
    }

    @Override
    public void add(int index, E element) {
        this.changeSinceLastSort = true;
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.changeSinceLastSort = true;
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.changeSinceLastSort = true;
        return super.addAll(index, c);
    }

    @Override
    public E set(int index, E element) {
        this.changeSinceLastSort = true;
        return super.set(index, element);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.getComparator();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        boolean started = false;
        this.sort();
        OrderedSet<E> subset = new OrderedSet<E>(this.getComparator());
        for (E e : this) {
            if (!started && e.equals(fromElement)) {
                started = true;
            }
            if (!started) continue;
            subset.add(e);
            if (!e.equals(toElement)) continue;
            return subset;
        }
        return subset;
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.subSet(this.get(0), toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.subSet(fromElement, this.get(this.size() - 1));
    }

    @Override
    public E first() {
        this.sort();
        return this.get(0);
    }

    @Override
    public E last() {
        this.sort();
        return this.get(this.size() - 1);
    }

    public Comparator<? super E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<? super E> comparator) {
        this.comparator = comparator == null ? this.getDefaultComparator() : comparator;
    }

    @Override
    public void sort() {
        if (this.comparator == null) {
            return;
        }
        if (this.changeSinceLastSort) {
            try {
                this.setUniqueAssurancePolicy(false);
                Collections.sort(this, this.comparator);
                this.setUniqueAssurancePolicy(true);
                this.changeSinceLastSort = false;
            }
            catch (ListNotUniqueException e) {
                e.printStackTrace();
            }
        }
    }

    private Comparator<? super E> getDefaultComparator() {
        return new AnyObjectComparator(1);
    }
}

