/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.comparator;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.comparator.AbstractComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class BeanComparator<T>
extends AbstractComparator<T> {
    private ArrayList<String> compareProperties = new ArrayList();

    public BeanComparator() {
    }

    public BeanComparator(Collection<String> properties) {
        this();
        this.compareProperties.addAll(properties);
    }

    public BeanComparator(String ... properties) {
        this(Arrays.asList(properties));
    }

    public void addCompareProperties(String ... properties) {
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            this.addCompareProperty(property);
            ++n2;
        }
    }

    public void addCompareProperty(String property) {
        if (property == null) {
            throw new NullPointerException("The property cannot be null in BeanComparator.addCompareProperty()");
        }
        this.compareProperties.add(property);
    }

    public void clearCompareProperties() {
        this.compareProperties.clear();
    }

    public ArrayList<String> getCompareProperties() {
        return this.compareProperties;
    }

    public void setCompareProperties(Collection<String> compareProperties) {
        if (compareProperties == null) {
            throw new IllegalArgumentException("The compare properties list cannot be null");
        }
        this.compareProperties = new ArrayList<String>(compareProperties);
    }

    public void setCompareProperties(String[] compareProperties) {
        this.setCompareProperties(Arrays.asList(compareProperties));
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int c = super.compare(o1, o2);
        if (c != 0) {
            return c;
        }
        ArrayList<String> propertyLooper = new ArrayList<String>(this.compareProperties);
        for (String property : propertyLooper) {
            boolean ascending = true;
            if (property.charAt(0) == '-') {
                ascending = false;
                property = property.substring(1);
            }
            Comparable value1 = null;
            Comparable value2 = null;
            value1 = o1 instanceof DynamicBean ? (Comparable)((DynamicBean)o1).getProperty(property) : (Comparable)BeanService.getPropertyValue(o1, property);
            value2 = o2 instanceof DynamicBean ? (Comparable)((DynamicBean)o2).getProperty(property) : (Comparable)BeanService.getPropertyValue(o2, property);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1.equals(value2)) continue;
            int cmp = value1.compareTo(value2);
            if (!ascending) {
                cmp *= -1;
            }
            return cmp;
        }
        return 0;
    }
}

