/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.logging;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.logging.LMG;
import com.jmorgan.util.logging.StandardConsoleHandler;
import com.jmorgan.util.logging.StandardLogFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class LoggingConfig {
    private static Logger rootLogger;
    private static StandardLogFormatter formatter;
    private static StandardConsoleHandler consoleHandler;

    private LoggingConfig() {
    }

    public static void initialize() {
        LogManager.getLogManager().reset();
        rootLogger = Logger.getLogger("");
        rootLogger.setLevel(Level.ALL);
        formatter = new StandardLogFormatter();
        consoleHandler = new StandardConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(formatter);
        rootLogger.addHandler(consoleHandler);
        rootLogger.fine("Logging Initialized.");
        new AsynchMethodInvoker(LoggingConfig.class, "unifyAllLoggers", 5000);
    }

    public static Logger getRootLogger() {
        return rootLogger;
    }

    public static StandardLogFormatter getFormatter() {
        if (formatter == null) {
            formatter = new StandardLogFormatter();
        }
        return formatter;
    }

    public static StandardConsoleHandler getConsoleHandler() {
        if (consoleHandler == null) {
            consoleHandler = new StandardConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
        }
        return consoleHandler;
    }

    public static void setLogLevel(Level level) {
        if (rootLogger != null) {
            rootLogger.setLevel(level);
            consoleHandler.setLevel(level);
        }
    }

    public static void setFilter(Filter filter) {
        rootLogger.setFilter(filter);
    }

    @Reflected
    private static void unifyAllLoggers() {
        ArrayList loggerNames = new ArrayList();
        LogManager.getLogManager().getLoggerNames().asIterator().forEachRemaining(name -> {
            if (name.startsWith("com.jmorgan") || name.startsWith("com.kumbasoft")) {
                loggerNames.add(name);
            }
        });
        Collections.sort(loggerNames);
        for (String name2 : loggerNames) {
            Logger logger = Logger.getLogger(name2);
            boolean usesParentHandlers = logger.getUseParentHandlers();
            int handlerCount = logger.getHandlers().length;
            rootLogger.finer(() -> LMG.log("(): %-40s useParent=%-5s handlers=%d filters=%b", () -> name2, () -> usesParentHandlers, () -> handlerCount, () -> logger.getFilter() != null));
            if (!usesParentHandlers) {
                logger.setUseParentHandlers(true);
            }
            if (handlerCount != 0) continue;
            logger.addHandler(consoleHandler);
        }
    }
}

