/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.queue;

import com.jmorgan.util.collection.CachedCollection;
import com.jmorgan.util.queue.FIFOQueueIterator;
import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Vector;

public class FIFOQueue<E>
extends CachedCollection<E>
implements Queue<E> {
    private Vector<E> readQueue;

    public FIFOQueue() {
        this(1000);
    }

    public FIFOQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public E element() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("FIFOQueue is empty");
        }
        E element = null;
        try {
            if (this.readQueue == null && this.cacheFiles.size() > 0) {
                this.readQueue = this.loadFromFile((File)this.cacheFiles.remove(0));
            }
            element = this.readQueue == null ? (E)this.localQueue.get(0) : (E)this.readQueue.get(0);
            return element;
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("FIFOQueue is empty");
        }
    }

    @Override
    public E peek() {
        try {
            return this.element();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public E poll() {
        E element = null;
        try {
            if (this.readQueue == null && this.cacheFiles.size() > 0) {
                this.readQueue = this.loadFromFile((File)this.cacheFiles.remove(0));
            }
            if (this.readQueue == null) {
                element = this.remove();
            } else {
                element = this.readQueue.remove(0);
                if (this.readQueue.size() == 0) {
                    this.readQueue = null;
                }
                --this.size;
            }
            return element;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public E remove() {
        if (this.size == 0) {
            throw new NoSuchElementException("FIFOQueue is empty");
        }
        if (this.localQueue.size() == 0 && this.cacheFiles.size() > 0) {
            this.localQueue = this.loadFromFile((File)this.cacheFiles.remove(0));
            if (this.localQueue.size() == 0) {
                throw new NoSuchElementException("FIFOQueue is empty");
            }
        }
        --this.size;
        return this.localQueue.remove(0);
    }

    @Override
    public Iterator<E> iterator() {
        return new FIFOQueueIterator(this);
    }

    @Override
    protected String getTempFilePrefix() {
        return "fifoq";
    }
}

