/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.config.ConfigErrorReportSettings;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ListFiles;
import java.util.Vector;

public class ErrorReportInfo
extends AbstractTool {
    private Appliance appliance;
    private String uploadDirectory;
    private Vector<DataPowerFileInfo> errorReportFiles;

    public ErrorReportInfo(Appliance appliance) {
        AbstractTool.logger.finer(() -> LMG.log("(Appliance=%s):  Starting.", () -> appliance.getName()));
        this.appliance = appliance;
        Domain defaultDomain = appliance.getDomain("default");
        ConfigurationManager configurationManager = new ConfigurationManager();
        ConfigErrorReportSettings errorReportSettings = (ConfigErrorReportSettings)configurationManager.getObject(appliance, defaultDomain, "ErrorReportSettings", "Error-Report");
        this.uploadDirectory = "temporary:/";
        String fileStore = "temporary:";
        String uploadReport = errorReportSettings.getUploadReport();
        AbstractTool.logger.finer(() -> LMG.log("(Appliance=%s):  Upload report is %s.", () -> appliance.getName(), () -> uploadReport));
        if (uploadReport.equals("on")) {
            String uploadProtocol = errorReportSettings.getProtocol();
            AbstractTool.logger.finer(() -> LMG.log("(Appliance=%s):  Upload report protocol is %s.", () -> appliance.getName(), () -> uploadProtocol));
            if (uploadProtocol.equals("raid")) {
                String raidVolume = errorReportSettings.getRaidVolume().getName();
                String raidVolumePath = errorReportSettings.getRaidPath();
                this.uploadDirectory = String.format("local:/%s/%s/", raidVolume, raidVolumePath);
                fileStore = "local:";
            }
        }
        AbstractTool.logger.finer(() -> LMG.log("(Appliance=%s):  Upload directory %s.  Looking for files.", () -> appliance.getName(), () -> this.uploadDirectory));
        ConfigObjectCache<DataPowerFileInfo> fileCache = new ConfigObjectCache<DataPowerFileInfo>();
        this.loadFiles(fileStore, fileCache);
        AbstractTool.logger.finer(() -> LMG.log("(Appliance=%s):  Found %d files in %s.  Also checking temporary:", () -> appliance.getName(), () -> fileCache.getObjectCache().size(), () -> this.uploadDirectory));
        if (!fileStore.equals("temporary:")) {
            this.loadFiles("temporary:", fileCache);
        }
        AbstractTool.logger.finer(() -> LMG.log("(Appliance=%s):  Found a total of %d files.", () -> appliance.getName(), () -> fileCache.getObjectCache().size(), () -> this.uploadDirectory));
        this.errorReportFiles = fileCache.getObjectCache();
        AbstractTool.logger.finer(() -> LMG.log("(Appliance=%s):  Found %d error reports", () -> appliance.getName(), () -> this.errorReportFiles.size()));
    }

    private void loadFiles(String fileStore, ConfigObjectCache<DataPowerFileInfo> fileCache) {
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        AbstractTool.logger.finer(() -> LMG.log("(fileStore=%s, fileCache):  Starting for appliance %s", () -> fileStore, () -> this.getAppliance().getName()));
        ListFiles listFiles = new ListFiles(this.appliance, this.appliance.getDomain("default"), fileStore, "error-report(.*?)\\.txt\\.gz");
        listFiles.getProcessThread().addInvocationListener(stil);
        listFiles.addConfigObjectSubscriber(DataPowerFileInfo.class, fileCache);
        stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        AbstractTool.logger.finer(() -> LMG.log("(fileStore=%s, fileCache):  Found %d for appliance %s", () -> fileStore, () -> fileCache.getObjectCache().size(), () -> this.getAppliance().getName()));
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public String getUploadDirectory() {
        return this.uploadDirectory;
    }

    public Vector<DataPowerFileInfo> getErrorReportFiles() {
        return this.errorReportFiles;
    }
}

