/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.config.ConfigCryptoKey;
import com.kumbasoft.core.beans.config.ConfigCryptoSSKey;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.JWTClaims;
import com.kumbasoft.core.beans.types.JWTGenMethod;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigAAAJWTGenerator
extends ConfigCrypto {
    private String userSummary;
    private String issuer;
    private long duration;
    private JWTClaims additionalClaims;
    private ArrayList<String> audience;
    private int notBefore;
    private String customClaims;
    private JWTGenMethod genMethod;
    private String signAlgorithm;
    private ObjectReference<ConfigCryptoKey> signKey;
    private ObjectReference<ConfigCryptoSSKey> signSSKey;
    private String encAlgorithm;
    private String encryptAlgorithm;
    private ObjectReference<ConfigCryptoCertificate> encryptCertificate;
    private ObjectReference<ConfigCryptoSSKey> encryptSSKey;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Issuer", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="iss", refType="", isEnumeration=false, javaName="issuer", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=256, validationRegex="", allowedValues={}, defaultValue="idg", displayOrder=0, displayValue="Issuer", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getIssuer() {
        return this.issuer;
    }

    @XMLInfo(elementType="element", elementName="Issuer", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="iss", refType="", isEnumeration=false, javaName="issuer", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=256, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="idg", displayValue="Issuer", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @XMLInfo(elementType="element", elementName="Duration", elementOrder=3, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="duration", refType="", isEnumeration=false, javaName="duration", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=31622400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="3600", displayOrder=0, displayValue="Validity period", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getDuration() {
        return this.duration;
    }

    @XMLInfo(elementType="element", elementName="Duration", elementOrder=3, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="duration", refType="", isEnumeration=false, javaName="duration", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=31622400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="3600", displayValue="Validity period", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @XMLInfo(elementType="element", elementName="AdditionalClaims", elementOrder=4, dataPowerType="dmJWTClaims", subType="", benign=false, isPassword=false, cliAlias="add-claims", refType="", isEnumeration=false, javaName="additionalClaims", javaType="JWTClaims", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Additional claims", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public JWTClaims getAdditionalClaims() {
        return this.additionalClaims;
    }

    @XMLInfo(elementType="element", elementName="AdditionalClaims", elementOrder=4, dataPowerType="dmJWTClaims", subType="", benign=false, isPassword=false, cliAlias="add-claims", refType="", isEnumeration=false, javaName="additionalClaims", javaType="JWTClaims", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Additional claims", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdditionalClaims(JWTClaims additionalClaims) {
        this.additionalClaims = additionalClaims;
    }

    public void addAudience(String element) {
        if (element == null) {
            return;
        }
        if (this.audience == null) {
            this.audience = new ArrayList();
        }
        this.audience.add(element);
    }

    public boolean removeAudience(String element) {
        if (element == null || this.audience == null) {
            return false;
        }
        return this.audience.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Audience", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="aud", refType="", isEnumeration=false, javaName="audience", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=256, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Audience claim", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getAudience() {
        return this.audience;
    }

    @XMLInfo(elementType="element", elementName="Audience", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="aud", refType="", isEnumeration=false, javaName="audience", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=256, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Audience claim", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAudience(ArrayList<String> audience) {
        this.audience = audience;
    }

    @XMLInfo(elementType="element", elementName="NotBefore", elementOrder=6, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="nbf", refType="", isEnumeration=false, javaName="notBefore", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=480L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Delta for not before claim", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getNotBefore() {
        return this.notBefore;
    }

    @XMLInfo(elementType="element", elementName="NotBefore", elementOrder=6, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="nbf", refType="", isEnumeration=false, javaName="notBefore", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=480L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Delta for not before claim", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNotBefore(int notBefore) {
        this.notBefore = notBefore;
    }

    @XMLInfo(elementType="element", elementName="CustomClaims", elementOrder=7, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="custom-claims", refType="", isEnumeration=false, javaName="customClaims", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom claims", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCustomClaims() {
        return this.customClaims;
    }

    @XMLInfo(elementType="element", elementName="CustomClaims", elementOrder=7, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="custom-claims", refType="", isEnumeration=false, javaName="customClaims", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom claims", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCustomClaims(String customClaims) {
        this.customClaims = customClaims;
    }

    @XMLInfo(elementType="element", elementName="GenMethod", elementOrder=8, dataPowerType="dmJWTGenMethod", subType="", benign=false, isPassword=false, cliAlias="generate-method", refType="", isEnumeration=false, javaName="genMethod", javaType="JWTGenMethod", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="JWT generation method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public JWTGenMethod getGenMethod() {
        return this.genMethod;
    }

    @XMLInfo(elementType="element", elementName="GenMethod", elementOrder=8, dataPowerType="dmJWTGenMethod", subType="", benign=false, isPassword=false, cliAlias="generate-method", refType="", isEnumeration=false, javaName="genMethod", javaType="JWTGenMethod", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="JWT generation method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGenMethod(JWTGenMethod genMethod) {
        this.genMethod = genMethod;
    }

    @XMLInfo(elementType="element", elementName="SignAlgorithm", elementOrder=9, dataPowerType="dmJWSSignAlgorithm", subType="", benign=false, isPassword=false, cliAlias="sign-alg", refType="", isEnumeration=true, javaName="signAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="RS256", displayOrder=0, displayValue="Signing algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="SignAlgorithm", elementOrder=9, dataPowerType="dmJWSSignAlgorithm", subType="", benign=false, isPassword=false, cliAlias="sign-alg", refType="", isEnumeration=true, javaName="signAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="RS256", displayValue="Signing algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSignAlgorithm(String signAlgorithm) {
        if (signAlgorithm == null || Comparison.isIn(signAlgorithm, DPEnumerations.JWSSIGN_ALGORITHM)) {
            this.signAlgorithm = signAlgorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="SignKey", elementOrder=10, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sign-key", refType="CryptoKey", isEnumeration=false, javaName="signKey", javaType="ObjectReference<ConfigCryptoKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Signing key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoKey> getSignKey() {
        return this.signKey;
    }

    @XMLInfo(elementType="element", elementName="SignKey", elementOrder=10, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sign-key", refType="CryptoKey", isEnumeration=false, javaName="signKey", javaType="ObjectReference<ConfigCryptoKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Signing key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSignKey(ObjectReference<ConfigCryptoKey> signKey) {
        this.signKey = signKey;
    }

    @XMLInfo(elementType="element", elementName="SignSSKey", elementOrder=11, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sign-sskey", refType="CryptoSSKey", isEnumeration=false, javaName="signSSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Signing shared secret", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoSSKey> getSignSSKey() {
        return this.signSSKey;
    }

    @XMLInfo(elementType="element", elementName="SignSSKey", elementOrder=11, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sign-sskey", refType="CryptoSSKey", isEnumeration=false, javaName="signSSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Signing shared secret", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSignSSKey(ObjectReference<ConfigCryptoSSKey> signSSKey) {
        this.signSSKey = signSSKey;
    }

    @XMLInfo(elementType="element", elementName="EncAlgorithm", elementOrder=12, dataPowerType="dmJWEEncAlgorithm", subType="", benign=false, isPassword=false, cliAlias="enc", refType="", isEnumeration=true, javaName="encAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="A128CBC-HS256", displayOrder=0, displayValue="Encryption algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncAlgorithm() {
        return this.encAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="EncAlgorithm", elementOrder=12, dataPowerType="dmJWEEncAlgorithm", subType="", benign=false, isPassword=false, cliAlias="enc", refType="", isEnumeration=true, javaName="encAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="A128CBC-HS256", displayValue="Encryption algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncAlgorithm(String encAlgorithm) {
        if (encAlgorithm == null || Comparison.isIn(encAlgorithm, DPEnumerations.JWEENC_ALGORITHM)) {
            this.encAlgorithm = encAlgorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="EncryptAlgorithm", elementOrder=13, dataPowerType="dmJWEKeyAlgorithm", subType="", benign=false, isPassword=false, cliAlias="enc-alg", refType="", isEnumeration=true, javaName="encryptAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="RSA1_5", displayOrder=0, displayValue="Key management algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncryptAlgorithm() {
        return this.encryptAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="EncryptAlgorithm", elementOrder=13, dataPowerType="dmJWEKeyAlgorithm", subType="", benign=false, isPassword=false, cliAlias="enc-alg", refType="", isEnumeration=true, javaName="encryptAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="RSA1_5", displayValue="Key management algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptAlgorithm(String encryptAlgorithm) {
        if (encryptAlgorithm == null || Comparison.isIn(encryptAlgorithm, DPEnumerations.JWEKEY_ALGORITHM)) {
            this.encryptAlgorithm = encryptAlgorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="EncryptCertificate", elementOrder=14, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="enc-cert", refType="CryptoCertificate", isEnumeration=false, javaName="encryptCertificate", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Encryption certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoCertificate> getEncryptCertificate() {
        return this.encryptCertificate;
    }

    @XMLInfo(elementType="element", elementName="EncryptCertificate", elementOrder=14, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="enc-cert", refType="CryptoCertificate", isEnumeration=false, javaName="encryptCertificate", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Encryption certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptCertificate(ObjectReference<ConfigCryptoCertificate> encryptCertificate) {
        this.encryptCertificate = encryptCertificate;
    }

    @XMLInfo(elementType="element", elementName="EncryptSSKey", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="enc-sskey", refType="CryptoSSKey", isEnumeration=false, javaName="encryptSSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Encryption key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoSSKey> getEncryptSSKey() {
        return this.encryptSSKey;
    }

    @XMLInfo(elementType="element", elementName="EncryptSSKey", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="enc-sskey", refType="CryptoSSKey", isEnumeration=false, javaName="encryptSSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Encryption key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptSSKey(ObjectReference<ConfigCryptoSSKey> encryptSSKey) {
        this.encryptSSKey = encryptSSKey;
    }

    @Override
    public int compareTo(ConfigAAAJWTGenerator that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "issuer", "duration", "additionalClaims", "audience", "notBefore", "customClaims", "genMethod", "signAlgorithm", "signKey", "signSSKey", "encAlgorithm", "encryptAlgorithm", "encryptCertificate", "encryptSSKey");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.issuer, this.duration, this.additionalClaims, this.audience, this.notBefore, this.customClaims, this.genMethod, this.signAlgorithm, this.signKey, this.signSSKey, this.encAlgorithm, this.encryptAlgorithm, this.encryptCertificate, this.encryptSSKey);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "issuer", "duration", "additionalClaims", "audience", "notBefore", "customClaims", "genMethod", "signAlgorithm", "signKey", "signSSKey", "encAlgorithm", "encryptAlgorithm", "encryptCertificate", "encryptSSKey");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "issuer", "duration", "additionalClaims", "audience", "notBefore", "customClaims", "genMethod", "signAlgorithm", "signKey", "signSSKey", "encAlgorithm", "encryptAlgorithm", "encryptCertificate", "encryptSSKey"));
    }
}

