/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.config.ConfigXMLManager;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigAMQPBroker
extends ConfigConfigBase {
    private String userSummary;
    private String hostName;
    private int port;
    private ObjectReference<ConfigXMLManager> xMLManager;
    private String containerID;
    private String authorization;
    private String userName;
    private ObjectReference<ConfigPasswordAlias> passwordAlias;
    private long maximumFrameSize;
    private String autoRetry;
    private int retryInterval;
    private int retryAttempts;
    private int longRetryInterval;
    private int reportingInterval;
    private ObjectReference<ConfigSSLClientProfile> sSLClient;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="HostName", elementOrder=2, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="hostname", refType="", isEnumeration=false, javaName="hostName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHostName() {
        return this.hostName;
    }

    @XMLInfo(elementType="element", elementName="HostName", elementOrder=2, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="hostname", refType="", isEnumeration=false, javaName="hostName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @XMLInfo(elementType="element", elementName="Port", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="port", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="5672", displayOrder=0, displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getPort() {
        return this.port;
    }

    @XMLInfo(elementType="element", elementName="Port", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="port", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="5672", displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPort(int port) {
        this.port = port;
    }

    @XMLInfo(elementType="element", elementName="XMLManager", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xml-manager", refType="XMLManager", isEnumeration=false, javaName="xMLManager", javaType="ObjectReference<ConfigXMLManager>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default", displayOrder=0, displayValue="XML manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigXMLManager> getXMLManager() {
        return this.xMLManager;
    }

    @XMLInfo(elementType="element", elementName="XMLManager", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xml-manager", refType="XMLManager", isEnumeration=false, javaName="xMLManager", javaType="ObjectReference<ConfigXMLManager>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default", displayValue="XML manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXMLManager(ObjectReference<ConfigXMLManager> xMLManager) {
        this.xMLManager = xMLManager;
    }

    @XMLInfo(elementType="element", elementName="ContainerID", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="container-id", refType="", isEnumeration=false, javaName="containerID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="AMQP container ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getContainerID() {
        return this.containerID;
    }

    @XMLInfo(elementType="element", elementName="ContainerID", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="container-id", refType="", isEnumeration=false, javaName="containerID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="AMQP container ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    @XMLInfo(elementType="element", elementName="Authorization", elementOrder=6, dataPowerType="dmAMQPAuthorization", subType="", benign=false, isPassword=false, cliAlias="authorization", refType="", isEnumeration=true, javaName="authorization", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="none", displayOrder=0, displayValue="Authorization", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAuthorization() {
        return this.authorization;
    }

    @XMLInfo(elementType="element", elementName="Authorization", elementOrder=6, dataPowerType="dmAMQPAuthorization", subType="", benign=false, isPassword=false, cliAlias="authorization", refType="", isEnumeration=true, javaName="authorization", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="none", displayValue="Authorization", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAuthorization(String authorization) {
        if (Comparison.isIn(authorization, DPEnumerations.AMQPAUTHORIZATION)) {
            this.authorization = authorization;
        }
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="user", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserName() {
        return this.userName;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="user", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getPasswordAlias() {
        return this.passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasswordAlias(ObjectReference<ConfigPasswordAlias> passwordAlias) {
        this.passwordAlias = passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="MaximumFrameSize", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maximum-frame-size", refType="", isEnumeration=false, javaName="maximumFrameSize", javaType="long", isRequired=false, squelchNull=false, minimum=512, maximum=0x6400000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="104857600", displayOrder=0, displayValue="Max frame size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaximumFrameSize() {
        return this.maximumFrameSize;
    }

    @XMLInfo(elementType="element", elementName="MaximumFrameSize", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maximum-frame-size", refType="", isEnumeration=false, javaName="maximumFrameSize", javaType="long", isRequired=false, squelchNull=false, minimum=512, maximum=0x6400000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="104857600", displayValue="Max frame size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaximumFrameSize(long maximumFrameSize) {
        this.maximumFrameSize = maximumFrameSize;
    }

    @XMLInfo(elementType="element", elementName="AutoRetry", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="auto-retry", refType="", isEnumeration=true, javaName="autoRetry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Automatic retry", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAutoRetry() {
        return this.autoRetry;
    }

    @XMLInfo(elementType="element", elementName="AutoRetry", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="auto-retry", refType="", isEnumeration=true, javaName="autoRetry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Automatic retry", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAutoRetry(String autoRetry) {
        if (autoRetry == null || Comparison.isIn(autoRetry, DPEnumerations.TOGGLE)) {
            this.autoRetry = autoRetry;
        }
    }

    @XMLInfo(elementType="element", elementName="RetryInterval", elementOrder=11, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-interval", refType="", isEnumeration=false, javaName="retryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="10", displayOrder=0, displayValue="Retry Interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getRetryInterval() {
        return this.retryInterval;
    }

    @XMLInfo(elementType="element", elementName="RetryInterval", elementOrder=11, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-interval", refType="", isEnumeration=false, javaName="retryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="10", displayValue="Retry Interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    @XMLInfo(elementType="element", elementName="RetryAttempts", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-attempts", refType="", isEnumeration=false, javaName="retryAttempts", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="6", displayOrder=0, displayValue="Retry attempts", units="attempts", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @XMLInfo(elementType="element", elementName="RetryAttempts", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-attempts", refType="", isEnumeration=false, javaName="retryAttempts", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="6", displayValue="Retry attempts", units="attempts", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    @XMLInfo(elementType="element", elementName="LongRetryInterval", elementOrder=13, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="long-retry-interval", refType="", isEnumeration=false, javaName="longRetryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="600", displayOrder=0, displayValue="Long retry interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLongRetryInterval() {
        return this.longRetryInterval;
    }

    @XMLInfo(elementType="element", elementName="LongRetryInterval", elementOrder=13, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="long-retry-interval", refType="", isEnumeration=false, javaName="longRetryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="600", displayValue="Long retry interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLongRetryInterval(int longRetryInterval) {
        this.longRetryInterval = longRetryInterval;
    }

    @XMLInfo(elementType="element", elementName="ReportingInterval", elementOrder=14, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="reporting-interval", refType="", isEnumeration=false, javaName="reportingInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="10", displayOrder=0, displayValue="Reporting interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getReportingInterval() {
        return this.reportingInterval;
    }

    @XMLInfo(elementType="element", elementName="ReportingInterval", elementOrder=14, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="reporting-interval", refType="", isEnumeration=false, javaName="reportingInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="10", displayValue="Reporting interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setReportingInterval(int reportingInterval) {
        this.reportingInterval = reportingInterval;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(ObjectReference<ConfigSSLClientProfile> sSLClient) {
        this.sSLClient = sSLClient;
    }

    @Override
    public int compareTo(ConfigAMQPBroker that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "hostName", "port", "xMLManager", "containerID", "authorization", "userName", "passwordAlias", "maximumFrameSize", "autoRetry", "retryInterval", "retryAttempts", "longRetryInterval", "reportingInterval", "sSLClient");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.hostName, this.port, this.xMLManager, this.containerID, this.authorization, this.userName, this.passwordAlias, this.maximumFrameSize, this.autoRetry, this.retryInterval, this.retryAttempts, this.longRetryInterval, this.reportingInterval, this.sSLClient);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "hostName", "port", "xMLManager", "containerID", "authorization", "userName", "passwordAlias", "maximumFrameSize", "autoRetry", "retryInterval", "retryAttempts", "longRetryInterval", "reportingInterval", "sSLClient");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "hostName", "port", "xMLManager", "containerID", "authorization", "userName", "passwordAlias", "maximumFrameSize", "autoRetry", "retryInterval", "retryAttempts", "longRetryInterval", "reportingInterval", "sSLClient"));
    }
}

