/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAPIUserRegistry;
import com.kumbasoft.core.beans.config.ConfigLDAPSearchParameters;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigAPILDAPRegistry
extends ConfigAPIUserRegistry {
    private String userSummary;
    private String lDAPHost;
    private int lDAPPort;
    private ObjectReference<ConfigSSLClientProfile> sSLClientProfile;
    private String lDAPVersion;
    private String lDAPAuthMethod;
    private String lDAPBindDN;
    private ObjectReference<ConfigPasswordAlias> lDAPBindPasswordAlias;
    private ObjectReference<ConfigLDAPSearchParameters> lDAPSearchParameters;
    private long lDAPReadTimeout;
    private String lDAPGroupAuthEnabled;
    private String lDAPGroupAuthType;
    private String lDAPGroupScope;
    private String lDAPGroupBaseDN;
    private String lDAPGroupFilterPrefix;
    private String lDAPGroupFilterSuffix;
    private String lDAPGroupDynamicFilter;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="LDAPHost", elementOrder=2, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="ldap-host", refType="", isEnumeration=false, javaName="lDAPHost", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPHost() {
        return this.lDAPHost;
    }

    @XMLInfo(elementType="element", elementName="LDAPHost", elementOrder=2, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="ldap-host", refType="", isEnumeration=false, javaName="lDAPHost", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPHost(String lDAPHost) {
        this.lDAPHost = lDAPHost;
    }

    @XMLInfo(elementType="element", elementName="LDAPPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="ldap-port", refType="", isEnumeration=false, javaName="lDAPPort", javaType="int", isRequired=true, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="636", displayOrder=0, displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLDAPPort() {
        return this.lDAPPort;
    }

    @XMLInfo(elementType="element", elementName="LDAPPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="ldap-port", refType="", isEnumeration=false, javaName="lDAPPort", javaType="int", isRequired=true, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="636", displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPPort(int lDAPPort) {
        this.lDAPPort = lDAPPort;
    }

    @XMLInfo(elementType="element", elementName="SSLClientProfile", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClientProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getSSLClientProfile() {
        return this.sSLClientProfile;
    }

    @XMLInfo(elementType="element", elementName="SSLClientProfile", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClientProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClientProfile(ObjectReference<ConfigSSLClientProfile> sSLClientProfile) {
        this.sSLClientProfile = sSLClientProfile;
    }

    @XMLInfo(elementType="element", elementName="LDAPVersion", elementOrder=5, dataPowerType="dmLDAPVersion", subType="", benign=false, isPassword=false, cliAlias="ldap-version", refType="", isEnumeration=true, javaName="lDAPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="v3", displayOrder=0, displayValue="LDAP version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPVersion() {
        return this.lDAPVersion;
    }

    @XMLInfo(elementType="element", elementName="LDAPVersion", elementOrder=5, dataPowerType="dmLDAPVersion", subType="", benign=false, isPassword=false, cliAlias="ldap-version", refType="", isEnumeration=true, javaName="lDAPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="v3", displayValue="LDAP version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPVersion(String lDAPVersion) {
        if (lDAPVersion == null || Comparison.isIn(lDAPVersion, DPEnumerations.LDAPVERSION)) {
            this.lDAPVersion = lDAPVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPAuthMethod", elementOrder=6, dataPowerType="dmLDAPAuthMethod", subType="", benign=false, isPassword=false, cliAlias="ldap-auth-method", refType="", isEnumeration=true, javaName="lDAPAuthMethod", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="searchDN", displayOrder=0, displayValue="LDAP authentication method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPAuthMethod() {
        return this.lDAPAuthMethod;
    }

    @XMLInfo(elementType="element", elementName="LDAPAuthMethod", elementOrder=6, dataPowerType="dmLDAPAuthMethod", subType="", benign=false, isPassword=false, cliAlias="ldap-auth-method", refType="", isEnumeration=true, javaName="lDAPAuthMethod", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="searchDN", displayValue="LDAP authentication method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPAuthMethod(String lDAPAuthMethod) {
        if (lDAPAuthMethod == null || Comparison.isIn(lDAPAuthMethod, DPEnumerations.LDAPAUTH_METHOD)) {
            this.lDAPAuthMethod = lDAPAuthMethod;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPBindDN", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-bind-dn", refType="", isEnumeration=false, javaName="lDAPBindDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP bind DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPBindDN() {
        return this.lDAPBindDN;
    }

    @XMLInfo(elementType="element", elementName="LDAPBindDN", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-bind-dn", refType="", isEnumeration=false, javaName="lDAPBindDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP bind DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPBindDN(String lDAPBindDN) {
        this.lDAPBindDN = lDAPBindDN;
    }

    @XMLInfo(elementType="element", elementName="LDAPBindPasswordAlias", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ldap-bind-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="lDAPBindPasswordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP bind password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getLDAPBindPasswordAlias() {
        return this.lDAPBindPasswordAlias;
    }

    @XMLInfo(elementType="element", elementName="LDAPBindPasswordAlias", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ldap-bind-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="lDAPBindPasswordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP bind password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPBindPasswordAlias(ObjectReference<ConfigPasswordAlias> lDAPBindPasswordAlias) {
        this.lDAPBindPasswordAlias = lDAPBindPasswordAlias;
    }

    @XMLInfo(elementType="element", elementName="LDAPSearchParameters", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ldap-search-param", refType="LDAPSearchParameters", isEnumeration=false, javaName="lDAPSearchParameters", javaType="ObjectReference<ConfigLDAPSearchParameters>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP search parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigLDAPSearchParameters> getLDAPSearchParameters() {
        return this.lDAPSearchParameters;
    }

    @XMLInfo(elementType="element", elementName="LDAPSearchParameters", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ldap-search-param", refType="LDAPSearchParameters", isEnumeration=false, javaName="lDAPSearchParameters", javaType="ObjectReference<ConfigLDAPSearchParameters>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP search parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPSearchParameters(ObjectReference<ConfigLDAPSearchParameters> lDAPSearchParameters) {
        this.lDAPSearchParameters = lDAPSearchParameters;
    }

    @XMLInfo(elementType="element", elementName="LDAPReadTimeout", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="ldap-readtimeout", refType="", isEnumeration=false, javaName="lDAPReadTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="60", displayOrder=0, displayValue="LDAP read timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getLDAPReadTimeout() {
        return this.lDAPReadTimeout;
    }

    @XMLInfo(elementType="element", elementName="LDAPReadTimeout", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="ldap-readtimeout", refType="", isEnumeration=false, javaName="lDAPReadTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="60", displayValue="LDAP read timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPReadTimeout(long lDAPReadTimeout) {
        this.lDAPReadTimeout = lDAPReadTimeout;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupAuthEnabled", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ldap-group-auth-enabled", refType="", isEnumeration=true, javaName="lDAPGroupAuthEnabled", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable LDAP group authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPGroupAuthEnabled() {
        return this.lDAPGroupAuthEnabled;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupAuthEnabled", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ldap-group-auth-enabled", refType="", isEnumeration=true, javaName="lDAPGroupAuthEnabled", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable LDAP group authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPGroupAuthEnabled(String lDAPGroupAuthEnabled) {
        if (lDAPGroupAuthEnabled == null || Comparison.isIn(lDAPGroupAuthEnabled, DPEnumerations.TOGGLE)) {
            this.lDAPGroupAuthEnabled = lDAPGroupAuthEnabled;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupAuthType", elementOrder=12, dataPowerType="dmLDAPGroupAuthType", subType="", benign=false, isPassword=false, cliAlias="ldap-group-auth-type", refType="", isEnumeration=true, javaName="lDAPGroupAuthType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP group authentication type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPGroupAuthType() {
        return this.lDAPGroupAuthType;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupAuthType", elementOrder=12, dataPowerType="dmLDAPGroupAuthType", subType="", benign=false, isPassword=false, cliAlias="ldap-group-auth-type", refType="", isEnumeration=true, javaName="lDAPGroupAuthType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP group authentication type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPGroupAuthType(String lDAPGroupAuthType) {
        if (lDAPGroupAuthType == null || Comparison.isIn(lDAPGroupAuthType, DPEnumerations.LDAPGROUP_AUTH_TYPE)) {
            this.lDAPGroupAuthType = lDAPGroupAuthType;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupScope", elementOrder=13, dataPowerType="dmLDAPSearchScope", subType="", benign=false, isPassword=false, cliAlias="ldap-group-scope", refType="", isEnumeration=true, javaName="lDAPGroupScope", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="subtree", displayOrder=0, displayValue="LDAP group scope", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPGroupScope() {
        return this.lDAPGroupScope;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupScope", elementOrder=13, dataPowerType="dmLDAPSearchScope", subType="", benign=false, isPassword=false, cliAlias="ldap-group-scope", refType="", isEnumeration=true, javaName="lDAPGroupScope", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="subtree", displayValue="LDAP group scope", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPGroupScope(String lDAPGroupScope) {
        if (lDAPGroupScope == null || Comparison.isIn(lDAPGroupScope, DPEnumerations.LDAPSEARCH_SCOPE)) {
            this.lDAPGroupScope = lDAPGroupScope;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupBaseDN", elementOrder=14, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-group-base-dn", refType="", isEnumeration=false, javaName="lDAPGroupBaseDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP static group base DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPGroupBaseDN() {
        return this.lDAPGroupBaseDN;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupBaseDN", elementOrder=14, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-group-base-dn", refType="", isEnumeration=false, javaName="lDAPGroupBaseDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP static group base DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPGroupBaseDN(String lDAPGroupBaseDN) {
        this.lDAPGroupBaseDN = lDAPGroupBaseDN;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupFilterPrefix", elementOrder=15, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-group-filter-prefix", refType="", isEnumeration=false, javaName="lDAPGroupFilterPrefix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP static group filter prefix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPGroupFilterPrefix() {
        return this.lDAPGroupFilterPrefix;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupFilterPrefix", elementOrder=15, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-group-filter-prefix", refType="", isEnumeration=false, javaName="lDAPGroupFilterPrefix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP static group filter prefix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPGroupFilterPrefix(String lDAPGroupFilterPrefix) {
        this.lDAPGroupFilterPrefix = lDAPGroupFilterPrefix;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupFilterSuffix", elementOrder=16, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-group-filter-suffix", refType="", isEnumeration=false, javaName="lDAPGroupFilterSuffix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP static group filter suffix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPGroupFilterSuffix() {
        return this.lDAPGroupFilterSuffix;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupFilterSuffix", elementOrder=16, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-group-filter-suffix", refType="", isEnumeration=false, javaName="lDAPGroupFilterSuffix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP static group filter suffix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPGroupFilterSuffix(String lDAPGroupFilterSuffix) {
        this.lDAPGroupFilterSuffix = lDAPGroupFilterSuffix;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupDynamicFilter", elementOrder=17, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-group-dynamic-filter", refType="", isEnumeration=false, javaName="lDAPGroupDynamicFilter", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP dynamic filter", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPGroupDynamicFilter() {
        return this.lDAPGroupDynamicFilter;
    }

    @XMLInfo(elementType="element", elementName="LDAPGroupDynamicFilter", elementOrder=17, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-group-dynamic-filter", refType="", isEnumeration=false, javaName="lDAPGroupDynamicFilter", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP dynamic filter", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPGroupDynamicFilter(String lDAPGroupDynamicFilter) {
        this.lDAPGroupDynamicFilter = lDAPGroupDynamicFilter;
    }

    @Override
    public int compareTo(ConfigAPILDAPRegistry that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "lDAPHost", "lDAPPort", "sSLClientProfile", "lDAPVersion", "lDAPAuthMethod", "lDAPBindDN", "lDAPBindPasswordAlias", "lDAPSearchParameters", "lDAPReadTimeout", "lDAPGroupAuthEnabled", "lDAPGroupAuthType", "lDAPGroupScope", "lDAPGroupBaseDN", "lDAPGroupFilterPrefix", "lDAPGroupFilterSuffix", "lDAPGroupDynamicFilter");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.lDAPHost, this.lDAPPort, this.sSLClientProfile, this.lDAPVersion, this.lDAPAuthMethod, this.lDAPBindDN, this.lDAPBindPasswordAlias, this.lDAPSearchParameters, this.lDAPReadTimeout, this.lDAPGroupAuthEnabled, this.lDAPGroupAuthType, this.lDAPGroupScope, this.lDAPGroupBaseDN, this.lDAPGroupFilterPrefix, this.lDAPGroupFilterSuffix, this.lDAPGroupDynamicFilter);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "lDAPHost", "lDAPPort", "sSLClientProfile", "lDAPVersion", "lDAPAuthMethod", "lDAPBindDN", "lDAPBindPasswordAlias", "lDAPSearchParameters", "lDAPReadTimeout", "lDAPGroupAuthEnabled", "lDAPGroupAuthType", "lDAPGroupScope", "lDAPGroupBaseDN", "lDAPGroupFilterPrefix", "lDAPGroupFilterSuffix", "lDAPGroupDynamicFilter");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "lDAPHost", "lDAPPort", "sSLClientProfile", "lDAPVersion", "lDAPAuthMethod", "lDAPBindDN", "lDAPBindPasswordAlias", "lDAPSearchParameters", "lDAPReadTimeout", "lDAPGroupAuthEnabled", "lDAPGroupAuthType", "lDAPGroupScope", "lDAPGroupBaseDN", "lDAPGroupFilterPrefix", "lDAPGroupFilterSuffix", "lDAPGroupDynamicFilter"));
    }
}

