/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.config.ConfigCryptoIdentCred;
import com.kumbasoft.core.beans.config.ConfigCryptoValCred;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.config.ConfigStylePolicy;
import com.kumbasoft.core.beans.types.B2BContact;
import com.kumbasoft.core.beans.types.B2BDestination;
import com.kumbasoft.core.beans.types.B2BMessageProperties;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.ProfileCPABinding;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigB2BProfile
extends ConfigConfigBase {
    private String userSummary;
    private String profileType;
    private ArrayList<String> businessIDs;
    private ArrayList<String> businessIDsDUNS;
    private ArrayList<String> businessIDsDUNSPlus4;
    private ObjectReference<ConfigStylePolicy> customStylePolicy;
    private String responseType;
    private ArrayList<String> emailAddresses;
    private ArrayList<B2BDestination> destinations;
    private ObjectReference<ConfigCryptoValCred> inboundVerifyValCred;
    private String inboundRequireSigned;
    private String inboundRequireEncrypted;
    private ObjectReference<ConfigCryptoIdentCred> inboundDecryptIdCred;
    private ObjectReference<ConfigSSLProxyProfile> mDNSSLProxy;
    private String outboundSign;
    private ObjectReference<ConfigCryptoIdentCred> outboundSignIdCred;
    private String outboundSignDigestAlg;
    private String outboundSignMICAlgVersion;
    private ArrayList<B2BContact> contacts;
    private String overrideASID;
    private String aSAllowDuplicateMessage;
    private String preserveFilename;
    private String eBMSRole;
    private long eBMSPersistDuration;
    private String eBMSAckURL;
    private String eBMSErrorURL;
    private String eBMSInboundSendReceipt;
    private String eBMSInboundSendSignedReceipt;
    private String eBMSInboundReceiptReplyPattern;
    private String eBMSReceiptURL;
    private String eBMSInboundErrorURL;
    private ObjectReference<ConfigCryptoValCred> eBMSInboundVerifyValCred;
    private ObjectReference<ConfigCryptoCertificate> eBMSDefaultSignerCert;
    private ObjectReference<ConfigSSLProxyProfile> eBMSAckSSLProxy;
    private String eBMSInboundRequireSigned;
    private String eBMSInboundRequireEncrypted;
    private ObjectReference<ConfigCryptoIdentCred> eBMSInboundDecryptIdCred;
    private String eBMSOutboundSign;
    private ObjectReference<ConfigCryptoIdentCred> eBMSOutboundSignIdCred;
    private String eBMSOutboundSignatureAlg;
    private String eBMSOutboundSignatureC14NAlg;
    private String eBMSOutboundSignDigestAlg;
    private String eBMSEnableCPABinding;
    private ArrayList<ProfileCPABinding> eBMSProfileCPABindings;
    private String eBMSCpaId;
    private String eBMSService;
    private String eBMSAction;
    private String eBMSStartParameter;
    private String eBMSAllowDuplicateMessage;
    private String mDNSSLClientConfigType;
    private ObjectReference<ConfigSSLClientProfile> mDNSSLClient;
    private String eBMSAckSSLClientConfigType;
    private ObjectReference<ConfigSSLClientProfile> eBMSAckSSLClient;
    private String eBMS3OutboundSign;
    private ObjectReference<ConfigCryptoIdentCred> eBMS3OutboundSignIdCred;
    private String eBMS3OutboundSignDigestAlg;
    private String eBMS3OutboundSignatureAlg;
    private String eBMS3OutboundSignatureC14NAlg;
    private ObjectReference<ConfigCryptoValCred> eBMS3InboundVerifyValCred;
    private ObjectReference<ConfigCryptoCertificate> eBMS3DefaultSignerCert;
    private ObjectReference<ConfigSSLProxyProfile> eBMS3ReceiptSSLProxy;
    private String eBMS3InboundRequireSigned;
    private String eBMS3InboundRequireEncrypted;
    private ObjectReference<ConfigCryptoIdentCred> eBMS3InboundDecryptIdCred;
    private String eBMS3InboundRequireCompressed;
    private String eBMS3ReceiptSSLClientConfigType;
    private ObjectReference<ConfigSSLClientProfile> eBMS3ReceiptSSLClient;
    private String eBMSNotification;
    private String eBMSNotificationURL;
    private String eBMSNotificationSSLClientConfigType;
    private ObjectReference<ConfigSSLProxyProfile> eBMSNotificationSSLProxy;
    private ObjectReference<ConfigSSLClientProfile> eBMSNotificationSSLClient;
    private String eBMS3AllowDuplicateMessage;
    private String eBMS3DuplicateDetectionNotification;
    private ArrayList<B2BMessageProperties> eBMSMessageProperties;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="ProfileType", elementOrder=2, dataPowerType="dmB2BProfileType", subType="", benign=false, isPassword=false, cliAlias="profile-type", refType="", isEnumeration=true, javaName="profileType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="internal", displayOrder=0, displayValue="Profile type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getProfileType() {
        return this.profileType;
    }

    @XMLInfo(elementType="element", elementName="ProfileType", elementOrder=2, dataPowerType="dmB2BProfileType", subType="", benign=false, isPassword=false, cliAlias="profile-type", refType="", isEnumeration=true, javaName="profileType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="internal", displayValue="Profile type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProfileType(String profileType) {
        if (profileType == null || Comparison.isIn(profileType, DPEnumerations.B2BPROFILE_TYPE)) {
            this.profileType = profileType;
        }
    }

    public void addBusinessIDs(String element) {
        if (element == null) {
            return;
        }
        if (this.businessIDs == null) {
            this.businessIDs = new ArrayList();
        }
        this.businessIDs.add(element);
    }

    public boolean removeBusinessIDs(String element) {
        if (element == null || this.businessIDs == null) {
            return false;
        }
        return this.businessIDs.remove(element);
    }

    @XMLInfo(elementType="element", elementName="BusinessIDs", elementOrder=3, dataPowerType="dmString", subType="dmB2BProfileIDs", benign=false, isPassword=false, cliAlias="business-id", refType="", isEnumeration=false, javaName="businessIDs", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Partner business IDs", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getBusinessIDs() {
        return this.businessIDs;
    }

    @XMLInfo(elementType="element", elementName="BusinessIDs", elementOrder=3, dataPowerType="dmString", subType="dmB2BProfileIDs", benign=false, isPassword=false, cliAlias="business-id", refType="", isEnumeration=false, javaName="businessIDs", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Partner business IDs", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBusinessIDs(ArrayList<String> businessIDs) {
        this.businessIDs = businessIDs;
    }

    public void addBusinessIDsDUNS(String element) {
        if (element == null) {
            return;
        }
        if (this.businessIDsDUNS == null) {
            this.businessIDsDUNS = new ArrayList();
        }
        this.businessIDsDUNS.add(element);
    }

    public boolean removeBusinessIDsDUNS(String element) {
        if (element == null || this.businessIDsDUNS == null) {
            return false;
        }
        return this.businessIDsDUNS.remove(element);
    }

    @XMLInfo(elementType="element", elementName="BusinessIDsDUNS", elementOrder=4, dataPowerType="dmString", subType="dmB2BProfileIDs", benign=false, isPassword=false, cliAlias="business-id-duns", refType="", isEnumeration=false, javaName="businessIDsDUNS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[0-9]{9}$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Partner business IDs (DUNS)", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getBusinessIDsDUNS() {
        return this.businessIDsDUNS;
    }

    @XMLInfo(elementType="element", elementName="BusinessIDsDUNS", elementOrder=4, dataPowerType="dmString", subType="dmB2BProfileIDs", benign=false, isPassword=false, cliAlias="business-id-duns", refType="", isEnumeration=false, javaName="businessIDsDUNS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[0-9]{9}$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Partner business IDs (DUNS)", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBusinessIDsDUNS(ArrayList<String> businessIDsDUNS) {
        this.businessIDsDUNS = businessIDsDUNS;
    }

    public void addBusinessIDsDUNSPlus4(String element) {
        if (element == null) {
            return;
        }
        if (this.businessIDsDUNSPlus4 == null) {
            this.businessIDsDUNSPlus4 = new ArrayList();
        }
        this.businessIDsDUNSPlus4.add(element);
    }

    public boolean removeBusinessIDsDUNSPlus4(String element) {
        if (element == null || this.businessIDsDUNSPlus4 == null) {
            return false;
        }
        return this.businessIDsDUNSPlus4.remove(element);
    }

    @XMLInfo(elementType="element", elementName="BusinessIDsDUNSPlus4", elementOrder=5, dataPowerType="dmString", subType="dmB2BProfileIDs", benign=false, isPassword=false, cliAlias="business-id-duns4", refType="", isEnumeration=false, javaName="businessIDsDUNSPlus4", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[0-9]{13}$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Partner business IDs (DUNS+4)", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getBusinessIDsDUNSPlus4() {
        return this.businessIDsDUNSPlus4;
    }

    @XMLInfo(elementType="element", elementName="BusinessIDsDUNSPlus4", elementOrder=5, dataPowerType="dmString", subType="dmB2BProfileIDs", benign=false, isPassword=false, cliAlias="business-id-duns4", refType="", isEnumeration=false, javaName="businessIDsDUNSPlus4", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[0-9]{13}$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Partner business IDs (DUNS+4)", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBusinessIDsDUNSPlus4(ArrayList<String> businessIDsDUNSPlus4) {
        this.businessIDsDUNSPlus4 = businessIDsDUNSPlus4;
    }

    @XMLInfo(elementType="element", elementName="CustomStylePolicy", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="stylepolicy", refType="StylePolicy", isEnumeration=false, javaName="customStylePolicy", javaType="ObjectReference<ConfigStylePolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Processing policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigStylePolicy> getCustomStylePolicy() {
        return this.customStylePolicy;
    }

    @XMLInfo(elementType="element", elementName="CustomStylePolicy", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="stylepolicy", refType="StylePolicy", isEnumeration=false, javaName="customStylePolicy", javaType="ObjectReference<ConfigStylePolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Processing policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCustomStylePolicy(ObjectReference<ConfigStylePolicy> customStylePolicy) {
        this.customStylePolicy = customStylePolicy;
    }

    @XMLInfo(elementType="element", elementName="ResponseType", elementOrder=7, dataPowerType="dmXMLReqRespType1", subType="", benign=false, isPassword=false, cliAlias="response-type", refType="", isEnumeration=true, javaName="responseType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="preprocessed", displayOrder=0, displayValue="Response traffic type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getResponseType() {
        return this.responseType;
    }

    @XMLInfo(elementType="element", elementName="ResponseType", elementOrder=7, dataPowerType="dmXMLReqRespType1", subType="", benign=false, isPassword=false, cliAlias="response-type", refType="", isEnumeration=true, javaName="responseType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="preprocessed", displayValue="Response traffic type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setResponseType(String responseType) {
        if (responseType == null || Comparison.isIn(responseType, DPEnumerations.XMLREQ_RESP_TYPE1)) {
            this.responseType = responseType;
        }
    }

    public void addEmailAddresses(String element) {
        if (element == null) {
            return;
        }
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList();
        }
        this.emailAddresses.add(element);
    }

    public boolean removeEmailAddresses(String element) {
        if (element == null || this.emailAddresses == null) {
            return false;
        }
        return this.emailAddresses.remove(element);
    }

    @XMLInfo(elementType="element", elementName="EmailAddresses", elementOrder=8, dataPowerType="dmString", subType="dmB2BProfileIDs", benign=false, isPassword=false, cliAlias="email-address", refType="", isEnumeration=false, javaName="emailAddresses", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Partner email addresses", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    @XMLInfo(elementType="element", elementName="EmailAddresses", elementOrder=8, dataPowerType="dmString", subType="dmB2BProfileIDs", benign=false, isPassword=false, cliAlias="email-address", refType="", isEnumeration=false, javaName="emailAddresses", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Partner email addresses", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEmailAddresses(ArrayList<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public void addDestinations(B2BDestination element) {
        if (element == null) {
            return;
        }
        if (this.destinations == null) {
            this.destinations = new ArrayList();
        }
        this.destinations.add(element);
    }

    public boolean removeDestinations(B2BDestination element) {
        if (element == null || this.destinations == null) {
            return false;
        }
        return this.destinations.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Destinations", elementOrder=9, dataPowerType="dmB2BDestination", subType="", benign=false, isPassword=false, cliAlias="destination", refType="", isEnumeration=false, javaName="destinations", javaType="B2BDestination", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Destinations", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<B2BDestination> getDestinations() {
        return this.destinations;
    }

    @XMLInfo(elementType="element", elementName="Destinations", elementOrder=9, dataPowerType="dmB2BDestination", subType="", benign=false, isPassword=false, cliAlias="destination", refType="", isEnumeration=false, javaName="destinations", javaType="B2BDestination", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Destinations", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDestinations(ArrayList<B2BDestination> destinations) {
        this.destinations = destinations;
    }

    @XMLInfo(elementType="element", elementName="InboundVerifyValCred", elementOrder=10, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="verify-valcred", refType="CryptoValCred", isEnumeration=false, javaName="inboundVerifyValCred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Inbound signature validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoValCred> getInboundVerifyValCred() {
        return this.inboundVerifyValCred;
    }

    @XMLInfo(elementType="element", elementName="InboundVerifyValCred", elementOrder=10, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="verify-valcred", refType="CryptoValCred", isEnumeration=false, javaName="inboundVerifyValCred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Inbound signature validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setInboundVerifyValCred(ObjectReference<ConfigCryptoValCred> inboundVerifyValCred) {
        this.inboundVerifyValCred = inboundVerifyValCred;
    }

    @XMLInfo(elementType="element", elementName="InboundRequireSigned", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="require-signed", refType="", isEnumeration=true, javaName="inboundRequireSigned", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require signature", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getInboundRequireSigned() {
        return this.inboundRequireSigned;
    }

    @XMLInfo(elementType="element", elementName="InboundRequireSigned", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="require-signed", refType="", isEnumeration=true, javaName="inboundRequireSigned", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require signature", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setInboundRequireSigned(String inboundRequireSigned) {
        if (inboundRequireSigned == null || Comparison.isIn(inboundRequireSigned, DPEnumerations.TOGGLE)) {
            this.inboundRequireSigned = inboundRequireSigned;
        }
    }

    @XMLInfo(elementType="element", elementName="InboundRequireEncrypted", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="require-encrypted", refType="", isEnumeration=true, javaName="inboundRequireEncrypted", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require encryption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getInboundRequireEncrypted() {
        return this.inboundRequireEncrypted;
    }

    @XMLInfo(elementType="element", elementName="InboundRequireEncrypted", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="require-encrypted", refType="", isEnumeration=true, javaName="inboundRequireEncrypted", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require encryption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setInboundRequireEncrypted(String inboundRequireEncrypted) {
        if (inboundRequireEncrypted == null || Comparison.isIn(inboundRequireEncrypted, DPEnumerations.TOGGLE)) {
            this.inboundRequireEncrypted = inboundRequireEncrypted;
        }
    }

    @XMLInfo(elementType="element", elementName="InboundDecryptIdCred", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="decrypt-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="inboundDecryptIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Inbound decryption identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoIdentCred> getInboundDecryptIdCred() {
        return this.inboundDecryptIdCred;
    }

    @XMLInfo(elementType="element", elementName="InboundDecryptIdCred", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="decrypt-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="inboundDecryptIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Inbound decryption identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setInboundDecryptIdCred(ObjectReference<ConfigCryptoIdentCred> inboundDecryptIdCred) {
        this.inboundDecryptIdCred = inboundDecryptIdCred;
    }

    @XMLInfo(elementType="element", elementName="MDNSSLProxy", elementOrder=14, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mdn-ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="mDNSSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="MDN TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getMDNSSLProxy() {
        return this.mDNSSLProxy;
    }

    @XMLInfo(elementType="element", elementName="MDNSSLProxy", elementOrder=14, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mdn-ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="mDNSSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="MDN TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMDNSSLProxy(ObjectReference<ConfigSSLProxyProfile> mDNSSLProxy) {
        this.mDNSSLProxy = mDNSSLProxy;
    }

    @XMLInfo(elementType="element", elementName="OutboundSign", elementOrder=15, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="sign", refType="", isEnumeration=true, javaName="outboundSign", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Sign outbound messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOutboundSign() {
        return this.outboundSign;
    }

    @XMLInfo(elementType="element", elementName="OutboundSign", elementOrder=15, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="sign", refType="", isEnumeration=true, javaName="outboundSign", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Sign outbound messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOutboundSign(String outboundSign) {
        if (outboundSign == null || Comparison.isIn(outboundSign, DPEnumerations.TOGGLE)) {
            this.outboundSign = outboundSign;
        }
    }

    @XMLInfo(elementType="element", elementName="OutboundSignIdCred", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sign-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="outboundSignIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Signing identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoIdentCred> getOutboundSignIdCred() {
        return this.outboundSignIdCred;
    }

    @XMLInfo(elementType="element", elementName="OutboundSignIdCred", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sign-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="outboundSignIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Signing identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOutboundSignIdCred(ObjectReference<ConfigCryptoIdentCred> outboundSignIdCred) {
        this.outboundSignIdCred = outboundSignIdCred;
    }

    @XMLInfo(elementType="element", elementName="OutboundSignDigestAlg", elementOrder=17, dataPowerType="dmCMSHashAlgorithm", subType="", benign=false, isPassword=false, cliAlias="sign-digest-alg", refType="", isEnumeration=true, javaName="outboundSignDigestAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="sha1", displayOrder=0, displayValue="Signing digest algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOutboundSignDigestAlg() {
        return this.outboundSignDigestAlg;
    }

    @XMLInfo(elementType="element", elementName="OutboundSignDigestAlg", elementOrder=17, dataPowerType="dmCMSHashAlgorithm", subType="", benign=false, isPassword=false, cliAlias="sign-digest-alg", refType="", isEnumeration=true, javaName="outboundSignDigestAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="sha1", displayValue="Signing digest algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOutboundSignDigestAlg(String outboundSignDigestAlg) {
        if (outboundSignDigestAlg == null || Comparison.isIn(outboundSignDigestAlg, DPEnumerations.CMSHASH_ALGORITHM)) {
            this.outboundSignDigestAlg = outboundSignDigestAlg;
        }
    }

    @XMLInfo(elementType="element", elementName="OutboundSignMICAlgVersion", elementOrder=18, dataPowerType="dmSMIMEVersion", subType="", benign=false, isPassword=false, cliAlias="sign-micalg-version", refType="", isEnumeration=true, javaName="outboundSignMICAlgVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Signing S/MIME version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOutboundSignMICAlgVersion() {
        return this.outboundSignMICAlgVersion;
    }

    @XMLInfo(elementType="element", elementName="OutboundSignMICAlgVersion", elementOrder=18, dataPowerType="dmSMIMEVersion", subType="", benign=false, isPassword=false, cliAlias="sign-micalg-version", refType="", isEnumeration=true, javaName="outboundSignMICAlgVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Signing S/MIME version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOutboundSignMICAlgVersion(String outboundSignMICAlgVersion) {
        if (outboundSignMICAlgVersion == null || Comparison.isIn(outboundSignMICAlgVersion, DPEnumerations.SMIMEVERSION)) {
            this.outboundSignMICAlgVersion = outboundSignMICAlgVersion;
        }
    }

    public void addContacts(B2BContact element) {
        if (element == null) {
            return;
        }
        if (this.contacts == null) {
            this.contacts = new ArrayList();
        }
        this.contacts.add(element);
    }

    public boolean removeContacts(B2BContact element) {
        if (element == null || this.contacts == null) {
            return false;
        }
        return this.contacts.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Contacts", elementOrder=19, dataPowerType="dmB2BContact", subType="", benign=false, isPassword=false, cliAlias="contact", refType="", isEnumeration=false, javaName="contacts", javaType="B2BContact", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Contacts", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<B2BContact> getContacts() {
        return this.contacts;
    }

    @XMLInfo(elementType="element", elementName="Contacts", elementOrder=19, dataPowerType="dmB2BContact", subType="", benign=false, isPassword=false, cliAlias="contact", refType="", isEnumeration=false, javaName="contacts", javaType="B2BContact", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Contacts", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setContacts(ArrayList<B2BContact> contacts) {
        this.contacts = contacts;
    }

    @XMLInfo(elementType="element", elementName="OverrideASID", elementOrder=20, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="override-as-identifier", refType="", isEnumeration=false, javaName="overrideASID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Override AS identifier", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOverrideASID() {
        return this.overrideASID;
    }

    @XMLInfo(elementType="element", elementName="OverrideASID", elementOrder=20, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="override-as-identifier", refType="", isEnumeration=false, javaName="overrideASID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Override AS identifier", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOverrideASID(String overrideASID) {
        this.overrideASID = overrideASID;
    }

    @XMLInfo(elementType="element", elementName="ASAllowDuplicateMessage", elementOrder=21, dataPowerType="dmAllowDuplicateMessage", subType="", benign=false, isPassword=false, cliAlias="as-allow-dup-msg", refType="", isEnumeration=true, javaName="aSAllowDuplicateMessage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="never", displayOrder=0, displayValue="Allow duplicate AS inbound message", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getASAllowDuplicateMessage() {
        return this.aSAllowDuplicateMessage;
    }

    @XMLInfo(elementType="element", elementName="ASAllowDuplicateMessage", elementOrder=21, dataPowerType="dmAllowDuplicateMessage", subType="", benign=false, isPassword=false, cliAlias="as-allow-dup-msg", refType="", isEnumeration=true, javaName="aSAllowDuplicateMessage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="never", displayValue="Allow duplicate AS inbound message", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setASAllowDuplicateMessage(String aSAllowDuplicateMessage) {
        if (aSAllowDuplicateMessage == null || Comparison.isIn(aSAllowDuplicateMessage, DPEnumerations.ALLOW_DUPLICATE_MESSAGE)) {
            this.aSAllowDuplicateMessage = aSAllowDuplicateMessage;
        }
    }

    @XMLInfo(elementType="element", elementName="PreserveFilename", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="preserve-filename", refType="", isEnumeration=true, javaName="preserveFilename", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Preserve file name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPreserveFilename() {
        return this.preserveFilename;
    }

    @XMLInfo(elementType="element", elementName="PreserveFilename", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="preserve-filename", refType="", isEnumeration=true, javaName="preserveFilename", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Preserve file name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPreserveFilename(String preserveFilename) {
        if (preserveFilename == null || Comparison.isIn(preserveFilename, DPEnumerations.TOGGLE)) {
            this.preserveFilename = preserveFilename;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSRole", elementOrder=23, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ebms-role", refType="", isEnumeration=false, javaName="eBMSRole", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Role", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSRole() {
        return this.eBMSRole;
    }

    @XMLInfo(elementType="element", elementName="EBMSRole", elementOrder=23, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ebms-role", refType="", isEnumeration=false, javaName="eBMSRole", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Role", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSRole(String eBMSRole) {
        this.eBMSRole = eBMSRole;
    }

    @XMLInfo(elementType="element", elementName="EBMSPersistDuration", elementOrder=24, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="ebms-persist-duration", refType="", isEnumeration=false, javaName="eBMSPersistDuration", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=6000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Persist duration", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getEBMSPersistDuration() {
        return this.eBMSPersistDuration;
    }

    @XMLInfo(elementType="element", elementName="EBMSPersistDuration", elementOrder=24, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="ebms-persist-duration", refType="", isEnumeration=false, javaName="eBMSPersistDuration", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=6000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Persist duration", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSPersistDuration(long eBMSPersistDuration) {
        this.eBMSPersistDuration = eBMSPersistDuration;
    }

    @XMLInfo(elementType="element", elementName="EBMSAckURL", elementOrder=25, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="ebms-ack-url", refType="", isEnumeration=false, javaName="eBMSAckURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Acknowledgment URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSAckURL() {
        return this.eBMSAckURL;
    }

    @XMLInfo(elementType="element", elementName="EBMSAckURL", elementOrder=25, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="ebms-ack-url", refType="", isEnumeration=false, javaName="eBMSAckURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Acknowledgment URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSAckURL(String eBMSAckURL) {
        this.eBMSAckURL = eBMSAckURL;
    }

    @XMLInfo(elementType="element", elementName="EBMSErrorURL", elementOrder=26, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="ebms-error-url", refType="", isEnumeration=false, javaName="eBMSErrorURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Error URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSErrorURL() {
        return this.eBMSErrorURL;
    }

    @XMLInfo(elementType="element", elementName="EBMSErrorURL", elementOrder=26, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="ebms-error-url", refType="", isEnumeration=false, javaName="eBMSErrorURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Error URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSErrorURL(String eBMSErrorURL) {
        this.eBMSErrorURL = eBMSErrorURL;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundSendReceipt", elementOrder=27, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-inbound-send-receipt", refType="", isEnumeration=true, javaName="eBMSInboundSendReceipt", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Reply with receipt", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSInboundSendReceipt() {
        return this.eBMSInboundSendReceipt;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundSendReceipt", elementOrder=27, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-inbound-send-receipt", refType="", isEnumeration=true, javaName="eBMSInboundSendReceipt", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Reply with receipt", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSInboundSendReceipt(String eBMSInboundSendReceipt) {
        if (eBMSInboundSendReceipt == null || Comparison.isIn(eBMSInboundSendReceipt, DPEnumerations.TOGGLE)) {
            this.eBMSInboundSendReceipt = eBMSInboundSendReceipt;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundSendSignedReceipt", elementOrder=28, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-inbound-send-signed-receipt", refType="", isEnumeration=true, javaName="eBMSInboundSendSignedReceipt", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Reply with signed receipt", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSInboundSendSignedReceipt() {
        return this.eBMSInboundSendSignedReceipt;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundSendSignedReceipt", elementOrder=28, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-inbound-send-signed-receipt", refType="", isEnumeration=true, javaName="eBMSInboundSendSignedReceipt", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Reply with signed receipt", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSInboundSendSignedReceipt(String eBMSInboundSendSignedReceipt) {
        if (eBMSInboundSendSignedReceipt == null || Comparison.isIn(eBMSInboundSendSignedReceipt, DPEnumerations.TOGGLE)) {
            this.eBMSInboundSendSignedReceipt = eBMSInboundSendSignedReceipt;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundReceiptReplyPattern", elementOrder=29, dataPowerType="dmEBMSReplyPattern", subType="", benign=false, isPassword=false, cliAlias="ebms-inbound-receipt-reply-pattern", refType="", isEnumeration=true, javaName="eBMSInboundReceiptReplyPattern", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="Response", displayOrder=0, displayValue="Receipt reply pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSInboundReceiptReplyPattern() {
        return this.eBMSInboundReceiptReplyPattern;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundReceiptReplyPattern", elementOrder=29, dataPowerType="dmEBMSReplyPattern", subType="", benign=false, isPassword=false, cliAlias="ebms-inbound-receipt-reply-pattern", refType="", isEnumeration=true, javaName="eBMSInboundReceiptReplyPattern", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="Response", displayValue="Receipt reply pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSInboundReceiptReplyPattern(String eBMSInboundReceiptReplyPattern) {
        if (eBMSInboundReceiptReplyPattern == null || Comparison.isIn(eBMSInboundReceiptReplyPattern, DPEnumerations.EBMSREPLY_PATTERN)) {
            this.eBMSInboundReceiptReplyPattern = eBMSInboundReceiptReplyPattern;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSReceiptURL", elementOrder=30, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="ebms-receipt-url", refType="", isEnumeration=false, javaName="eBMSReceiptURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Receipt URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSReceiptURL() {
        return this.eBMSReceiptURL;
    }

    @XMLInfo(elementType="element", elementName="EBMSReceiptURL", elementOrder=30, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="ebms-receipt-url", refType="", isEnumeration=false, javaName="eBMSReceiptURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Receipt URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSReceiptURL(String eBMSReceiptURL) {
        this.eBMSReceiptURL = eBMSReceiptURL;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundErrorURL", elementOrder=31, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="ebms-inbound-error-url", refType="", isEnumeration=false, javaName="eBMSInboundErrorURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Error URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSInboundErrorURL() {
        return this.eBMSInboundErrorURL;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundErrorURL", elementOrder=31, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="ebms-inbound-error-url", refType="", isEnumeration=false, javaName="eBMSInboundErrorURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Error URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSInboundErrorURL(String eBMSInboundErrorURL) {
        this.eBMSInboundErrorURL = eBMSInboundErrorURL;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundVerifyValCred", elementOrder=32, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-verify-valcred", refType="CryptoValCred", isEnumeration=false, javaName="eBMSInboundVerifyValCred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Inbound signature validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoValCred> getEBMSInboundVerifyValCred() {
        return this.eBMSInboundVerifyValCred;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundVerifyValCred", elementOrder=32, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-verify-valcred", refType="CryptoValCred", isEnumeration=false, javaName="eBMSInboundVerifyValCred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Inbound signature validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSInboundVerifyValCred(ObjectReference<ConfigCryptoValCred> eBMSInboundVerifyValCred) {
        this.eBMSInboundVerifyValCred = eBMSInboundVerifyValCred;
    }

    @XMLInfo(elementType="element", elementName="EBMSDefaultSignerCert", elementOrder=33, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-default-signer-cert", refType="CryptoCertificate", isEnumeration=false, javaName="eBMSDefaultSignerCert", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Default inbound signature validation certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoCertificate> getEBMSDefaultSignerCert() {
        return this.eBMSDefaultSignerCert;
    }

    @XMLInfo(elementType="element", elementName="EBMSDefaultSignerCert", elementOrder=33, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-default-signer-cert", refType="CryptoCertificate", isEnumeration=false, javaName="eBMSDefaultSignerCert", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Default inbound signature validation certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSDefaultSignerCert(ObjectReference<ConfigCryptoCertificate> eBMSDefaultSignerCert) {
        this.eBMSDefaultSignerCert = eBMSDefaultSignerCert;
    }

    @XMLInfo(elementType="element", elementName="EBMSAckSSLProxy", elementOrder=34, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-ack-ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="eBMSAckSSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Acknowledgment/Error TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getEBMSAckSSLProxy() {
        return this.eBMSAckSSLProxy;
    }

    @XMLInfo(elementType="element", elementName="EBMSAckSSLProxy", elementOrder=34, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-ack-ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="eBMSAckSSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Acknowledgment/Error TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSAckSSLProxy(ObjectReference<ConfigSSLProxyProfile> eBMSAckSSLProxy) {
        this.eBMSAckSSLProxy = eBMSAckSSLProxy;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundRequireSigned", elementOrder=35, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-require-signed", refType="", isEnumeration=true, javaName="eBMSInboundRequireSigned", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require signature", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSInboundRequireSigned() {
        return this.eBMSInboundRequireSigned;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundRequireSigned", elementOrder=35, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-require-signed", refType="", isEnumeration=true, javaName="eBMSInboundRequireSigned", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require signature", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSInboundRequireSigned(String eBMSInboundRequireSigned) {
        if (eBMSInboundRequireSigned == null || Comparison.isIn(eBMSInboundRequireSigned, DPEnumerations.TOGGLE)) {
            this.eBMSInboundRequireSigned = eBMSInboundRequireSigned;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundRequireEncrypted", elementOrder=36, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-require-encrypted", refType="", isEnumeration=true, javaName="eBMSInboundRequireEncrypted", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require encryption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSInboundRequireEncrypted() {
        return this.eBMSInboundRequireEncrypted;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundRequireEncrypted", elementOrder=36, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-require-encrypted", refType="", isEnumeration=true, javaName="eBMSInboundRequireEncrypted", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require encryption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSInboundRequireEncrypted(String eBMSInboundRequireEncrypted) {
        if (eBMSInboundRequireEncrypted == null || Comparison.isIn(eBMSInboundRequireEncrypted, DPEnumerations.TOGGLE)) {
            this.eBMSInboundRequireEncrypted = eBMSInboundRequireEncrypted;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundDecryptIdCred", elementOrder=37, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-decrypt-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="eBMSInboundDecryptIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Inbound decryption identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoIdentCred> getEBMSInboundDecryptIdCred() {
        return this.eBMSInboundDecryptIdCred;
    }

    @XMLInfo(elementType="element", elementName="EBMSInboundDecryptIdCred", elementOrder=37, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-decrypt-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="eBMSInboundDecryptIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Inbound decryption identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSInboundDecryptIdCred(ObjectReference<ConfigCryptoIdentCred> eBMSInboundDecryptIdCred) {
        this.eBMSInboundDecryptIdCred = eBMSInboundDecryptIdCred;
    }

    @XMLInfo(elementType="element", elementName="EBMSOutboundSign", elementOrder=38, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-sign", refType="", isEnumeration=true, javaName="eBMSOutboundSign", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Sign outbound messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSOutboundSign() {
        return this.eBMSOutboundSign;
    }

    @XMLInfo(elementType="element", elementName="EBMSOutboundSign", elementOrder=38, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-sign", refType="", isEnumeration=true, javaName="eBMSOutboundSign", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Sign outbound messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSOutboundSign(String eBMSOutboundSign) {
        if (eBMSOutboundSign == null || Comparison.isIn(eBMSOutboundSign, DPEnumerations.TOGGLE)) {
            this.eBMSOutboundSign = eBMSOutboundSign;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSOutboundSignIdCred", elementOrder=39, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-sign-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="eBMSOutboundSignIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Signing identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoIdentCred> getEBMSOutboundSignIdCred() {
        return this.eBMSOutboundSignIdCred;
    }

    @XMLInfo(elementType="element", elementName="EBMSOutboundSignIdCred", elementOrder=39, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-sign-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="eBMSOutboundSignIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Signing identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSOutboundSignIdCred(ObjectReference<ConfigCryptoIdentCred> eBMSOutboundSignIdCred) {
        this.eBMSOutboundSignIdCred = eBMSOutboundSignIdCred;
    }

    @XMLInfo(elementType="element", elementName="EBMSOutboundSignatureAlg", elementOrder=40, dataPowerType="dmEBMSSignatureAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms-signature-alg", refType="", isEnumeration=true, javaName="eBMSOutboundSignatureAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="dsa-sha1", displayOrder=0, displayValue="Signature algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSOutboundSignatureAlg() {
        return this.eBMSOutboundSignatureAlg;
    }

    @XMLInfo(elementType="element", elementName="EBMSOutboundSignatureAlg", elementOrder=40, dataPowerType="dmEBMSSignatureAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms-signature-alg", refType="", isEnumeration=true, javaName="eBMSOutboundSignatureAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="dsa-sha1", displayValue="Signature algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSOutboundSignatureAlg(String eBMSOutboundSignatureAlg) {
        if (eBMSOutboundSignatureAlg == null || Comparison.isIn(eBMSOutboundSignatureAlg, DPEnumerations.EBMSSIGNATURE_ALGORITHM)) {
            this.eBMSOutboundSignatureAlg = eBMSOutboundSignatureAlg;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSOutboundSignatureC14NAlg", elementOrder=41, dataPowerType="dmCryptoCanonicalizationAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms-signature-c14n-alg", refType="", isEnumeration=true, javaName="eBMSOutboundSignatureC14NAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="c14n", displayOrder=0, displayValue="Signature canonicalization method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSOutboundSignatureC14NAlg() {
        return this.eBMSOutboundSignatureC14NAlg;
    }

    @XMLInfo(elementType="element", elementName="EBMSOutboundSignatureC14NAlg", elementOrder=41, dataPowerType="dmCryptoCanonicalizationAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms-signature-c14n-alg", refType="", isEnumeration=true, javaName="eBMSOutboundSignatureC14NAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="c14n", displayValue="Signature canonicalization method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSOutboundSignatureC14NAlg(String eBMSOutboundSignatureC14NAlg) {
        if (eBMSOutboundSignatureC14NAlg == null || Comparison.isIn(eBMSOutboundSignatureC14NAlg, DPEnumerations.CRYPTO_CANONICALIZATION_ALGORITHM)) {
            this.eBMSOutboundSignatureC14NAlg = eBMSOutboundSignatureC14NAlg;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSOutboundSignDigestAlg", elementOrder=42, dataPowerType="dmCryptoHashAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms-sign-digest-alg", refType="", isEnumeration=true, javaName="eBMSOutboundSignDigestAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="sha1", displayOrder=0, displayValue="Signing digest algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSOutboundSignDigestAlg() {
        return this.eBMSOutboundSignDigestAlg;
    }

    @XMLInfo(elementType="element", elementName="EBMSOutboundSignDigestAlg", elementOrder=42, dataPowerType="dmCryptoHashAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms-sign-digest-alg", refType="", isEnumeration=true, javaName="eBMSOutboundSignDigestAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="sha1", displayValue="Signing digest algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSOutboundSignDigestAlg(String eBMSOutboundSignDigestAlg) {
        if (eBMSOutboundSignDigestAlg == null || Comparison.isIn(eBMSOutboundSignDigestAlg, DPEnumerations.CRYPTO_HASH_ALGORITHM)) {
            this.eBMSOutboundSignDigestAlg = eBMSOutboundSignDigestAlg;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSEnableCPABinding", elementOrder=43, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-enable-cpa-bindings", refType="", isEnumeration=true, javaName="eBMSEnableCPABinding", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable CPA bindings", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSEnableCPABinding() {
        return this.eBMSEnableCPABinding;
    }

    @XMLInfo(elementType="element", elementName="EBMSEnableCPABinding", elementOrder=43, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-enable-cpa-bindings", refType="", isEnumeration=true, javaName="eBMSEnableCPABinding", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable CPA bindings", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSEnableCPABinding(String eBMSEnableCPABinding) {
        if (eBMSEnableCPABinding == null || Comparison.isIn(eBMSEnableCPABinding, DPEnumerations.TOGGLE)) {
            this.eBMSEnableCPABinding = eBMSEnableCPABinding;
        }
    }

    public void addEBMSProfileCPABindings(ProfileCPABinding element) {
        if (element == null) {
            return;
        }
        if (this.eBMSProfileCPABindings == null) {
            this.eBMSProfileCPABindings = new ArrayList();
        }
        this.eBMSProfileCPABindings.add(element);
    }

    public boolean removeEBMSProfileCPABindings(ProfileCPABinding element) {
        if (element == null || this.eBMSProfileCPABindings == null) {
            return false;
        }
        return this.eBMSProfileCPABindings.remove(element);
    }

    @XMLInfo(elementType="element", elementName="EBMSProfileCPABindings", elementOrder=44, dataPowerType="dmProfileCPABinding", subType="", benign=false, isPassword=false, cliAlias="profile-cpa-binding", refType="", isEnumeration=false, javaName="eBMSProfileCPABindings", javaType="ProfileCPABinding", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="CPA bindings", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ProfileCPABinding> getEBMSProfileCPABindings() {
        return this.eBMSProfileCPABindings;
    }

    @XMLInfo(elementType="element", elementName="EBMSProfileCPABindings", elementOrder=44, dataPowerType="dmProfileCPABinding", subType="", benign=false, isPassword=false, cliAlias="profile-cpa-binding", refType="", isEnumeration=false, javaName="eBMSProfileCPABindings", javaType="ProfileCPABinding", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="CPA bindings", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSProfileCPABindings(ArrayList<ProfileCPABinding> eBMSProfileCPABindings) {
        this.eBMSProfileCPABindings = eBMSProfileCPABindings;
    }

    @XMLInfo(elementType="element", elementName="EBMSCpaId", elementOrder=45, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ebms-cpa-id", refType="", isEnumeration=false, javaName="eBMSCpaId", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Default CPA ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSCpaId() {
        return this.eBMSCpaId;
    }

    @XMLInfo(elementType="element", elementName="EBMSCpaId", elementOrder=45, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ebms-cpa-id", refType="", isEnumeration=false, javaName="eBMSCpaId", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Default CPA ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSCpaId(String eBMSCpaId) {
        this.eBMSCpaId = eBMSCpaId;
    }

    @XMLInfo(elementType="element", elementName="EBMSService", elementOrder=46, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ebms-service", refType="", isEnumeration=false, javaName="eBMSService", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Default service", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSService() {
        return this.eBMSService;
    }

    @XMLInfo(elementType="element", elementName="EBMSService", elementOrder=46, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ebms-service", refType="", isEnumeration=false, javaName="eBMSService", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Default service", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSService(String eBMSService) {
        this.eBMSService = eBMSService;
    }

    @XMLInfo(elementType="element", elementName="EBMSAction", elementOrder=47, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ebms-action", refType="", isEnumeration=false, javaName="eBMSAction", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Default action", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSAction() {
        return this.eBMSAction;
    }

    @XMLInfo(elementType="element", elementName="EBMSAction", elementOrder=47, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ebms-action", refType="", isEnumeration=false, javaName="eBMSAction", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Default action", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSAction(String eBMSAction) {
        this.eBMSAction = eBMSAction;
    }

    @XMLInfo(elementType="element", elementName="EBMSStartParameter", elementOrder=48, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-start-parameter", refType="", isEnumeration=true, javaName="eBMSStartParameter", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Generate start parameter", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSStartParameter() {
        return this.eBMSStartParameter;
    }

    @XMLInfo(elementType="element", elementName="EBMSStartParameter", elementOrder=48, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-start-parameter", refType="", isEnumeration=true, javaName="eBMSStartParameter", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Generate start parameter", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSStartParameter(String eBMSStartParameter) {
        if (eBMSStartParameter == null || Comparison.isIn(eBMSStartParameter, DPEnumerations.TOGGLE)) {
            this.eBMSStartParameter = eBMSStartParameter;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSAllowDuplicateMessage", elementOrder=49, dataPowerType="dmAllowDuplicateMessage", subType="", benign=false, isPassword=false, cliAlias="ebms-allow-dup-msg", refType="", isEnumeration=true, javaName="eBMSAllowDuplicateMessage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="never", displayOrder=0, displayValue="Allow duplicate ebMS2 inbound message", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSAllowDuplicateMessage() {
        return this.eBMSAllowDuplicateMessage;
    }

    @XMLInfo(elementType="element", elementName="EBMSAllowDuplicateMessage", elementOrder=49, dataPowerType="dmAllowDuplicateMessage", subType="", benign=false, isPassword=false, cliAlias="ebms-allow-dup-msg", refType="", isEnumeration=true, javaName="eBMSAllowDuplicateMessage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="never", displayValue="Allow duplicate ebMS2 inbound message", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSAllowDuplicateMessage(String eBMSAllowDuplicateMessage) {
        if (eBMSAllowDuplicateMessage == null || Comparison.isIn(eBMSAllowDuplicateMessage, DPEnumerations.ALLOW_DUPLICATE_MESSAGE)) {
            this.eBMSAllowDuplicateMessage = eBMSAllowDuplicateMessage;
        }
    }

    @XMLInfo(elementType="element", elementName="MDNSSLClientConfigType", elementOrder=50, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="mdn-ssl-client-type", refType="", isEnumeration=true, javaName="mDNSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="proxy", displayOrder=0, displayValue="MDN TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMDNSSLClientConfigType() {
        return this.mDNSSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="MDNSSLClientConfigType", elementOrder=50, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="mdn-ssl-client-type", refType="", isEnumeration=true, javaName="mDNSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="proxy", displayValue="MDN TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMDNSSLClientConfigType(String mDNSSLClientConfigType) {
        if (mDNSSLClientConfigType == null || Comparison.isIn(mDNSSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.mDNSSLClientConfigType = mDNSSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="MDNSSLClient", elementOrder=51, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mdn-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="mDNSSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="MDN TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getMDNSSLClient() {
        return this.mDNSSLClient;
    }

    @XMLInfo(elementType="element", elementName="MDNSSLClient", elementOrder=51, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mdn-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="mDNSSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="MDN TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMDNSSLClient(ObjectReference<ConfigSSLClientProfile> mDNSSLClient) {
        this.mDNSSLClient = mDNSSLClient;
    }

    @XMLInfo(elementType="element", elementName="EBMSAckSSLClientConfigType", elementOrder=52, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ebmsack-ssl-client-type", refType="", isEnumeration=true, javaName="eBMSAckSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="proxy", displayOrder=0, displayValue="Acknowledgment/Error TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSAckSSLClientConfigType() {
        return this.eBMSAckSSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="EBMSAckSSLClientConfigType", elementOrder=52, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ebmsack-ssl-client-type", refType="", isEnumeration=true, javaName="eBMSAckSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="proxy", displayValue="Acknowledgment/Error TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSAckSSLClientConfigType(String eBMSAckSSLClientConfigType) {
        if (eBMSAckSSLClientConfigType == null || Comparison.isIn(eBMSAckSSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.eBMSAckSSLClientConfigType = eBMSAckSSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSAckSSLClient", elementOrder=53, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebmsack-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="eBMSAckSSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Acknowledgment/Error TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getEBMSAckSSLClient() {
        return this.eBMSAckSSLClient;
    }

    @XMLInfo(elementType="element", elementName="EBMSAckSSLClient", elementOrder=53, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebmsack-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="eBMSAckSSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Acknowledgment/Error TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSAckSSLClient(ObjectReference<ConfigSSLClientProfile> eBMSAckSSLClient) {
        this.eBMSAckSSLClient = eBMSAckSSLClient;
    }

    @XMLInfo(elementType="element", elementName="EBMS3OutboundSign", elementOrder=54, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms3-sign", refType="", isEnumeration=true, javaName="eBMS3OutboundSign", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Sign outbound messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMS3OutboundSign() {
        return this.eBMS3OutboundSign;
    }

    @XMLInfo(elementType="element", elementName="EBMS3OutboundSign", elementOrder=54, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms3-sign", refType="", isEnumeration=true, javaName="eBMS3OutboundSign", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Sign outbound messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3OutboundSign(String eBMS3OutboundSign) {
        if (eBMS3OutboundSign == null || Comparison.isIn(eBMS3OutboundSign, DPEnumerations.TOGGLE)) {
            this.eBMS3OutboundSign = eBMS3OutboundSign;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMS3OutboundSignIdCred", elementOrder=55, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-sign-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="eBMS3OutboundSignIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Signing identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoIdentCred> getEBMS3OutboundSignIdCred() {
        return this.eBMS3OutboundSignIdCred;
    }

    @XMLInfo(elementType="element", elementName="EBMS3OutboundSignIdCred", elementOrder=55, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-sign-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="eBMS3OutboundSignIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Signing identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3OutboundSignIdCred(ObjectReference<ConfigCryptoIdentCred> eBMS3OutboundSignIdCred) {
        this.eBMS3OutboundSignIdCred = eBMS3OutboundSignIdCred;
    }

    @XMLInfo(elementType="element", elementName="EBMS3OutboundSignDigestAlg", elementOrder=56, dataPowerType="dmCryptoHashAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms3-sign-digest-alg", refType="", isEnumeration=true, javaName="eBMS3OutboundSignDigestAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="sha1", displayOrder=0, displayValue="Signing digest algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMS3OutboundSignDigestAlg() {
        return this.eBMS3OutboundSignDigestAlg;
    }

    @XMLInfo(elementType="element", elementName="EBMS3OutboundSignDigestAlg", elementOrder=56, dataPowerType="dmCryptoHashAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms3-sign-digest-alg", refType="", isEnumeration=true, javaName="eBMS3OutboundSignDigestAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="sha1", displayValue="Signing digest algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3OutboundSignDigestAlg(String eBMS3OutboundSignDigestAlg) {
        if (eBMS3OutboundSignDigestAlg == null || Comparison.isIn(eBMS3OutboundSignDigestAlg, DPEnumerations.CRYPTO_HASH_ALGORITHM)) {
            this.eBMS3OutboundSignDigestAlg = eBMS3OutboundSignDigestAlg;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMS3OutboundSignatureAlg", elementOrder=57, dataPowerType="dmEBMSSignatureAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms3-signature-alg", refType="", isEnumeration=true, javaName="eBMS3OutboundSignatureAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="rsa-sha1", displayOrder=0, displayValue="Signature algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMS3OutboundSignatureAlg() {
        return this.eBMS3OutboundSignatureAlg;
    }

    @XMLInfo(elementType="element", elementName="EBMS3OutboundSignatureAlg", elementOrder=57, dataPowerType="dmEBMSSignatureAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms3-signature-alg", refType="", isEnumeration=true, javaName="eBMS3OutboundSignatureAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="rsa-sha1", displayValue="Signature algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3OutboundSignatureAlg(String eBMS3OutboundSignatureAlg) {
        if (eBMS3OutboundSignatureAlg == null || Comparison.isIn(eBMS3OutboundSignatureAlg, DPEnumerations.EBMSSIGNATURE_ALGORITHM)) {
            this.eBMS3OutboundSignatureAlg = eBMS3OutboundSignatureAlg;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMS3OutboundSignatureC14NAlg", elementOrder=58, dataPowerType="dmCryptoCanonicalizationAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms3-signature-c14n-alg", refType="", isEnumeration=true, javaName="eBMS3OutboundSignatureC14NAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Signature canonicalization method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMS3OutboundSignatureC14NAlg() {
        return this.eBMS3OutboundSignatureC14NAlg;
    }

    @XMLInfo(elementType="element", elementName="EBMS3OutboundSignatureC14NAlg", elementOrder=58, dataPowerType="dmCryptoCanonicalizationAlgorithm", subType="", benign=false, isPassword=false, cliAlias="ebms3-signature-c14n-alg", refType="", isEnumeration=true, javaName="eBMS3OutboundSignatureC14NAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Signature canonicalization method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3OutboundSignatureC14NAlg(String eBMS3OutboundSignatureC14NAlg) {
        if (eBMS3OutboundSignatureC14NAlg == null || Comparison.isIn(eBMS3OutboundSignatureC14NAlg, DPEnumerations.CRYPTO_CANONICALIZATION_ALGORITHM)) {
            this.eBMS3OutboundSignatureC14NAlg = eBMS3OutboundSignatureC14NAlg;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMS3InboundVerifyValCred", elementOrder=59, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-verify-valcred", refType="CryptoValCred", isEnumeration=false, javaName="eBMS3InboundVerifyValCred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Inbound signature validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoValCred> getEBMS3InboundVerifyValCred() {
        return this.eBMS3InboundVerifyValCred;
    }

    @XMLInfo(elementType="element", elementName="EBMS3InboundVerifyValCred", elementOrder=59, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-verify-valcred", refType="CryptoValCred", isEnumeration=false, javaName="eBMS3InboundVerifyValCred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Inbound signature validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3InboundVerifyValCred(ObjectReference<ConfigCryptoValCred> eBMS3InboundVerifyValCred) {
        this.eBMS3InboundVerifyValCred = eBMS3InboundVerifyValCred;
    }

    @XMLInfo(elementType="element", elementName="EBMS3DefaultSignerCert", elementOrder=60, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-default-signer-cert", refType="CryptoCertificate", isEnumeration=false, javaName="eBMS3DefaultSignerCert", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Default inbound signature validation certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoCertificate> getEBMS3DefaultSignerCert() {
        return this.eBMS3DefaultSignerCert;
    }

    @XMLInfo(elementType="element", elementName="EBMS3DefaultSignerCert", elementOrder=60, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-default-signer-cert", refType="CryptoCertificate", isEnumeration=false, javaName="eBMS3DefaultSignerCert", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Default inbound signature validation certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3DefaultSignerCert(ObjectReference<ConfigCryptoCertificate> eBMS3DefaultSignerCert) {
        this.eBMS3DefaultSignerCert = eBMS3DefaultSignerCert;
    }

    @XMLInfo(elementType="element", elementName="EBMS3ReceiptSSLProxy", elementOrder=61, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-receipt-ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="eBMS3ReceiptSSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Receipt/Error TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getEBMS3ReceiptSSLProxy() {
        return this.eBMS3ReceiptSSLProxy;
    }

    @XMLInfo(elementType="element", elementName="EBMS3ReceiptSSLProxy", elementOrder=61, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-receipt-ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="eBMS3ReceiptSSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Receipt/Error TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3ReceiptSSLProxy(ObjectReference<ConfigSSLProxyProfile> eBMS3ReceiptSSLProxy) {
        this.eBMS3ReceiptSSLProxy = eBMS3ReceiptSSLProxy;
    }

    @XMLInfo(elementType="element", elementName="EBMS3InboundRequireSigned", elementOrder=62, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms3-require-signed", refType="", isEnumeration=true, javaName="eBMS3InboundRequireSigned", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require signature", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMS3InboundRequireSigned() {
        return this.eBMS3InboundRequireSigned;
    }

    @XMLInfo(elementType="element", elementName="EBMS3InboundRequireSigned", elementOrder=62, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms3-require-signed", refType="", isEnumeration=true, javaName="eBMS3InboundRequireSigned", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require signature", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3InboundRequireSigned(String eBMS3InboundRequireSigned) {
        if (eBMS3InboundRequireSigned == null || Comparison.isIn(eBMS3InboundRequireSigned, DPEnumerations.TOGGLE)) {
            this.eBMS3InboundRequireSigned = eBMS3InboundRequireSigned;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMS3InboundRequireEncrypted", elementOrder=63, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms3-require-encrypted", refType="", isEnumeration=true, javaName="eBMS3InboundRequireEncrypted", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require encryption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMS3InboundRequireEncrypted() {
        return this.eBMS3InboundRequireEncrypted;
    }

    @XMLInfo(elementType="element", elementName="EBMS3InboundRequireEncrypted", elementOrder=63, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms3-require-encrypted", refType="", isEnumeration=true, javaName="eBMS3InboundRequireEncrypted", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require encryption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3InboundRequireEncrypted(String eBMS3InboundRequireEncrypted) {
        if (eBMS3InboundRequireEncrypted == null || Comparison.isIn(eBMS3InboundRequireEncrypted, DPEnumerations.TOGGLE)) {
            this.eBMS3InboundRequireEncrypted = eBMS3InboundRequireEncrypted;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMS3InboundDecryptIdCred", elementOrder=64, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-decrypt-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="eBMS3InboundDecryptIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Inbound decryption identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoIdentCred> getEBMS3InboundDecryptIdCred() {
        return this.eBMS3InboundDecryptIdCred;
    }

    @XMLInfo(elementType="element", elementName="EBMS3InboundDecryptIdCred", elementOrder=64, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-decrypt-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="eBMS3InboundDecryptIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Inbound decryption identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3InboundDecryptIdCred(ObjectReference<ConfigCryptoIdentCred> eBMS3InboundDecryptIdCred) {
        this.eBMS3InboundDecryptIdCred = eBMS3InboundDecryptIdCred;
    }

    @XMLInfo(elementType="element", elementName="EBMS3InboundRequireCompressed", elementOrder=65, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms3-require-compressed", refType="", isEnumeration=true, javaName="eBMS3InboundRequireCompressed", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require compression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMS3InboundRequireCompressed() {
        return this.eBMS3InboundRequireCompressed;
    }

    @XMLInfo(elementType="element", elementName="EBMS3InboundRequireCompressed", elementOrder=65, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms3-require-compressed", refType="", isEnumeration=true, javaName="eBMS3InboundRequireCompressed", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require compression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3InboundRequireCompressed(String eBMS3InboundRequireCompressed) {
        if (eBMS3InboundRequireCompressed == null || Comparison.isIn(eBMS3InboundRequireCompressed, DPEnumerations.TOGGLE)) {
            this.eBMS3InboundRequireCompressed = eBMS3InboundRequireCompressed;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMS3ReceiptSSLClientConfigType", elementOrder=66, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ebms3-receipt-ssl-client-type", refType="", isEnumeration=true, javaName="eBMS3ReceiptSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="proxy", displayOrder=0, displayValue="Receipt/Error TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMS3ReceiptSSLClientConfigType() {
        return this.eBMS3ReceiptSSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="EBMS3ReceiptSSLClientConfigType", elementOrder=66, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ebms3-receipt-ssl-client-type", refType="", isEnumeration=true, javaName="eBMS3ReceiptSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="proxy", displayValue="Receipt/Error TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3ReceiptSSLClientConfigType(String eBMS3ReceiptSSLClientConfigType) {
        if (eBMS3ReceiptSSLClientConfigType == null || Comparison.isIn(eBMS3ReceiptSSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.eBMS3ReceiptSSLClientConfigType = eBMS3ReceiptSSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMS3ReceiptSSLClient", elementOrder=67, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-receipt-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="eBMS3ReceiptSSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Receipt/Error TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getEBMS3ReceiptSSLClient() {
        return this.eBMS3ReceiptSSLClient;
    }

    @XMLInfo(elementType="element", elementName="EBMS3ReceiptSSLClient", elementOrder=67, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms3-receipt-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="eBMS3ReceiptSSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Receipt/Error TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3ReceiptSSLClient(ObjectReference<ConfigSSLClientProfile> eBMS3ReceiptSSLClient) {
        this.eBMS3ReceiptSSLClient = eBMS3ReceiptSSLClient;
    }

    @XMLInfo(elementType="element", elementName="EBMSNotification", elementOrder=68, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-notification", refType="", isEnumeration=true, javaName="eBMSNotification", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable notification", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSNotification() {
        return this.eBMSNotification;
    }

    @XMLInfo(elementType="element", elementName="EBMSNotification", elementOrder=68, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms-notification", refType="", isEnumeration=true, javaName="eBMSNotification", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable notification", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSNotification(String eBMSNotification) {
        if (eBMSNotification == null || Comparison.isIn(eBMSNotification, DPEnumerations.TOGGLE)) {
            this.eBMSNotification = eBMSNotification;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSNotificationURL", elementOrder=69, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="ebms-notification-url", refType="", isEnumeration=false, javaName="eBMSNotificationURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Notification URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSNotificationURL() {
        return this.eBMSNotificationURL;
    }

    @XMLInfo(elementType="element", elementName="EBMSNotificationURL", elementOrder=69, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="ebms-notification-url", refType="", isEnumeration=false, javaName="eBMSNotificationURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Notification URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSNotificationURL(String eBMSNotificationURL) {
        this.eBMSNotificationURL = eBMSNotificationURL;
    }

    @XMLInfo(elementType="element", elementName="EBMSNotificationSSLClientConfigType", elementOrder=70, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ebms-notification-ssl-client-type", refType="", isEnumeration=true, javaName="eBMSNotificationSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="proxy", displayOrder=0, displayValue="Notification TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMSNotificationSSLClientConfigType() {
        return this.eBMSNotificationSSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="EBMSNotificationSSLClientConfigType", elementOrder=70, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ebms-notification-ssl-client-type", refType="", isEnumeration=true, javaName="eBMSNotificationSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="proxy", displayValue="Notification TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSNotificationSSLClientConfigType(String eBMSNotificationSSLClientConfigType) {
        if (eBMSNotificationSSLClientConfigType == null || Comparison.isIn(eBMSNotificationSSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.eBMSNotificationSSLClientConfigType = eBMSNotificationSSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMSNotificationSSLProxy", elementOrder=71, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-notification-ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="eBMSNotificationSSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Notification TLS Proxy Profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getEBMSNotificationSSLProxy() {
        return this.eBMSNotificationSSLProxy;
    }

    @XMLInfo(elementType="element", elementName="EBMSNotificationSSLProxy", elementOrder=71, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-notification-ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="eBMSNotificationSSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Notification TLS Proxy Profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSNotificationSSLProxy(ObjectReference<ConfigSSLProxyProfile> eBMSNotificationSSLProxy) {
        this.eBMSNotificationSSLProxy = eBMSNotificationSSLProxy;
    }

    @XMLInfo(elementType="element", elementName="EBMSNotificationSSLClient", elementOrder=72, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-notification-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="eBMSNotificationSSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Notification TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getEBMSNotificationSSLClient() {
        return this.eBMSNotificationSSLClient;
    }

    @XMLInfo(elementType="element", elementName="EBMSNotificationSSLClient", elementOrder=72, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ebms-notification-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="eBMSNotificationSSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Notification TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSNotificationSSLClient(ObjectReference<ConfigSSLClientProfile> eBMSNotificationSSLClient) {
        this.eBMSNotificationSSLClient = eBMSNotificationSSLClient;
    }

    @XMLInfo(elementType="element", elementName="EBMS3AllowDuplicateMessage", elementOrder=73, dataPowerType="dmAllowDuplicateMessage", subType="", benign=false, isPassword=false, cliAlias="ebms3-allow-dup-msg", refType="", isEnumeration=true, javaName="eBMS3AllowDuplicateMessage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="never", displayOrder=0, displayValue="Allow duplicate ebMS3 inbound message", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMS3AllowDuplicateMessage() {
        return this.eBMS3AllowDuplicateMessage;
    }

    @XMLInfo(elementType="element", elementName="EBMS3AllowDuplicateMessage", elementOrder=73, dataPowerType="dmAllowDuplicateMessage", subType="", benign=false, isPassword=false, cliAlias="ebms3-allow-dup-msg", refType="", isEnumeration=true, javaName="eBMS3AllowDuplicateMessage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="never", displayValue="Allow duplicate ebMS3 inbound message", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3AllowDuplicateMessage(String eBMS3AllowDuplicateMessage) {
        if (eBMS3AllowDuplicateMessage == null || Comparison.isIn(eBMS3AllowDuplicateMessage, DPEnumerations.ALLOW_DUPLICATE_MESSAGE)) {
            this.eBMS3AllowDuplicateMessage = eBMS3AllowDuplicateMessage;
        }
    }

    @XMLInfo(elementType="element", elementName="EBMS3DuplicateDetectionNotification", elementOrder=74, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms3-duplicate-detection-notification", refType="", isEnumeration=true, javaName="eBMS3DuplicateDetectionNotification", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Duplicate detection notification", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEBMS3DuplicateDetectionNotification() {
        return this.eBMS3DuplicateDetectionNotification;
    }

    @XMLInfo(elementType="element", elementName="EBMS3DuplicateDetectionNotification", elementOrder=74, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ebms3-duplicate-detection-notification", refType="", isEnumeration=true, javaName="eBMS3DuplicateDetectionNotification", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Duplicate detection notification", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMS3DuplicateDetectionNotification(String eBMS3DuplicateDetectionNotification) {
        if (eBMS3DuplicateDetectionNotification == null || Comparison.isIn(eBMS3DuplicateDetectionNotification, DPEnumerations.TOGGLE)) {
            this.eBMS3DuplicateDetectionNotification = eBMS3DuplicateDetectionNotification;
        }
    }

    public void addEBMSMessageProperties(B2BMessageProperties element) {
        if (element == null) {
            return;
        }
        if (this.eBMSMessageProperties == null) {
            this.eBMSMessageProperties = new ArrayList();
        }
        this.eBMSMessageProperties.add(element);
    }

    public boolean removeEBMSMessageProperties(B2BMessageProperties element) {
        if (element == null || this.eBMSMessageProperties == null) {
            return false;
        }
        return this.eBMSMessageProperties.remove(element);
    }

    @XMLInfo(elementType="element", elementName="EBMSMessageProperties", elementOrder=75, dataPowerType="dmB2BMessageProperties", subType="", benign=false, isPassword=false, cliAlias="ebms-messageproperties", refType="", isEnumeration=false, javaName="eBMSMessageProperties", javaType="B2BMessageProperties", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="ebMS3 message properties", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<B2BMessageProperties> getEBMSMessageProperties() {
        return this.eBMSMessageProperties;
    }

    @XMLInfo(elementType="element", elementName="EBMSMessageProperties", elementOrder=75, dataPowerType="dmB2BMessageProperties", subType="", benign=false, isPassword=false, cliAlias="ebms-messageproperties", refType="", isEnumeration=false, javaName="eBMSMessageProperties", javaType="B2BMessageProperties", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="ebMS3 message properties", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEBMSMessageProperties(ArrayList<B2BMessageProperties> eBMSMessageProperties) {
        this.eBMSMessageProperties = eBMSMessageProperties;
    }

    @Override
    public int compareTo(ConfigB2BProfile that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "profileType", "businessIDs", "businessIDsDUNS", "businessIDsDUNSPlus4", "customStylePolicy", "responseType", "emailAddresses", "destinations", "inboundVerifyValCred", "inboundRequireSigned", "inboundRequireEncrypted", "inboundDecryptIdCred", "mDNSSLProxy", "outboundSign", "outboundSignIdCred", "outboundSignDigestAlg", "outboundSignMICAlgVersion", "contacts", "overrideASID", "aSAllowDuplicateMessage", "preserveFilename", "eBMSRole", "eBMSPersistDuration", "eBMSAckURL", "eBMSErrorURL", "eBMSInboundSendReceipt", "eBMSInboundSendSignedReceipt", "eBMSInboundReceiptReplyPattern", "eBMSReceiptURL", "eBMSInboundErrorURL", "eBMSInboundVerifyValCred", "eBMSDefaultSignerCert", "eBMSAckSSLProxy", "eBMSInboundRequireSigned", "eBMSInboundRequireEncrypted", "eBMSInboundDecryptIdCred", "eBMSOutboundSign", "eBMSOutboundSignIdCred", "eBMSOutboundSignatureAlg", "eBMSOutboundSignatureC14NAlg", "eBMSOutboundSignDigestAlg", "eBMSEnableCPABinding", "eBMSProfileCPABindings", "eBMSCpaId", "eBMSService", "eBMSAction", "eBMSStartParameter", "eBMSAllowDuplicateMessage", "mDNSSLClientConfigType", "mDNSSLClient", "eBMSAckSSLClientConfigType", "eBMSAckSSLClient", "eBMS3OutboundSign", "eBMS3OutboundSignIdCred", "eBMS3OutboundSignDigestAlg", "eBMS3OutboundSignatureAlg", "eBMS3OutboundSignatureC14NAlg", "eBMS3InboundVerifyValCred", "eBMS3DefaultSignerCert", "eBMS3ReceiptSSLProxy", "eBMS3InboundRequireSigned", "eBMS3InboundRequireEncrypted", "eBMS3InboundDecryptIdCred", "eBMS3InboundRequireCompressed", "eBMS3ReceiptSSLClientConfigType", "eBMS3ReceiptSSLClient", "eBMSNotification", "eBMSNotificationURL", "eBMSNotificationSSLClientConfigType", "eBMSNotificationSSLProxy", "eBMSNotificationSSLClient", "eBMS3AllowDuplicateMessage", "eBMS3DuplicateDetectionNotification", "eBMSMessageProperties");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.profileType, this.businessIDs, this.businessIDsDUNS, this.businessIDsDUNSPlus4, this.customStylePolicy, this.responseType, this.emailAddresses, this.destinations, this.inboundVerifyValCred, this.inboundRequireSigned, this.inboundRequireEncrypted, this.inboundDecryptIdCred, this.mDNSSLProxy, this.outboundSign, this.outboundSignIdCred, this.outboundSignDigestAlg, this.outboundSignMICAlgVersion, this.contacts, this.overrideASID, this.aSAllowDuplicateMessage, this.preserveFilename, this.eBMSRole, this.eBMSPersistDuration, this.eBMSAckURL, this.eBMSErrorURL, this.eBMSInboundSendReceipt, this.eBMSInboundSendSignedReceipt, this.eBMSInboundReceiptReplyPattern, this.eBMSReceiptURL, this.eBMSInboundErrorURL, this.eBMSInboundVerifyValCred, this.eBMSDefaultSignerCert, this.eBMSAckSSLProxy, this.eBMSInboundRequireSigned, this.eBMSInboundRequireEncrypted, this.eBMSInboundDecryptIdCred, this.eBMSOutboundSign, this.eBMSOutboundSignIdCred, this.eBMSOutboundSignatureAlg, this.eBMSOutboundSignatureC14NAlg, this.eBMSOutboundSignDigestAlg, this.eBMSEnableCPABinding, this.eBMSProfileCPABindings, this.eBMSCpaId, this.eBMSService, this.eBMSAction, this.eBMSStartParameter, this.eBMSAllowDuplicateMessage, this.mDNSSLClientConfigType, this.mDNSSLClient, this.eBMSAckSSLClientConfigType, this.eBMSAckSSLClient, this.eBMS3OutboundSign, this.eBMS3OutboundSignIdCred, this.eBMS3OutboundSignDigestAlg, this.eBMS3OutboundSignatureAlg, this.eBMS3OutboundSignatureC14NAlg, this.eBMS3InboundVerifyValCred, this.eBMS3DefaultSignerCert, this.eBMS3ReceiptSSLProxy, this.eBMS3InboundRequireSigned, this.eBMS3InboundRequireEncrypted, this.eBMS3InboundDecryptIdCred, this.eBMS3InboundRequireCompressed, this.eBMS3ReceiptSSLClientConfigType, this.eBMS3ReceiptSSLClient, this.eBMSNotification, this.eBMSNotificationURL, this.eBMSNotificationSSLClientConfigType, this.eBMSNotificationSSLProxy, this.eBMSNotificationSSLClient, this.eBMS3AllowDuplicateMessage, this.eBMS3DuplicateDetectionNotification, this.eBMSMessageProperties);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "profileType", "businessIDs", "businessIDsDUNS", "businessIDsDUNSPlus4", "customStylePolicy", "responseType", "emailAddresses", "destinations", "inboundVerifyValCred", "inboundRequireSigned", "inboundRequireEncrypted", "inboundDecryptIdCred", "mDNSSLProxy", "outboundSign", "outboundSignIdCred", "outboundSignDigestAlg", "outboundSignMICAlgVersion", "contacts", "overrideASID", "aSAllowDuplicateMessage", "preserveFilename", "eBMSRole", "eBMSPersistDuration", "eBMSAckURL", "eBMSErrorURL", "eBMSInboundSendReceipt", "eBMSInboundSendSignedReceipt", "eBMSInboundReceiptReplyPattern", "eBMSReceiptURL", "eBMSInboundErrorURL", "eBMSInboundVerifyValCred", "eBMSDefaultSignerCert", "eBMSAckSSLProxy", "eBMSInboundRequireSigned", "eBMSInboundRequireEncrypted", "eBMSInboundDecryptIdCred", "eBMSOutboundSign", "eBMSOutboundSignIdCred", "eBMSOutboundSignatureAlg", "eBMSOutboundSignatureC14NAlg", "eBMSOutboundSignDigestAlg", "eBMSEnableCPABinding", "eBMSProfileCPABindings", "eBMSCpaId", "eBMSService", "eBMSAction", "eBMSStartParameter", "eBMSAllowDuplicateMessage", "mDNSSLClientConfigType", "mDNSSLClient", "eBMSAckSSLClientConfigType", "eBMSAckSSLClient", "eBMS3OutboundSign", "eBMS3OutboundSignIdCred", "eBMS3OutboundSignDigestAlg", "eBMS3OutboundSignatureAlg", "eBMS3OutboundSignatureC14NAlg", "eBMS3InboundVerifyValCred", "eBMS3DefaultSignerCert", "eBMS3ReceiptSSLProxy", "eBMS3InboundRequireSigned", "eBMS3InboundRequireEncrypted", "eBMS3InboundDecryptIdCred", "eBMS3InboundRequireCompressed", "eBMS3ReceiptSSLClientConfigType", "eBMS3ReceiptSSLClient", "eBMSNotification", "eBMSNotificationURL", "eBMSNotificationSSLClientConfigType", "eBMSNotificationSSLProxy", "eBMSNotificationSSLClient", "eBMS3AllowDuplicateMessage", "eBMS3DuplicateDetectionNotification", "eBMSMessageProperties");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "profileType", "businessIDs", "businessIDsDUNS", "businessIDsDUNSPlus4", "customStylePolicy", "responseType", "emailAddresses", "destinations", "inboundVerifyValCred", "inboundRequireSigned", "inboundRequireEncrypted", "inboundDecryptIdCred", "mDNSSLProxy", "outboundSign", "outboundSignIdCred", "outboundSignDigestAlg", "outboundSignMICAlgVersion", "contacts", "overrideASID", "aSAllowDuplicateMessage", "preserveFilename", "eBMSRole", "eBMSPersistDuration", "eBMSAckURL", "eBMSErrorURL", "eBMSInboundSendReceipt", "eBMSInboundSendSignedReceipt", "eBMSInboundReceiptReplyPattern", "eBMSReceiptURL", "eBMSInboundErrorURL", "eBMSInboundVerifyValCred", "eBMSDefaultSignerCert", "eBMSAckSSLProxy", "eBMSInboundRequireSigned", "eBMSInboundRequireEncrypted", "eBMSInboundDecryptIdCred", "eBMSOutboundSign", "eBMSOutboundSignIdCred", "eBMSOutboundSignatureAlg", "eBMSOutboundSignatureC14NAlg", "eBMSOutboundSignDigestAlg", "eBMSEnableCPABinding", "eBMSProfileCPABindings", "eBMSCpaId", "eBMSService", "eBMSAction", "eBMSStartParameter", "eBMSAllowDuplicateMessage", "mDNSSLClientConfigType", "mDNSSLClient", "eBMSAckSSLClientConfigType", "eBMSAckSSLClient", "eBMS3OutboundSign", "eBMS3OutboundSignIdCred", "eBMS3OutboundSignDigestAlg", "eBMS3OutboundSignatureAlg", "eBMS3OutboundSignatureC14NAlg", "eBMS3InboundVerifyValCred", "eBMS3DefaultSignerCert", "eBMS3ReceiptSSLProxy", "eBMS3InboundRequireSigned", "eBMS3InboundRequireEncrypted", "eBMS3InboundDecryptIdCred", "eBMS3InboundRequireCompressed", "eBMS3ReceiptSSLClientConfigType", "eBMS3ReceiptSSLClient", "eBMSNotification", "eBMSNotificationURL", "eBMSNotificationSSLClientConfigType", "eBMSNotificationSSLProxy", "eBMSNotificationSSLClient", "eBMS3AllowDuplicateMessage", "eBMS3DuplicateDetectionNotification", "eBMSMessageProperties"));
    }
}

