/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.config.ConfigCryptoKey;
import com.kumbasoft.core.beans.config.ConfigCryptoSSKey;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.JOSEHeader;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigJWSSignature
extends ConfigCrypto {
    private String userSummary;
    private String algorithm;
    private ObjectReference<ConfigCryptoKey> key;
    private ObjectReference<ConfigCryptoSSKey> sSKey;
    private ArrayList<JOSEHeader> protectedHeader;
    private ArrayList<JOSEHeader> unprotectedHeader;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Algorithm", elementOrder=2, dataPowerType="dmJWSSignAlgorithm", subType="", benign=false, isPassword=false, cliAlias="alg", refType="", isEnumeration=true, javaName="algorithm", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="RS256", displayOrder=0, displayValue="Algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAlgorithm() {
        return this.algorithm;
    }

    @XMLInfo(elementType="element", elementName="Algorithm", elementOrder=2, dataPowerType="dmJWSSignAlgorithm", subType="", benign=false, isPassword=false, cliAlias="alg", refType="", isEnumeration=true, javaName="algorithm", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="RS256", displayValue="Algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAlgorithm(String algorithm) {
        if (Comparison.isIn(algorithm, DPEnumerations.JWSSIGN_ALGORITHM)) {
            this.algorithm = algorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="Key", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="key", refType="CryptoKey", isEnumeration=false, javaName="key", javaType="ObjectReference<ConfigCryptoKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Private Key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoKey> getKey() {
        return this.key;
    }

    @XMLInfo(elementType="element", elementName="Key", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="key", refType="CryptoKey", isEnumeration=false, javaName="key", javaType="ObjectReference<ConfigCryptoKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Private Key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setKey(ObjectReference<ConfigCryptoKey> key) {
        this.key = key;
    }

    @XMLInfo(elementType="element", elementName="SSKey", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sskey", refType="CryptoSSKey", isEnumeration=false, javaName="sSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Shared Secret Key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoSSKey> getSSKey() {
        return this.sSKey;
    }

    @XMLInfo(elementType="element", elementName="SSKey", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sskey", refType="CryptoSSKey", isEnumeration=false, javaName="sSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Shared Secret Key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSKey(ObjectReference<ConfigCryptoSSKey> sSKey) {
        this.sSKey = sSKey;
    }

    public void addProtectedHeader(JOSEHeader element) {
        if (element == null) {
            return;
        }
        if (this.protectedHeader == null) {
            this.protectedHeader = new ArrayList();
        }
        this.protectedHeader.add(element);
    }

    public boolean removeProtectedHeader(JOSEHeader element) {
        if (element == null || this.protectedHeader == null) {
            return false;
        }
        return this.protectedHeader.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ProtectedHeader", elementOrder=5, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="protected-header", refType="", isEnumeration=false, javaName="protectedHeader", javaType="JOSEHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Protected Header", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<JOSEHeader> getProtectedHeader() {
        return this.protectedHeader;
    }

    @XMLInfo(elementType="element", elementName="ProtectedHeader", elementOrder=5, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="protected-header", refType="", isEnumeration=false, javaName="protectedHeader", javaType="JOSEHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Protected Header", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProtectedHeader(ArrayList<JOSEHeader> protectedHeader) {
        this.protectedHeader = protectedHeader;
    }

    public void addUnprotectedHeader(JOSEHeader element) {
        if (element == null) {
            return;
        }
        if (this.unprotectedHeader == null) {
            this.unprotectedHeader = new ArrayList();
        }
        this.unprotectedHeader.add(element);
    }

    public boolean removeUnprotectedHeader(JOSEHeader element) {
        if (element == null || this.unprotectedHeader == null) {
            return false;
        }
        return this.unprotectedHeader.remove(element);
    }

    @XMLInfo(elementType="element", elementName="UnprotectedHeader", elementOrder=6, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="unprotected-header", refType="", isEnumeration=false, javaName="unprotectedHeader", javaType="JOSEHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Unprotected Header", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<JOSEHeader> getUnprotectedHeader() {
        return this.unprotectedHeader;
    }

    @XMLInfo(elementType="element", elementName="UnprotectedHeader", elementOrder=6, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="unprotected-header", refType="", isEnumeration=false, javaName="unprotectedHeader", javaType="JOSEHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Unprotected Header", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUnprotectedHeader(ArrayList<JOSEHeader> unprotectedHeader) {
        this.unprotectedHeader = unprotectedHeader;
    }

    @Override
    public int compareTo(ConfigJWSSignature that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "algorithm", "key", "sSKey", "protectedHeader", "unprotectedHeader");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.algorithm, this.key, this.sSKey, this.protectedHeader, this.unprotectedHeader);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "algorithm", "key", "sSKey", "protectedHeader", "unprotectedHeader");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "algorithm", "key", "sSKey", "protectedHeader", "unprotectedHeader"));
    }
}

