/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.config.ConfigSSLSNIServerProfile;
import com.kumbasoft.core.beans.config.ConfigSSLServerProfile;
import com.kumbasoft.core.beans.config.ConfigService;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigSSLProxyService
extends ConfigService {
    private String userSummary;
    private String priority;
    private int localPort;
    private String remoteAddress;
    private int remotePort;
    private ObjectReference<ConfigSSLProxyProfile> sSLProxy;
    private long frontTimeout;
    private long backTimeout;
    private long connTimeout;
    private long connLimit;
    private String sSLConfigType;
    private ObjectReference<ConfigSSLServerProfile> sSLServer;
    private ObjectReference<ConfigSSLSNIServerProfile> sSLSNIServer;
    private ObjectReference<ConfigSSLClientProfile> sSLClient;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=3, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="normal", displayOrder=0, displayValue="Service priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPriority() {
        return this.priority;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=3, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="normal", displayValue="Service priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPriority(String priority) {
        if (priority == null || Comparison.isIn(priority, DPEnumerations.SCHEDULER_PRIORITY)) {
            this.priority = priority;
        }
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=4, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="local-port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Local port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=4, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="local-port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Local port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="RemoteAddress", elementOrder=5, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="remote-address", refType="", isEnumeration=false, javaName="remoteAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Remote host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @XMLInfo(elementType="element", elementName="RemoteAddress", elementOrder=5, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="remote-address", refType="", isEnumeration=false, javaName="remoteAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Remote host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @XMLInfo(elementType="element", elementName="RemotePort", elementOrder=6, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="remote-port", refType="", isEnumeration=false, javaName="remotePort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Remote port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getRemotePort() {
        return this.remotePort;
    }

    @XMLInfo(elementType="element", elementName="RemotePort", elementOrder=6, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="remote-port", refType="", isEnumeration=false, javaName="remotePort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Remote port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-proxy", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getSSLProxy() {
        return this.sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-proxy", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLProxy(ObjectReference<ConfigSSLProxyProfile> sSLProxy) {
        this.sSLProxy = sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="FrontTimeout", elementOrder=8, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-timeout", refType="", isEnumeration=false, javaName="frontTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Client-side timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getFrontTimeout() {
        return this.frontTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontTimeout", elementOrder=8, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-timeout", refType="", isEnumeration=false, javaName="frontTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Client-side timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontTimeout(long frontTimeout) {
        this.frontTimeout = frontTimeout;
    }

    @XMLInfo(elementType="element", elementName="BackTimeout", elementOrder=9, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="back-timeout", refType="", isEnumeration=false, javaName="backTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Server-side timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getBackTimeout() {
        return this.backTimeout;
    }

    @XMLInfo(elementType="element", elementName="BackTimeout", elementOrder=9, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="back-timeout", refType="", isEnumeration=false, javaName="backTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Server-side timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBackTimeout(long backTimeout) {
        this.backTimeout = backTimeout;
    }

    @XMLInfo(elementType="element", elementName="ConnTimeout", elementOrder=10, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="connection-timeout", refType="", isEnumeration=false, javaName="connTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Transaction timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getConnTimeout() {
        return this.connTimeout;
    }

    @XMLInfo(elementType="element", elementName="ConnTimeout", elementOrder=10, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="connection-timeout", refType="", isEnumeration=false, javaName="connTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Transaction timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConnTimeout(long connTimeout) {
        this.connTimeout = connTimeout;
    }

    @XMLInfo(elementType="element", elementName="ConnLimit", elementOrder=11, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maximum-connections", refType="", isEnumeration=false, javaName="connLimit", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="100", displayOrder=0, displayValue="Max client connections", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getConnLimit() {
        return this.connLimit;
    }

    @XMLInfo(elementType="element", elementName="ConnLimit", elementOrder=11, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maximum-connections", refType="", isEnumeration=false, javaName="connLimit", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="100", displayValue="Max client connections", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConnLimit(long connLimit) {
        this.connLimit = connLimit;
    }

    @XMLInfo(elementType="element", elementName="SSLConfigType", elementOrder=12, dataPowerType="dmSSLConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-config-type", refType="", isEnumeration=true, javaName="sSLConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="proxy", displayOrder=0, displayValue="TLS type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLConfigType() {
        return this.sSLConfigType;
    }

    @XMLInfo(elementType="element", elementName="SSLConfigType", elementOrder=12, dataPowerType="dmSSLConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-config-type", refType="", isEnumeration=true, javaName="sSLConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="proxy", displayValue="TLS type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLConfigType(String sSLConfigType) {
        if (sSLConfigType == null || Comparison.isIn(sSLConfigType, DPEnumerations.SSLCONFIG_TYPE)) {
            this.sSLConfigType = sSLConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-server", refType="SSLServerProfile", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference<ConfigSSLServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLServerProfile> getSSLServer() {
        return this.sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-server", refType="SSLServerProfile", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference<ConfigSSLServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLServer(ObjectReference<ConfigSSLServerProfile> sSLServer) {
        this.sSLServer = sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLSNIServer", elementOrder=14, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="ssl-sni-server", refType="SSLSNIServerProfile", isEnumeration=false, javaName="sSLSNIServer", javaType="ObjectReference<ConfigSSLSNIServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS SNI server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLSNIServerProfile> getSSLSNIServer() {
        return this.sSLSNIServer;
    }

    @XMLInfo(elementType="element", elementName="SSLSNIServer", elementOrder=14, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="ssl-sni-server", refType="SSLSNIServerProfile", isEnumeration=false, javaName="sSLSNIServer", javaType="ObjectReference<ConfigSSLSNIServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS SNI server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLSNIServer(ObjectReference<ConfigSSLSNIServerProfile> sSLSNIServer) {
        this.sSLSNIServer = sSLSNIServer;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(ObjectReference<ConfigSSLClientProfile> sSLClient) {
        this.sSLClient = sSLClient;
    }

    @Override
    public int compareTo(ConfigSSLProxyService that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "priority", "localPort", "remoteAddress", "remotePort", "sSLProxy", "frontTimeout", "backTimeout", "connTimeout", "connLimit", "sSLConfigType", "sSLServer", "sSLSNIServer", "sSLClient");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.priority, this.localPort, this.remoteAddress, this.remotePort, this.sSLProxy, this.frontTimeout, this.backTimeout, this.connTimeout, this.connLimit, this.sSLConfigType, this.sSLServer, this.sSLSNIServer, this.sSLClient);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "priority", "localPort", "remoteAddress", "remotePort", "sSLProxy", "frontTimeout", "backTimeout", "connTimeout", "connLimit", "sSLConfigType", "sSLServer", "sSLSNIServer", "sSLClient");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "priority", "localPort", "remoteAddress", "remotePort", "sSLProxy", "frontTimeout", "backTimeout", "connTimeout", "connLimit", "sSLConfigType", "sSLServer", "sSLSNIServer", "sSLClient"));
    }
}

