/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAccessControl;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.TAMAZReplica;
import com.kumbasoft.core.beans.types.TAMFedDir;
import com.kumbasoft.core.beans.types.TAMRASTrace;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigTAM
extends ConfigAccessControl {
    private String userSummary;
    private String aDUseAD;
    private String tAMVersion;
    private String configurationFile;
    private String aDConfigurationFile;
    private String sSLKeyFile;
    private String sSLKeyStashFile;
    private String useLocalMode;
    private String pollInterval;
    private String listenMode;
    private int listenPort;
    private String returningUserAttributes;
    private String lDAPUseSSL;
    private int lDAPSSLPort;
    private String lDAPSSLKeyFile;
    private String lDAPSSLKeyFilePassword;
    private ObjectReference<ConfigPasswordAlias> lDAPSSLKeyFilePasswordAlias;
    private String lDAPSSLKeyFileLabel;
    private String tAMUseFIPS;
    private String tAMChooseNIST;
    private String tAMUseBasicUser;
    private String userPrincipalAttribute;
    private String userNoDuplicates;
    private ArrayList<String> userSearchSuffixes;
    private String userSuffixOptimiser;
    private ArrayList<TAMFedDir> tAMFedDirs;
    private ArrayList<TAMAZReplica> tAMAZReplicas;
    private TAMRASTrace tAMRASTrace;
    private String autoRetry;
    private int retryInterval;
    private int retryAttempts;
    private int longRetryInterval;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="ADUseAD", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ad-use-ad", refType="", isEnumeration=true, javaName="aDUseAD", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Use Active Directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADUseAD() {
        return this.aDUseAD;
    }

    @XMLInfo(elementType="element", elementName="ADUseAD", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ad-use-ad", refType="", isEnumeration=true, javaName="aDUseAD", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Use Active Directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADUseAD(String aDUseAD) {
        if (aDUseAD == null || Comparison.isIn(aDUseAD, DPEnumerations.TOGGLE)) {
            this.aDUseAD = aDUseAD;
        }
    }

    @XMLInfo(elementType="element", elementName="TAMVersion", elementOrder=3, dataPowerType="dmTAMVersionType", subType="", benign=false, isPassword=false, cliAlias="tam-version", refType="", isEnumeration=true, javaName="tAMVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Access Manager Client Version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTAMVersion() {
        return this.tAMVersion;
    }

    @XMLInfo(elementType="element", elementName="TAMVersion", elementOrder=3, dataPowerType="dmTAMVersionType", subType="", benign=false, isPassword=false, cliAlias="tam-version", refType="", isEnumeration=true, javaName="tAMVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Access Manager Client Version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTAMVersion(String tAMVersion) {
        if (tAMVersion == null || Comparison.isIn(tAMVersion, DPEnumerations.TAMVERSION_TYPE)) {
            this.tAMVersion = tAMVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="ConfigurationFile", elementOrder=4, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="file", refType="", isEnumeration=false, javaName="configurationFile", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Configuration File for Access Manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getConfigurationFile() {
        return this.configurationFile;
    }

    @XMLInfo(elementType="element", elementName="ConfigurationFile", elementOrder=4, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="file", refType="", isEnumeration=false, javaName="configurationFile", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Configuration File for Access Manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    @XMLInfo(elementType="element", elementName="ADConfigurationFile", elementOrder=5, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="reg_file", refType="", isEnumeration=false, javaName="aDConfigurationFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Configuration File for Directories", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADConfigurationFile() {
        return this.aDConfigurationFile;
    }

    @XMLInfo(elementType="element", elementName="ADConfigurationFile", elementOrder=5, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="reg_file", refType="", isEnumeration=false, javaName="aDConfigurationFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Configuration File for Directories", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADConfigurationFile(String aDConfigurationFile) {
        this.aDConfigurationFile = aDConfigurationFile;
    }

    @XMLInfo(elementType="element", elementName="SSLKeyFile", elementOrder=6, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="ssl-key", refType="", isEnumeration=false, javaName="sSLKeyFile", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS Key File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLKeyFile() {
        return this.sSLKeyFile;
    }

    @XMLInfo(elementType="element", elementName="SSLKeyFile", elementOrder=6, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="ssl-key", refType="", isEnumeration=false, javaName="sSLKeyFile", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS Key File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLKeyFile(String sSLKeyFile) {
        this.sSLKeyFile = sSLKeyFile;
    }

    @XMLInfo(elementType="element", elementName="SSLKeyStashFile", elementOrder=7, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="ssl-key-stash", refType="", isEnumeration=false, javaName="sSLKeyStashFile", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS Key Stash File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLKeyStashFile() {
        return this.sSLKeyStashFile;
    }

    @XMLInfo(elementType="element", elementName="SSLKeyStashFile", elementOrder=7, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="ssl-key-stash", refType="", isEnumeration=false, javaName="sSLKeyStashFile", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS Key Stash File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLKeyStashFile(String sSLKeyStashFile) {
        this.sSLKeyStashFile = sSLKeyStashFile;
    }

    @XMLInfo(elementType="element", elementName="UseLocalMode", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-local-mode", refType="", isEnumeration=true, javaName="useLocalMode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Use Local Policy Database", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUseLocalMode() {
        return this.useLocalMode;
    }

    @XMLInfo(elementType="element", elementName="UseLocalMode", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-local-mode", refType="", isEnumeration=true, javaName="useLocalMode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Use Local Policy Database", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUseLocalMode(String useLocalMode) {
        if (Comparison.isIn(useLocalMode, DPEnumerations.TOGGLE)) {
            this.useLocalMode = useLocalMode;
        }
    }

    @XMLInfo(elementType="element", elementName="PollInterval", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="cache-refresh-interval", refType="", isEnumeration=false, javaName="pollInterval", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default", displayOrder=0, displayValue="Local Database Refresh Interval", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPollInterval() {
        return this.pollInterval;
    }

    @XMLInfo(elementType="element", elementName="PollInterval", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="cache-refresh-interval", refType="", isEnumeration=false, javaName="pollInterval", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default", displayValue="Local Database Refresh Interval", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPollInterval(String pollInterval) {
        this.pollInterval = pollInterval;
    }

    @XMLInfo(elementType="element", elementName="ListenMode", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="listen-mode", refType="", isEnumeration=true, javaName="listenMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Accept Update Notifications", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getListenMode() {
        return this.listenMode;
    }

    @XMLInfo(elementType="element", elementName="ListenMode", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="listen-mode", refType="", isEnumeration=true, javaName="listenMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Accept Update Notifications", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setListenMode(String listenMode) {
        if (listenMode == null || Comparison.isIn(listenMode, DPEnumerations.TOGGLE)) {
            this.listenMode = listenMode;
        }
    }

    @XMLInfo(elementType="element", elementName="ListenPort", elementOrder=11, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="listen-port", refType="", isEnumeration=false, javaName="listenPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Update Notification Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getListenPort() {
        return this.listenPort;
    }

    @XMLInfo(elementType="element", elementName="ListenPort", elementOrder=11, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="listen-port", refType="", isEnumeration=false, javaName="listenPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Update Notification Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    @XMLInfo(elementType="element", elementName="ReturningUserAttributes", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="return-attributes", refType="", isEnumeration=true, javaName="returningUserAttributes", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Return User Attributes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getReturningUserAttributes() {
        return this.returningUserAttributes;
    }

    @XMLInfo(elementType="element", elementName="ReturningUserAttributes", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="return-attributes", refType="", isEnumeration=true, javaName="returningUserAttributes", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Return User Attributes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setReturningUserAttributes(String returningUserAttributes) {
        if (returningUserAttributes == null || Comparison.isIn(returningUserAttributes, DPEnumerations.TOGGLE)) {
            this.returningUserAttributes = returningUserAttributes;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPUseSSL", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-ldap-ssl", refType="", isEnumeration=true, javaName="lDAPUseSSL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Use TLS with Registry Server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPUseSSL() {
        return this.lDAPUseSSL;
    }

    @XMLInfo(elementType="element", elementName="LDAPUseSSL", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-ldap-ssl", refType="", isEnumeration=true, javaName="lDAPUseSSL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Use TLS with Registry Server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPUseSSL(String lDAPUseSSL) {
        if (lDAPUseSSL == null || Comparison.isIn(lDAPUseSSL, DPEnumerations.TOGGLE)) {
            this.lDAPUseSSL = lDAPUseSSL;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLPort", elementOrder=14, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="ldap-ssl-port", refType="", isEnumeration=false, javaName="lDAPSSLPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="636", displayOrder=0, displayValue="LDAP TLS Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLDAPSSLPort() {
        return this.lDAPSSLPort;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLPort", elementOrder=14, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="ldap-ssl-port", refType="", isEnumeration=false, javaName="lDAPSSLPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="636", displayValue="LDAP TLS Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPSSLPort(int lDAPSSLPort) {
        this.lDAPSSLPort = lDAPSSLPort;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLKeyFile", elementOrder=15, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="ldap-ssl-key-file", refType="", isEnumeration=false, javaName="lDAPSSLKeyFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Registry Server TLS Key File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPSSLKeyFile() {
        return this.lDAPSSLKeyFile;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLKeyFile", elementOrder=15, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="ldap-ssl-key-file", refType="", isEnumeration=false, javaName="lDAPSSLKeyFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Registry Server TLS Key File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPSSLKeyFile(String lDAPSSLKeyFile) {
        this.lDAPSSLKeyFile = lDAPSSLKeyFile;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLKeyFilePassword", elementOrder=16, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="ldap-ssl-key-file-password", refType="", isEnumeration=false, javaName="lDAPSSLKeyFilePassword", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Registry Server TLS Key File Password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public String getLDAPSSLKeyFilePassword() {
        return this.lDAPSSLKeyFilePassword;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLKeyFilePassword", elementOrder=16, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="ldap-ssl-key-file-password", refType="", isEnumeration=false, javaName="lDAPSSLKeyFilePassword", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Registry Server TLS Key File Password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public void setLDAPSSLKeyFilePassword(String lDAPSSLKeyFilePassword) {
        this.lDAPSSLKeyFilePassword = lDAPSSLKeyFilePassword;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLKeyFilePasswordAlias", elementOrder=17, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ldap-ssl-key-file-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="lDAPSSLKeyFilePasswordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Registry Server TLS Key File Password Alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getLDAPSSLKeyFilePasswordAlias() {
        return this.lDAPSSLKeyFilePasswordAlias;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLKeyFilePasswordAlias", elementOrder=17, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ldap-ssl-key-file-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="lDAPSSLKeyFilePasswordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Registry Server TLS Key File Password Alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPSSLKeyFilePasswordAlias(ObjectReference<ConfigPasswordAlias> lDAPSSLKeyFilePasswordAlias) {
        this.lDAPSSLKeyFilePasswordAlias = lDAPSSLKeyFilePasswordAlias;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLKeyFileLabel", elementOrder=18, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-ssl-key-file-dn", refType="", isEnumeration=false, javaName="lDAPSSLKeyFileLabel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Registry Server TLS Key File Label", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPSSLKeyFileLabel() {
        return this.lDAPSSLKeyFileLabel;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLKeyFileLabel", elementOrder=18, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-ssl-key-file-dn", refType="", isEnumeration=false, javaName="lDAPSSLKeyFileLabel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Registry Server TLS Key File Label", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPSSLKeyFileLabel(String lDAPSSLKeyFileLabel) {
        this.lDAPSSLKeyFileLabel = lDAPSSLKeyFileLabel;
    }

    @XMLInfo(elementType="element", elementName="TAMUseFIPS", elementOrder=19, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-fips", refType="", isEnumeration=true, javaName="tAMUseFIPS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Run in FIPS Mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTAMUseFIPS() {
        return this.tAMUseFIPS;
    }

    @XMLInfo(elementType="element", elementName="TAMUseFIPS", elementOrder=19, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-fips", refType="", isEnumeration=true, javaName="tAMUseFIPS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Run in FIPS Mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTAMUseFIPS(String tAMUseFIPS) {
        if (tAMUseFIPS == null || Comparison.isIn(tAMUseFIPS, DPEnumerations.TOGGLE)) {
            this.tAMUseFIPS = tAMUseFIPS;
        }
    }

    @XMLInfo(elementType="element", elementName="TAMChooseNIST", elementOrder=20, dataPowerType="dmNISTComplianceMode", subType="", benign=false, isPassword=false, cliAlias="choose-nist", refType="", isEnumeration=true, javaName="tAMChooseNIST", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Select a NIST Compliance Mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTAMChooseNIST() {
        return this.tAMChooseNIST;
    }

    @XMLInfo(elementType="element", elementName="TAMChooseNIST", elementOrder=20, dataPowerType="dmNISTComplianceMode", subType="", benign=false, isPassword=false, cliAlias="choose-nist", refType="", isEnumeration=true, javaName="tAMChooseNIST", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Select a NIST Compliance Mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTAMChooseNIST(String tAMChooseNIST) {
        if (tAMChooseNIST == null || Comparison.isIn(tAMChooseNIST, DPEnumerations.NISTCOMPLIANCE_MODE)) {
            this.tAMChooseNIST = tAMChooseNIST;
        }
    }

    @XMLInfo(elementType="element", elementName="TAMUseBasicUser", elementOrder=21, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-basic-user", refType="", isEnumeration=true, javaName="tAMUseBasicUser", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable basic user mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTAMUseBasicUser() {
        return this.tAMUseBasicUser;
    }

    @XMLInfo(elementType="element", elementName="TAMUseBasicUser", elementOrder=21, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-basic-user", refType="", isEnumeration=true, javaName="tAMUseBasicUser", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable basic user mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTAMUseBasicUser(String tAMUseBasicUser) {
        if (Comparison.isIn(tAMUseBasicUser, DPEnumerations.TOGGLE)) {
            this.tAMUseBasicUser = tAMUseBasicUser;
        }
    }

    @XMLInfo(elementType="element", elementName="UserPrincipalAttribute", elementOrder=22, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="user-principal-attribute", refType="", isEnumeration=false, javaName="userPrincipalAttribute", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="uid", displayOrder=0, displayValue="User principal attribute", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserPrincipalAttribute() {
        return this.userPrincipalAttribute;
    }

    @XMLInfo(elementType="element", elementName="UserPrincipalAttribute", elementOrder=22, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="user-principal-attribute", refType="", isEnumeration=false, javaName="userPrincipalAttribute", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="uid", displayValue="User principal attribute", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserPrincipalAttribute(String userPrincipalAttribute) {
        this.userPrincipalAttribute = userPrincipalAttribute;
    }

    @XMLInfo(elementType="element", elementName="UserNoDuplicates", elementOrder=23, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="user-no-duplicates", refType="", isEnumeration=true, javaName="userNoDuplicates", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Disallow duplicate principals", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserNoDuplicates() {
        return this.userNoDuplicates;
    }

    @XMLInfo(elementType="element", elementName="UserNoDuplicates", elementOrder=23, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="user-no-duplicates", refType="", isEnumeration=true, javaName="userNoDuplicates", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Disallow duplicate principals", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserNoDuplicates(String userNoDuplicates) {
        if (userNoDuplicates == null || Comparison.isIn(userNoDuplicates, DPEnumerations.TOGGLE)) {
            this.userNoDuplicates = userNoDuplicates;
        }
    }

    public void addUserSearchSuffixes(String element) {
        if (element == null) {
            return;
        }
        if (this.userSearchSuffixes == null) {
            this.userSearchSuffixes = new ArrayList();
        }
        this.userSearchSuffixes.add(element);
    }

    public boolean removeUserSearchSuffixes(String element) {
        if (element == null || this.userSearchSuffixes == null) {
            return false;
        }
        return this.userSearchSuffixes.remove(element);
    }

    @XMLInfo(elementType="element", elementName="UserSearchSuffixes", elementOrder=24, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="user-search-suffixes", refType="", isEnumeration=false, javaName="userSearchSuffixes", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Principal search suffixes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getUserSearchSuffixes() {
        return this.userSearchSuffixes;
    }

    @XMLInfo(elementType="element", elementName="UserSearchSuffixes", elementOrder=24, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="user-search-suffixes", refType="", isEnumeration=false, javaName="userSearchSuffixes", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Principal search suffixes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSearchSuffixes(ArrayList<String> userSearchSuffixes) {
        this.userSearchSuffixes = userSearchSuffixes;
    }

    @XMLInfo(elementType="element", elementName="UserSuffixOptimiser", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="user-suffix-optimiser", refType="", isEnumeration=true, javaName="userSuffixOptimiser", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable suffix optimization", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSuffixOptimiser() {
        return this.userSuffixOptimiser;
    }

    @XMLInfo(elementType="element", elementName="UserSuffixOptimiser", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="user-suffix-optimiser", refType="", isEnumeration=true, javaName="userSuffixOptimiser", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable suffix optimization", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSuffixOptimiser(String userSuffixOptimiser) {
        if (userSuffixOptimiser == null || Comparison.isIn(userSuffixOptimiser, DPEnumerations.TOGGLE)) {
            this.userSuffixOptimiser = userSuffixOptimiser;
        }
    }

    public void addTAMFedDirs(TAMFedDir element) {
        if (element == null) {
            return;
        }
        if (this.tAMFedDirs == null) {
            this.tAMFedDirs = new ArrayList();
        }
        this.tAMFedDirs.add(element);
    }

    public boolean removeTAMFedDirs(TAMFedDir element) {
        if (element == null || this.tAMFedDirs == null) {
            return false;
        }
        return this.tAMFedDirs.remove(element);
    }

    @XMLInfo(elementType="element", elementName="TAMFedDirs", elementOrder=26, dataPowerType="dmTAMFedDir", subType="", benign=false, isPassword=false, cliAlias="federated-directory", refType="", isEnumeration=false, javaName="tAMFedDirs", javaType="TAMFedDir", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Federated directories", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<TAMFedDir> getTAMFedDirs() {
        return this.tAMFedDirs;
    }

    @XMLInfo(elementType="element", elementName="TAMFedDirs", elementOrder=26, dataPowerType="dmTAMFedDir", subType="", benign=false, isPassword=false, cliAlias="federated-directory", refType="", isEnumeration=false, javaName="tAMFedDirs", javaType="TAMFedDir", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Federated directories", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTAMFedDirs(ArrayList<TAMFedDir> tAMFedDirs) {
        this.tAMFedDirs = tAMFedDirs;
    }

    public void addTAMAZReplicas(TAMAZReplica element) {
        if (element == null) {
            return;
        }
        if (this.tAMAZReplicas == null) {
            this.tAMAZReplicas = new ArrayList();
        }
        this.tAMAZReplicas.add(element);
    }

    public boolean removeTAMAZReplicas(TAMAZReplica element) {
        if (element == null || this.tAMAZReplicas == null) {
            return false;
        }
        return this.tAMAZReplicas.remove(element);
    }

    @XMLInfo(elementType="element", elementName="TAMAZReplicas", elementOrder=27, dataPowerType="dmTAMAZReplica", subType="", benign=false, isPassword=false, cliAlias="replica", refType="", isEnumeration=false, javaName="tAMAZReplicas", javaType="TAMAZReplica", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Authorization Server Replicas", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<TAMAZReplica> getTAMAZReplicas() {
        return this.tAMAZReplicas;
    }

    @XMLInfo(elementType="element", elementName="TAMAZReplicas", elementOrder=27, dataPowerType="dmTAMAZReplica", subType="", benign=false, isPassword=false, cliAlias="replica", refType="", isEnumeration=false, javaName="tAMAZReplicas", javaType="TAMAZReplica", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Authorization Server Replicas", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTAMAZReplicas(ArrayList<TAMAZReplica> tAMAZReplicas) {
        this.tAMAZReplicas = tAMAZReplicas;
    }

    @XMLInfo(elementType="element", elementName="TAMRASTrace", elementOrder=28, dataPowerType="dmTAMRASTrace", subType="", benign=false, isPassword=false, cliAlias="tam-ras-trace", refType="", isEnumeration=false, javaName="tAMRASTrace", javaType="TAMRASTrace", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Trace Logging", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public TAMRASTrace getTAMRASTrace() {
        return this.tAMRASTrace;
    }

    @XMLInfo(elementType="element", elementName="TAMRASTrace", elementOrder=28, dataPowerType="dmTAMRASTrace", subType="", benign=false, isPassword=false, cliAlias="tam-ras-trace", refType="", isEnumeration=false, javaName="tAMRASTrace", javaType="TAMRASTrace", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Trace Logging", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTAMRASTrace(TAMRASTrace tAMRASTrace) {
        this.tAMRASTrace = tAMRASTrace;
    }

    @XMLInfo(elementType="element", elementName="AutoRetry", elementOrder=29, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="auto-retry", refType="", isEnumeration=true, javaName="autoRetry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable Automatic Restart Attempts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAutoRetry() {
        return this.autoRetry;
    }

    @XMLInfo(elementType="element", elementName="AutoRetry", elementOrder=29, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="auto-retry", refType="", isEnumeration=true, javaName="autoRetry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable Automatic Restart Attempts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAutoRetry(String autoRetry) {
        if (autoRetry == null || Comparison.isIn(autoRetry, DPEnumerations.TOGGLE)) {
            this.autoRetry = autoRetry;
        }
    }

    @XMLInfo(elementType="element", elementName="RetryInterval", elementOrder=30, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-interval", refType="", isEnumeration=false, javaName="retryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="180", displayOrder=0, displayValue="Attempt Interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getRetryInterval() {
        return this.retryInterval;
    }

    @XMLInfo(elementType="element", elementName="RetryInterval", elementOrder=30, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-interval", refType="", isEnumeration=false, javaName="retryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="180", displayValue="Attempt Interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    @XMLInfo(elementType="element", elementName="RetryAttempts", elementOrder=31, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-attempts", refType="", isEnumeration=false, javaName="retryAttempts", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="3", displayOrder=0, displayValue="Number of Attempts", units="attempts", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @XMLInfo(elementType="element", elementName="RetryAttempts", elementOrder=31, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-attempts", refType="", isEnumeration=false, javaName="retryAttempts", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="3", displayValue="Number of Attempts", units="attempts", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    @XMLInfo(elementType="element", elementName="LongRetryInterval", elementOrder=32, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="long-retry-interval", refType="", isEnumeration=false, javaName="longRetryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="900", displayOrder=0, displayValue="Long Attempt Interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLongRetryInterval() {
        return this.longRetryInterval;
    }

    @XMLInfo(elementType="element", elementName="LongRetryInterval", elementOrder=32, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="long-retry-interval", refType="", isEnumeration=false, javaName="longRetryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="900", displayValue="Long Attempt Interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLongRetryInterval(int longRetryInterval) {
        this.longRetryInterval = longRetryInterval;
    }

    @Override
    public int compareTo(ConfigTAM that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "aDUseAD", "tAMVersion", "configurationFile", "aDConfigurationFile", "sSLKeyFile", "sSLKeyStashFile", "useLocalMode", "pollInterval", "listenMode", "listenPort", "returningUserAttributes", "lDAPUseSSL", "lDAPSSLPort", "lDAPSSLKeyFile", "lDAPSSLKeyFilePassword", "lDAPSSLKeyFilePasswordAlias", "lDAPSSLKeyFileLabel", "tAMUseFIPS", "tAMChooseNIST", "tAMUseBasicUser", "userPrincipalAttribute", "userNoDuplicates", "userSearchSuffixes", "userSuffixOptimiser", "tAMFedDirs", "tAMAZReplicas", "tAMRASTrace", "autoRetry", "retryInterval", "retryAttempts", "longRetryInterval");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.aDUseAD, this.tAMVersion, this.configurationFile, this.aDConfigurationFile, this.sSLKeyFile, this.sSLKeyStashFile, this.useLocalMode, this.pollInterval, this.listenMode, this.listenPort, this.returningUserAttributes, this.lDAPUseSSL, this.lDAPSSLPort, this.lDAPSSLKeyFile, this.lDAPSSLKeyFilePassword, this.lDAPSSLKeyFilePasswordAlias, this.lDAPSSLKeyFileLabel, this.tAMUseFIPS, this.tAMChooseNIST, this.tAMUseBasicUser, this.userPrincipalAttribute, this.userNoDuplicates, this.userSearchSuffixes, this.userSuffixOptimiser, this.tAMFedDirs, this.tAMAZReplicas, this.tAMRASTrace, this.autoRetry, this.retryInterval, this.retryAttempts, this.longRetryInterval);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "aDUseAD", "tAMVersion", "configurationFile", "aDConfigurationFile", "sSLKeyFile", "sSLKeyStashFile", "useLocalMode", "pollInterval", "listenMode", "listenPort", "returningUserAttributes", "lDAPUseSSL", "lDAPSSLPort", "lDAPSSLKeyFile", "lDAPSSLKeyFilePassword", "lDAPSSLKeyFilePasswordAlias", "lDAPSSLKeyFileLabel", "tAMUseFIPS", "tAMChooseNIST", "tAMUseBasicUser", "userPrincipalAttribute", "userNoDuplicates", "userSearchSuffixes", "userSuffixOptimiser", "tAMFedDirs", "tAMAZReplicas", "tAMRASTrace", "autoRetry", "retryInterval", "retryAttempts", "longRetryInterval");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "aDUseAD", "tAMVersion", "configurationFile", "aDConfigurationFile", "sSLKeyFile", "sSLKeyStashFile", "useLocalMode", "pollInterval", "listenMode", "listenPort", "returningUserAttributes", "lDAPUseSSL", "lDAPSSLPort", "lDAPSSLKeyFile", "lDAPSSLKeyFilePassword", "lDAPSSLKeyFilePasswordAlias", "lDAPSSLKeyFileLabel", "tAMUseFIPS", "tAMChooseNIST", "tAMUseBasicUser", "userPrincipalAttribute", "userNoDuplicates", "userSearchSuffixes", "userSuffixOptimiser", "tAMFedDirs", "tAMAZReplicas", "tAMRASTrace", "autoRetry", "retryInterval", "retryAttempts", "longRetryInterval"));
    }
}

