/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigJMSServer;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.WebSphereJMSEndpoint;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigWebSphereJMSServer
extends ConfigJMSServer {
    private ArrayList<WebSphereJMSEndpoint> endpoint;
    private String targetTransportChain;
    private String messagingBus;
    private String sSLCipher;
    private String fIPS;

    public void addEndpoint(WebSphereJMSEndpoint element) {
        if (element == null) {
            return;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList();
        }
        this.endpoint.add(element);
    }

    public boolean removeEndpoint(WebSphereJMSEndpoint element) {
        if (element == null || this.endpoint == null) {
            return false;
        }
        return this.endpoint.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Endpoint", elementOrder=17, dataPowerType="dmWebSphereJMSEndpoint", subType="", benign=false, isPassword=false, cliAlias="endpoint", refType="", isEnumeration=false, javaName="endpoint", javaType="WebSphereJMSEndpoint", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Endpoints", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<WebSphereJMSEndpoint> getEndpoint() {
        return this.endpoint;
    }

    @XMLInfo(elementType="element", elementName="Endpoint", elementOrder=17, dataPowerType="dmWebSphereJMSEndpoint", subType="", benign=false, isPassword=false, cliAlias="endpoint", refType="", isEnumeration=false, javaName="endpoint", javaType="WebSphereJMSEndpoint", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Endpoints", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEndpoint(ArrayList<WebSphereJMSEndpoint> endpoint) {
        this.endpoint = endpoint;
    }

    @XMLInfo(elementType="element", elementName="TargetTransportChain", elementOrder=18, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="target-transport-chain", refType="", isEnumeration=false, javaName="targetTransportChain", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="InboundBasicMessaging", displayOrder=0, displayValue="Target transport chain", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTargetTransportChain() {
        return this.targetTransportChain;
    }

    @XMLInfo(elementType="element", elementName="TargetTransportChain", elementOrder=18, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="target-transport-chain", refType="", isEnumeration=false, javaName="targetTransportChain", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="InboundBasicMessaging", displayValue="Target transport chain", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTargetTransportChain(String targetTransportChain) {
        this.targetTransportChain = targetTransportChain;
    }

    @XMLInfo(elementType="element", elementName="MessagingBus", elementOrder=19, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="messaging-bus", refType="", isEnumeration=false, javaName="messagingBus", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Messaging bus", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMessagingBus() {
        return this.messagingBus;
    }

    @XMLInfo(elementType="element", elementName="MessagingBus", elementOrder=19, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="messaging-bus", refType="", isEnumeration=false, javaName="messagingBus", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Messaging bus", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMessagingBus(String messagingBus) {
        this.messagingBus = messagingBus;
    }

    @XMLInfo(elementType="element", elementName="SSLCipher", elementOrder=20, dataPowerType="dmWebSphereJMSSSLCipher", subType="", benign=false, isPassword=false, cliAlias="ssl-cipher", refType="", isEnumeration=true, javaName="sSLCipher", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS ciphers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLCipher() {
        return this.sSLCipher;
    }

    @XMLInfo(elementType="element", elementName="SSLCipher", elementOrder=20, dataPowerType="dmWebSphereJMSSSLCipher", subType="", benign=false, isPassword=false, cliAlias="ssl-cipher", refType="", isEnumeration=true, javaName="sSLCipher", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS ciphers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLCipher(String sSLCipher) {
        if (sSLCipher == null || Comparison.isIn(sSLCipher, DPEnumerations.WEB_SPHERE_JMSSSLCIPHER)) {
            this.sSLCipher = sSLCipher;
        }
    }

    @XMLInfo(elementType="element", elementName="FIPS", elementOrder=21, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ssl-fips", refType="", isEnumeration=true, javaName="fIPS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="FIPS compliant ciphers suite", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFIPS() {
        return this.fIPS;
    }

    @XMLInfo(elementType="element", elementName="FIPS", elementOrder=21, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ssl-fips", refType="", isEnumeration=true, javaName="fIPS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="FIPS compliant ciphers suite", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFIPS(String fIPS) {
        if (fIPS == null || Comparison.isIn(fIPS, DPEnumerations.TOGGLE)) {
            this.fIPS = fIPS;
        }
    }

    @Override
    public int compareTo(ConfigWebSphereJMSServer that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "endpoint", "targetTransportChain", "messagingBus", "sSLCipher", "fIPS");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.endpoint, this.targetTransportChain, this.messagingBus, this.sSLCipher, this.fIPS);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "endpoint", "targetTransportChain", "messagingBus", "sSLCipher", "fIPS");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("endpoint", "targetTransportChain", "messagingBus", "sSLCipher", "fIPS"));
    }
}

