/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.modify;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.modify.ModifyConfigBase;
import com.kumbasoft.core.beans.types.APIBurstLimit;
import com.kumbasoft.core.beans.types.APICountLimit;
import com.kumbasoft.core.beans.types.APIProxyPolicy;
import com.kumbasoft.core.beans.types.APIRateLimit;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.DocCachePolicy;
import com.kumbasoft.core.beans.types.OpenTelemetryResourceAttribute;
import com.kumbasoft.core.beans.types.ScheduledRule;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;

public class ModifyAPIGateway
extends ModifyConfigBase {
    private String userSummary;
    private String gatewayServiceName;
    private ArrayList<ObjectReference> frontProtocol;
    private ObjectReference uRLRefreshPolicy;
    private BigInteger cacheMemorySize;
    private long cacheSize;
    private String sHA1Caching;
    private String staticDocumentCalls;
    private ArrayList<ObjectReference> virtualServers;
    private long docCacheMaxDocs;
    private BigInteger docCacheSize;
    private long docMaxWrites;
    private ArrayList<DocCachePolicy> docCachePolicy;
    private ArrayList<ScheduledRule> scheduledRule;
    private ArrayList<ObjectReference> aPICollection;
    private String shareRateLimitCount;
    private ArrayList<APIBurstLimit> assemblyBurstLimit;
    private ArrayList<APIRateLimit> assemblyRateLimit;
    private ArrayList<APICountLimit> assemblyCountLimit;
    private ObjectReference lDAPConnPool;
    private ArrayList<APIProxyPolicy> proxyPolicies;
    private long frontTimeout;
    private long frontPersistentTimeout;
    private ObjectReference openTelemetry;
    private ArrayList<OpenTelemetryResourceAttribute> openTelemetryResourceAttribute;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="GatewayServiceName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="gatewayServiceName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getGatewayServiceName() {
        return this.gatewayServiceName;
    }

    @XMLInfo(elementType="element", elementName="GatewayServiceName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="gatewayServiceName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGatewayServiceName(String gatewayServiceName) {
        this.gatewayServiceName = gatewayServiceName;
    }

    public void addFrontProtocol(ObjectReference element) {
        if (element == null) {
            return;
        }
        if (this.frontProtocol == null) {
            this.frontProtocol = new ArrayList();
        }
        this.frontProtocol.add(element);
    }

    public boolean removeFrontProtocol(ObjectReference element) {
        if (element == null || this.frontProtocol == null) {
            return false;
        }
        return this.frontProtocol.remove(element);
    }

    @XMLInfo(elementType="element", elementName="FrontProtocol", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="frontProtocol", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference> getFrontProtocol() {
        return this.frontProtocol;
    }

    @XMLInfo(elementType="element", elementName="FrontProtocol", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="frontProtocol", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontProtocol(ArrayList<ObjectReference> frontProtocol) {
        this.frontProtocol = frontProtocol;
    }

    @XMLInfo(elementType="element", elementName="URLRefreshPolicy", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="uRLRefreshPolicy", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getURLRefreshPolicy() {
        return this.uRLRefreshPolicy;
    }

    @XMLInfo(elementType="element", elementName="URLRefreshPolicy", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="uRLRefreshPolicy", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setURLRefreshPolicy(ObjectReference uRLRefreshPolicy) {
        this.uRLRefreshPolicy = uRLRefreshPolicy;
    }

    @XMLInfo(elementType="element", elementName="CacheMemorySize", elementOrder=5, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="cacheMemorySize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public BigInteger getCacheMemorySize() {
        return this.cacheMemorySize;
    }

    @XMLInfo(elementType="element", elementName="CacheMemorySize", elementOrder=5, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="cacheMemorySize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheMemorySize(BigInteger cacheMemorySize) {
        this.cacheMemorySize = cacheMemorySize;
    }

    @XMLInfo(elementType="element", elementName="CacheSize", elementOrder=6, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="cacheSize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getCacheSize() {
        return this.cacheSize;
    }

    @XMLInfo(elementType="element", elementName="CacheSize", elementOrder=6, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="cacheSize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    @XMLInfo(elementType="element", elementName="SHA1Caching", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sHA1Caching", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSHA1Caching() {
        return this.sHA1Caching;
    }

    @XMLInfo(elementType="element", elementName="SHA1Caching", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sHA1Caching", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSHA1Caching(String sHA1Caching) {
        if (sHA1Caching == null || Comparison.isIn(sHA1Caching, DPEnumerations.TOGGLE)) {
            this.sHA1Caching = sHA1Caching;
        }
    }

    @XMLInfo(elementType="element", elementName="StaticDocumentCalls", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="staticDocumentCalls", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStaticDocumentCalls() {
        return this.staticDocumentCalls;
    }

    @XMLInfo(elementType="element", elementName="StaticDocumentCalls", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="staticDocumentCalls", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStaticDocumentCalls(String staticDocumentCalls) {
        if (staticDocumentCalls == null || Comparison.isIn(staticDocumentCalls, DPEnumerations.TOGGLE)) {
            this.staticDocumentCalls = staticDocumentCalls;
        }
    }

    public void addVirtualServers(ObjectReference element) {
        if (element == null) {
            return;
        }
        if (this.virtualServers == null) {
            this.virtualServers = new ArrayList();
        }
        this.virtualServers.add(element);
    }

    public boolean removeVirtualServers(ObjectReference element) {
        if (element == null || this.virtualServers == null) {
            return false;
        }
        return this.virtualServers.remove(element);
    }

    @XMLInfo(elementType="element", elementName="VirtualServers", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="virtualServers", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference> getVirtualServers() {
        return this.virtualServers;
    }

    @XMLInfo(elementType="element", elementName="VirtualServers", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="virtualServers", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setVirtualServers(ArrayList<ObjectReference> virtualServers) {
        this.virtualServers = virtualServers;
    }

    @XMLInfo(elementType="element", elementName="DocCacheMaxDocs", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="docCacheMaxDocs", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getDocCacheMaxDocs() {
        return this.docCacheMaxDocs;
    }

    @XMLInfo(elementType="element", elementName="DocCacheMaxDocs", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="docCacheMaxDocs", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocCacheMaxDocs(long docCacheMaxDocs) {
        this.docCacheMaxDocs = docCacheMaxDocs;
    }

    @XMLInfo(elementType="element", elementName="DocCacheSize", elementOrder=11, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="docCacheSize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public BigInteger getDocCacheSize() {
        return this.docCacheSize;
    }

    @XMLInfo(elementType="element", elementName="DocCacheSize", elementOrder=11, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="docCacheSize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocCacheSize(BigInteger docCacheSize) {
        this.docCacheSize = docCacheSize;
    }

    @XMLInfo(elementType="element", elementName="DocMaxWrites", elementOrder=12, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="docMaxWrites", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getDocMaxWrites() {
        return this.docMaxWrites;
    }

    @XMLInfo(elementType="element", elementName="DocMaxWrites", elementOrder=12, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="docMaxWrites", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocMaxWrites(long docMaxWrites) {
        this.docMaxWrites = docMaxWrites;
    }

    public void addDocCachePolicy(DocCachePolicy element) {
        if (element == null) {
            return;
        }
        if (this.docCachePolicy == null) {
            this.docCachePolicy = new ArrayList();
        }
        this.docCachePolicy.add(element);
    }

    public boolean removeDocCachePolicy(DocCachePolicy element) {
        if (element == null || this.docCachePolicy == null) {
            return false;
        }
        return this.docCachePolicy.remove(element);
    }

    @XMLInfo(elementType="element", elementName="DocCachePolicy", elementOrder=13, dataPowerType="dmDocCachePolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="docCachePolicy", javaType="DocCachePolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<DocCachePolicy> getDocCachePolicy() {
        return this.docCachePolicy;
    }

    @XMLInfo(elementType="element", elementName="DocCachePolicy", elementOrder=13, dataPowerType="dmDocCachePolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="docCachePolicy", javaType="DocCachePolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocCachePolicy(ArrayList<DocCachePolicy> docCachePolicy) {
        this.docCachePolicy = docCachePolicy;
    }

    public void addScheduledRule(ScheduledRule element) {
        if (element == null) {
            return;
        }
        if (this.scheduledRule == null) {
            this.scheduledRule = new ArrayList();
        }
        this.scheduledRule.add(element);
    }

    public boolean removeScheduledRule(ScheduledRule element) {
        if (element == null || this.scheduledRule == null) {
            return false;
        }
        return this.scheduledRule.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ScheduledRule", elementOrder=14, dataPowerType="dmScheduledRule", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="scheduledRule", javaType="ScheduledRule", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ScheduledRule> getScheduledRule() {
        return this.scheduledRule;
    }

    @XMLInfo(elementType="element", elementName="ScheduledRule", elementOrder=14, dataPowerType="dmScheduledRule", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="scheduledRule", javaType="ScheduledRule", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setScheduledRule(ArrayList<ScheduledRule> scheduledRule) {
        this.scheduledRule = scheduledRule;
    }

    public void addAPICollection(ObjectReference element) {
        if (element == null) {
            return;
        }
        if (this.aPICollection == null) {
            this.aPICollection = new ArrayList();
        }
        this.aPICollection.add(element);
    }

    public boolean removeAPICollection(ObjectReference element) {
        if (element == null || this.aPICollection == null) {
            return false;
        }
        return this.aPICollection.remove(element);
    }

    @XMLInfo(elementType="element", elementName="APICollection", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="aPICollection", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference> getAPICollection() {
        return this.aPICollection;
    }

    @XMLInfo(elementType="element", elementName="APICollection", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="aPICollection", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICollection(ArrayList<ObjectReference> aPICollection) {
        this.aPICollection = aPICollection;
    }

    @XMLInfo(elementType="element", elementName="ShareRateLimitCount", elementOrder=16, dataPowerType="dmAPIGatewayShareCount", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="shareRateLimitCount", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getShareRateLimitCount() {
        return this.shareRateLimitCount;
    }

    @XMLInfo(elementType="element", elementName="ShareRateLimitCount", elementOrder=16, dataPowerType="dmAPIGatewayShareCount", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="shareRateLimitCount", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setShareRateLimitCount(String shareRateLimitCount) {
        if (shareRateLimitCount == null || Comparison.isIn(shareRateLimitCount, DPEnumerations.APIGATEWAY_SHARE_COUNT)) {
            this.shareRateLimitCount = shareRateLimitCount;
        }
    }

    public void addAssemblyBurstLimit(APIBurstLimit element) {
        if (element == null) {
            return;
        }
        if (this.assemblyBurstLimit == null) {
            this.assemblyBurstLimit = new ArrayList();
        }
        this.assemblyBurstLimit.add(element);
    }

    public boolean removeAssemblyBurstLimit(APIBurstLimit element) {
        if (element == null || this.assemblyBurstLimit == null) {
            return false;
        }
        return this.assemblyBurstLimit.remove(element);
    }

    @XMLInfo(elementType="element", elementName="AssemblyBurstLimit", elementOrder=17, dataPowerType="dmAPIBurstLimit", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="assemblyBurstLimit", javaType="APIBurstLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIBurstLimit> getAssemblyBurstLimit() {
        return this.assemblyBurstLimit;
    }

    @XMLInfo(elementType="element", elementName="AssemblyBurstLimit", elementOrder=17, dataPowerType="dmAPIBurstLimit", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="assemblyBurstLimit", javaType="APIBurstLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyBurstLimit(ArrayList<APIBurstLimit> assemblyBurstLimit) {
        this.assemblyBurstLimit = assemblyBurstLimit;
    }

    public void addAssemblyRateLimit(APIRateLimit element) {
        if (element == null) {
            return;
        }
        if (this.assemblyRateLimit == null) {
            this.assemblyRateLimit = new ArrayList();
        }
        this.assemblyRateLimit.add(element);
    }

    public boolean removeAssemblyRateLimit(APIRateLimit element) {
        if (element == null || this.assemblyRateLimit == null) {
            return false;
        }
        return this.assemblyRateLimit.remove(element);
    }

    @XMLInfo(elementType="element", elementName="AssemblyRateLimit", elementOrder=18, dataPowerType="dmAPIRateLimit", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="assemblyRateLimit", javaType="APIRateLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIRateLimit> getAssemblyRateLimit() {
        return this.assemblyRateLimit;
    }

    @XMLInfo(elementType="element", elementName="AssemblyRateLimit", elementOrder=18, dataPowerType="dmAPIRateLimit", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="assemblyRateLimit", javaType="APIRateLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyRateLimit(ArrayList<APIRateLimit> assemblyRateLimit) {
        this.assemblyRateLimit = assemblyRateLimit;
    }

    public void addAssemblyCountLimit(APICountLimit element) {
        if (element == null) {
            return;
        }
        if (this.assemblyCountLimit == null) {
            this.assemblyCountLimit = new ArrayList();
        }
        this.assemblyCountLimit.add(element);
    }

    public boolean removeAssemblyCountLimit(APICountLimit element) {
        if (element == null || this.assemblyCountLimit == null) {
            return false;
        }
        return this.assemblyCountLimit.remove(element);
    }

    @XMLInfo(elementType="element", elementName="AssemblyCountLimit", elementOrder=19, dataPowerType="dmAPICountLimit", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="assemblyCountLimit", javaType="APICountLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APICountLimit> getAssemblyCountLimit() {
        return this.assemblyCountLimit;
    }

    @XMLInfo(elementType="element", elementName="AssemblyCountLimit", elementOrder=19, dataPowerType="dmAPICountLimit", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="assemblyCountLimit", javaType="APICountLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyCountLimit(ArrayList<APICountLimit> assemblyCountLimit) {
        this.assemblyCountLimit = assemblyCountLimit;
    }

    @XMLInfo(elementType="element", elementName="LDAPConnPool", elementOrder=20, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="lDAPConnPool", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getLDAPConnPool() {
        return this.lDAPConnPool;
    }

    @XMLInfo(elementType="element", elementName="LDAPConnPool", elementOrder=20, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="lDAPConnPool", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPConnPool(ObjectReference lDAPConnPool) {
        this.lDAPConnPool = lDAPConnPool;
    }

    public void addProxyPolicies(APIProxyPolicy element) {
        if (element == null) {
            return;
        }
        if (this.proxyPolicies == null) {
            this.proxyPolicies = new ArrayList();
        }
        this.proxyPolicies.add(element);
    }

    public boolean removeProxyPolicies(APIProxyPolicy element) {
        if (element == null || this.proxyPolicies == null) {
            return false;
        }
        return this.proxyPolicies.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ProxyPolicies", elementOrder=21, dataPowerType="dmAPIProxyPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="proxyPolicies", javaType="APIProxyPolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIProxyPolicy> getProxyPolicies() {
        return this.proxyPolicies;
    }

    @XMLInfo(elementType="element", elementName="ProxyPolicies", elementOrder=21, dataPowerType="dmAPIProxyPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="proxyPolicies", javaType="APIProxyPolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProxyPolicies(ArrayList<APIProxyPolicy> proxyPolicies) {
        this.proxyPolicies = proxyPolicies;
    }

    @XMLInfo(elementType="element", elementName="FrontTimeout", elementOrder=22, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="frontTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getFrontTimeout() {
        return this.frontTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontTimeout", elementOrder=22, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="frontTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontTimeout(long frontTimeout) {
        this.frontTimeout = frontTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontPersistentTimeout", elementOrder=23, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="frontPersistentTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getFrontPersistentTimeout() {
        return this.frontPersistentTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontPersistentTimeout", elementOrder=23, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="frontPersistentTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontPersistentTimeout(long frontPersistentTimeout) {
        this.frontPersistentTimeout = frontPersistentTimeout;
    }

    @XMLInfo(elementType="element", elementName="OpenTelemetry", elementOrder=24, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="openTelemetry", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getOpenTelemetry() {
        return this.openTelemetry;
    }

    @XMLInfo(elementType="element", elementName="OpenTelemetry", elementOrder=24, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="openTelemetry", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOpenTelemetry(ObjectReference openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public void addOpenTelemetryResourceAttribute(OpenTelemetryResourceAttribute element) {
        if (element == null) {
            return;
        }
        if (this.openTelemetryResourceAttribute == null) {
            this.openTelemetryResourceAttribute = new ArrayList();
        }
        this.openTelemetryResourceAttribute.add(element);
    }

    public boolean removeOpenTelemetryResourceAttribute(OpenTelemetryResourceAttribute element) {
        if (element == null || this.openTelemetryResourceAttribute == null) {
            return false;
        }
        return this.openTelemetryResourceAttribute.remove(element);
    }

    @XMLInfo(elementType="element", elementName="OpenTelemetryResourceAttribute", elementOrder=25, dataPowerType="dmOpenTelemetryResourceAttribute", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="openTelemetryResourceAttribute", javaType="OpenTelemetryResourceAttribute", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<OpenTelemetryResourceAttribute> getOpenTelemetryResourceAttribute() {
        return this.openTelemetryResourceAttribute;
    }

    @XMLInfo(elementType="element", elementName="OpenTelemetryResourceAttribute", elementOrder=25, dataPowerType="dmOpenTelemetryResourceAttribute", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="openTelemetryResourceAttribute", javaType="OpenTelemetryResourceAttribute", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOpenTelemetryResourceAttribute(ArrayList<OpenTelemetryResourceAttribute> openTelemetryResourceAttribute) {
        this.openTelemetryResourceAttribute = openTelemetryResourceAttribute;
    }

    @Override
    public int compareTo(ModifyAPIGateway that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "gatewayServiceName", "frontProtocol", "uRLRefreshPolicy", "cacheMemorySize", "cacheSize", "sHA1Caching", "staticDocumentCalls", "virtualServers", "docCacheMaxDocs", "docCacheSize", "docMaxWrites", "docCachePolicy", "scheduledRule", "aPICollection", "shareRateLimitCount", "assemblyBurstLimit", "assemblyRateLimit", "assemblyCountLimit", "lDAPConnPool", "proxyPolicies", "frontTimeout", "frontPersistentTimeout", "openTelemetry", "openTelemetryResourceAttribute");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.gatewayServiceName, this.frontProtocol, this.uRLRefreshPolicy, this.cacheMemorySize, this.cacheSize, this.sHA1Caching, this.staticDocumentCalls, this.virtualServers, this.docCacheMaxDocs, this.docCacheSize, this.docMaxWrites, this.docCachePolicy, this.scheduledRule, this.aPICollection, this.shareRateLimitCount, this.assemblyBurstLimit, this.assemblyRateLimit, this.assemblyCountLimit, this.lDAPConnPool, this.proxyPolicies, this.frontTimeout, this.frontPersistentTimeout, this.openTelemetry, this.openTelemetryResourceAttribute);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "gatewayServiceName", "frontProtocol", "uRLRefreshPolicy", "cacheMemorySize", "cacheSize", "sHA1Caching", "staticDocumentCalls", "virtualServers", "docCacheMaxDocs", "docCacheSize", "docMaxWrites", "docCachePolicy", "scheduledRule", "aPICollection", "shareRateLimitCount", "assemblyBurstLimit", "assemblyRateLimit", "assemblyCountLimit", "lDAPConnPool", "proxyPolicies", "frontTimeout", "frontPersistentTimeout", "openTelemetry", "openTelemetryResourceAttribute");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "gatewayServiceName", "frontProtocol", "uRLRefreshPolicy", "cacheMemorySize", "cacheSize", "sHA1Caching", "staticDocumentCalls", "virtualServers", "docCacheMaxDocs", "docCacheSize", "docMaxWrites", "docCachePolicy", "scheduledRule", "aPICollection", "shareRateLimitCount", "assemblyBurstLimit", "assemblyRateLimit", "assemblyCountLimit", "lDAPConnPool", "proxyPolicies", "frontTimeout", "frontPersistentTimeout", "openTelemetry", "openTelemetryResourceAttribute"));
    }
}

