/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.modify;

import com.jmorgan.util.Comparison;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.modify.ModifyCrypto;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.SSLClientFeatures;
import com.kumbasoft.core.beans.types.SSLHostnameValidationFlags;
import com.kumbasoft.core.beans.types.SSLProtoVersionsBitmap;
import java.util.ArrayList;
import java.util.Objects;

public class ModifySSLClientProfile
extends ModifyCrypto {
    private String userSummary;
    private SSLProtoVersionsBitmap protocols;
    private ArrayList<String> ciphers;
    private ObjectReference idcred;
    private String validateServerCert;
    private ObjectReference valcred;
    private String caching;
    private long cacheTimeout;
    private long cacheSize;
    private SSLClientFeatures sSLClientFeatures;
    private ArrayList<String> ellipticCurves;
    private String useCustomSNIHostname;
    private String customSNIHostname;
    private String validateHostname;
    private SSLHostnameValidationFlags hostnameValidationFlags;
    private String hostnameValidationFailOnError;
    private String enableTLS13Compat;
    private String disableRenegotiation;
    private ArrayList<String> sigAlgs;
    private String requireClosureNotification;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Protocols", elementOrder=2, dataPowerType="dmSSLProtoVersionsBitmap", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="protocols", javaType="SSLProtoVersionsBitmap", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public SSLProtoVersionsBitmap getProtocols() {
        return this.protocols;
    }

    @XMLInfo(elementType="element", elementName="Protocols", elementOrder=2, dataPowerType="dmSSLProtoVersionsBitmap", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="protocols", javaType="SSLProtoVersionsBitmap", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProtocols(SSLProtoVersionsBitmap protocols) {
        this.protocols = protocols;
    }

    public void addCiphers(String element) {
        if (element == null) {
            return;
        }
        if (this.ciphers == null) {
            this.ciphers = new ArrayList();
        }
        this.ciphers.add(element);
    }

    public boolean removeCiphers(String element) {
        if (element == null || this.ciphers == null) {
            return false;
        }
        return this.ciphers.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Ciphers", elementOrder=3, dataPowerType="dmSSLCipherSuite", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="ciphers", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getCiphers() {
        return this.ciphers;
    }

    @XMLInfo(elementType="element", elementName="Ciphers", elementOrder=3, dataPowerType="dmSSLCipherSuite", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="ciphers", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCiphers(ArrayList<String> ciphers) {
        if (CollectionUtility.isEmpty(ciphers)) {
            this.ciphers = null;
            return;
        }
        this.ciphers = ciphers;
    }

    @XMLInfo(elementType="element", elementName="Idcred", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="idcred", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getIdcred() {
        return this.idcred;
    }

    @XMLInfo(elementType="element", elementName="Idcred", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="idcred", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIdcred(ObjectReference idcred) {
        this.idcred = idcred;
    }

    @XMLInfo(elementType="element", elementName="ValidateServerCert", elementOrder=5, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="validateServerCert", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getValidateServerCert() {
        return this.validateServerCert;
    }

    @XMLInfo(elementType="element", elementName="ValidateServerCert", elementOrder=5, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="validateServerCert", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setValidateServerCert(String validateServerCert) {
        if (validateServerCert == null || Comparison.isIn(validateServerCert, DPEnumerations.TOGGLE)) {
            this.validateServerCert = validateServerCert;
        }
    }

    @XMLInfo(elementType="element", elementName="Valcred", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="valcred", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getValcred() {
        return this.valcred;
    }

    @XMLInfo(elementType="element", elementName="Valcred", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="valcred", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setValcred(ObjectReference valcred) {
        this.valcred = valcred;
    }

    @XMLInfo(elementType="element", elementName="Caching", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="caching", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCaching() {
        return this.caching;
    }

    @XMLInfo(elementType="element", elementName="Caching", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="caching", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCaching(String caching) {
        if (caching == null || Comparison.isIn(caching, DPEnumerations.TOGGLE)) {
            this.caching = caching;
        }
    }

    @XMLInfo(elementType="element", elementName="CacheTimeout", elementOrder=8, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="cacheTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    @XMLInfo(elementType="element", elementName="CacheTimeout", elementOrder=8, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="cacheTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    @XMLInfo(elementType="element", elementName="CacheSize", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="cacheSize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getCacheSize() {
        return this.cacheSize;
    }

    @XMLInfo(elementType="element", elementName="CacheSize", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="cacheSize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    @XMLInfo(elementType="element", elementName="SSLClientFeatures", elementOrder=10, dataPowerType="dmSSLClientFeatures", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSLClientFeatures", javaType="SSLClientFeatures", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public SSLClientFeatures getSSLClientFeatures() {
        return this.sSLClientFeatures;
    }

    @XMLInfo(elementType="element", elementName="SSLClientFeatures", elementOrder=10, dataPowerType="dmSSLClientFeatures", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSLClientFeatures", javaType="SSLClientFeatures", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClientFeatures(SSLClientFeatures sSLClientFeatures) {
        this.sSLClientFeatures = sSLClientFeatures;
    }

    public void addEllipticCurves(String element) {
        if (element == null) {
            return;
        }
        if (this.ellipticCurves == null) {
            this.ellipticCurves = new ArrayList();
        }
        this.ellipticCurves.add(element);
    }

    public boolean removeEllipticCurves(String element) {
        if (element == null || this.ellipticCurves == null) {
            return false;
        }
        return this.ellipticCurves.remove(element);
    }

    @XMLInfo(elementType="element", elementName="EllipticCurves", elementOrder=11, dataPowerType="dmTLSEllipticCurves", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="ellipticCurves", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getEllipticCurves() {
        return this.ellipticCurves;
    }

    @XMLInfo(elementType="element", elementName="EllipticCurves", elementOrder=11, dataPowerType="dmTLSEllipticCurves", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="ellipticCurves", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEllipticCurves(ArrayList<String> ellipticCurves) {
        if (CollectionUtility.isEmpty(ellipticCurves)) {
            this.ellipticCurves = null;
            return;
        }
        this.ellipticCurves = ellipticCurves;
    }

    @XMLInfo(elementType="element", elementName="UseCustomSNIHostname", elementOrder=12, dataPowerType="dmUseCustomSNIHostname", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="useCustomSNIHostname", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUseCustomSNIHostname() {
        return this.useCustomSNIHostname;
    }

    @XMLInfo(elementType="element", elementName="UseCustomSNIHostname", elementOrder=12, dataPowerType="dmUseCustomSNIHostname", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="useCustomSNIHostname", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUseCustomSNIHostname(String useCustomSNIHostname) {
        if (useCustomSNIHostname == null || Comparison.isIn(useCustomSNIHostname, DPEnumerations.USE_CUSTOM_SNIHOSTNAME)) {
            this.useCustomSNIHostname = useCustomSNIHostname;
        }
    }

    @XMLInfo(elementType="element", elementName="CustomSNIHostname", elementOrder=13, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="customSNIHostname", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCustomSNIHostname() {
        return this.customSNIHostname;
    }

    @XMLInfo(elementType="element", elementName="CustomSNIHostname", elementOrder=13, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="customSNIHostname", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCustomSNIHostname(String customSNIHostname) {
        this.customSNIHostname = customSNIHostname;
    }

    @XMLInfo(elementType="element", elementName="ValidateHostname", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="validateHostname", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getValidateHostname() {
        return this.validateHostname;
    }

    @XMLInfo(elementType="element", elementName="ValidateHostname", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="validateHostname", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setValidateHostname(String validateHostname) {
        if (validateHostname == null || Comparison.isIn(validateHostname, DPEnumerations.TOGGLE)) {
            this.validateHostname = validateHostname;
        }
    }

    @XMLInfo(elementType="element", elementName="HostnameValidationFlags", elementOrder=15, dataPowerType="dmSSLHostnameValidationFlags", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="hostnameValidationFlags", javaType="SSLHostnameValidationFlags", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public SSLHostnameValidationFlags getHostnameValidationFlags() {
        return this.hostnameValidationFlags;
    }

    @XMLInfo(elementType="element", elementName="HostnameValidationFlags", elementOrder=15, dataPowerType="dmSSLHostnameValidationFlags", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="hostnameValidationFlags", javaType="SSLHostnameValidationFlags", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHostnameValidationFlags(SSLHostnameValidationFlags hostnameValidationFlags) {
        this.hostnameValidationFlags = hostnameValidationFlags;
    }

    @XMLInfo(elementType="element", elementName="HostnameValidationFailOnError", elementOrder=16, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="hostnameValidationFailOnError", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHostnameValidationFailOnError() {
        return this.hostnameValidationFailOnError;
    }

    @XMLInfo(elementType="element", elementName="HostnameValidationFailOnError", elementOrder=16, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="hostnameValidationFailOnError", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHostnameValidationFailOnError(String hostnameValidationFailOnError) {
        if (hostnameValidationFailOnError == null || Comparison.isIn(hostnameValidationFailOnError, DPEnumerations.TOGGLE)) {
            this.hostnameValidationFailOnError = hostnameValidationFailOnError;
        }
    }

    @XMLInfo(elementType="element", elementName="EnableTLS13Compat", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="enableTLS13Compat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableTLS13Compat() {
        return this.enableTLS13Compat;
    }

    @XMLInfo(elementType="element", elementName="EnableTLS13Compat", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="enableTLS13Compat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableTLS13Compat(String enableTLS13Compat) {
        if (enableTLS13Compat == null || Comparison.isIn(enableTLS13Compat, DPEnumerations.TOGGLE)) {
            this.enableTLS13Compat = enableTLS13Compat;
        }
    }

    @XMLInfo(elementType="element", elementName="DisableRenegotiation", elementOrder=18, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="disableRenegotiation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDisableRenegotiation() {
        return this.disableRenegotiation;
    }

    @XMLInfo(elementType="element", elementName="DisableRenegotiation", elementOrder=18, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="disableRenegotiation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDisableRenegotiation(String disableRenegotiation) {
        if (disableRenegotiation == null || Comparison.isIn(disableRenegotiation, DPEnumerations.TOGGLE)) {
            this.disableRenegotiation = disableRenegotiation;
        }
    }

    public void addSigAlgs(String element) {
        if (element == null) {
            return;
        }
        if (this.sigAlgs == null) {
            this.sigAlgs = new ArrayList();
        }
        this.sigAlgs.add(element);
    }

    public boolean removeSigAlgs(String element) {
        if (element == null || this.sigAlgs == null) {
            return false;
        }
        return this.sigAlgs.remove(element);
    }

    @XMLInfo(elementType="element", elementName="SigAlgs", elementOrder=19, dataPowerType="dmTLSSignatureAlgorithms", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sigAlgs", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getSigAlgs() {
        return this.sigAlgs;
    }

    @XMLInfo(elementType="element", elementName="SigAlgs", elementOrder=19, dataPowerType="dmTLSSignatureAlgorithms", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sigAlgs", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSigAlgs(ArrayList<String> sigAlgs) {
        if (CollectionUtility.isEmpty(sigAlgs)) {
            this.sigAlgs = null;
            return;
        }
        this.sigAlgs = sigAlgs;
    }

    @XMLInfo(elementType="element", elementName="RequireClosureNotification", elementOrder=20, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="requireClosureNotification", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRequireClosureNotification() {
        return this.requireClosureNotification;
    }

    @XMLInfo(elementType="element", elementName="RequireClosureNotification", elementOrder=20, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="requireClosureNotification", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRequireClosureNotification(String requireClosureNotification) {
        if (requireClosureNotification == null || Comparison.isIn(requireClosureNotification, DPEnumerations.TOGGLE)) {
            this.requireClosureNotification = requireClosureNotification;
        }
    }

    @Override
    public int compareTo(ModifySSLClientProfile that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "protocols", "ciphers", "idcred", "validateServerCert", "valcred", "caching", "cacheTimeout", "cacheSize", "sSLClientFeatures", "ellipticCurves", "useCustomSNIHostname", "customSNIHostname", "validateHostname", "hostnameValidationFlags", "hostnameValidationFailOnError", "enableTLS13Compat", "disableRenegotiation", "sigAlgs", "requireClosureNotification");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.protocols, this.ciphers, this.idcred, this.validateServerCert, this.valcred, this.caching, this.cacheTimeout, this.cacheSize, this.sSLClientFeatures, this.ellipticCurves, this.useCustomSNIHostname, this.customSNIHostname, this.validateHostname, this.hostnameValidationFlags, this.hostnameValidationFailOnError, this.enableTLS13Compat, this.disableRenegotiation, this.sigAlgs, this.requireClosureNotification);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "protocols", "ciphers", "idcred", "validateServerCert", "valcred", "caching", "cacheTimeout", "cacheSize", "sSLClientFeatures", "ellipticCurves", "useCustomSNIHostname", "customSNIHostname", "validateHostname", "hostnameValidationFlags", "hostnameValidationFailOnError", "enableTLS13Compat", "disableRenegotiation", "sigAlgs", "requireClosureNotification");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "protocols", "ciphers", "idcred", "validateServerCert", "valcred", "caching", "cacheTimeout", "cacheSize", "sSLClientFeatures", "ellipticCurves", "useCustomSNIHostname", "customSNIHostname", "validateHostname", "hostnameValidationFlags", "hostnameValidationFailOnError", "enableTLS13Compat", "disableRenegotiation", "sigAlgs", "requireClosureNotification"));
    }
}

