/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.status;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.DataPowerStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class StatusIPMISelEvents
extends DataPowerStatus {
    private long index;
    private String timestamp;
    private String recordType;
    private String sensorType;
    private String sensorNumber;
    private String sensorName;
    private String eventReadingTypeCode;
    private String eventData2;
    private String eventDirection;
    private String extra;

    @XMLInfo(elementType="element", elementName="Index", elementOrder=0, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="index", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Index", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getIndex() {
        return this.index;
    }

    @XMLInfo(elementType="element", elementName="Index", elementOrder=0, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="index", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Index", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIndex(long index) {
        this.index = index;
    }

    @XMLInfo(elementType="element", elementName="Timestamp", elementOrder=1, dataPowerType="dmDateTime", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="timestamp", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Timestamp", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTimestamp() {
        return this.timestamp;
    }

    @XMLInfo(elementType="element", elementName="Timestamp", elementOrder=1, dataPowerType="dmDateTime", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="timestamp", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Timestamp", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @XMLInfo(elementType="element", elementName="RecordType", elementOrder=2, dataPowerType="xsd:string", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="recordType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=255L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Record type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRecordType() {
        return this.recordType;
    }

    @XMLInfo(elementType="element", elementName="RecordType", elementOrder=2, dataPowerType="xsd:string", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="recordType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=255L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Record type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRecordType(String recordType) {
        if (recordType != null && recordType.matches("|0x[0-9a-fA-F]{4}")) {
            this.recordType = recordType;
        }
    }

    @XMLInfo(elementType="element", elementName="SensorType", elementOrder=3, dataPowerType="dmIPMISensorTypeCode", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sensorType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Sensor type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSensorType() {
        return this.sensorType;
    }

    @XMLInfo(elementType="element", elementName="SensorType", elementOrder=3, dataPowerType="dmIPMISensorTypeCode", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sensorType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Sensor type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSensorType(String sensorType) {
        if (sensorType == null || Comparison.isIn(sensorType, DPEnumerations.IPMISENSOR_TYPE_CODE)) {
            this.sensorType = sensorType;
        }
    }

    @XMLInfo(elementType="element", elementName="SensorNumber", elementOrder=4, dataPowerType="xsd:string", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sensorNumber", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=255L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Sensor number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSensorNumber() {
        return this.sensorNumber;
    }

    @XMLInfo(elementType="element", elementName="SensorNumber", elementOrder=4, dataPowerType="xsd:string", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sensorNumber", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=255L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Sensor number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSensorNumber(String sensorNumber) {
        if (sensorNumber != null && sensorNumber.matches("|0x[0-9a-fA-F]{4}")) {
            this.sensorNumber = sensorNumber;
        }
    }

    @XMLInfo(elementType="element", elementName="SensorName", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sensorName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Sensor name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSensorName() {
        return this.sensorName;
    }

    @XMLInfo(elementType="element", elementName="SensorName", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sensorName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Sensor name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSensorName(String sensorName) {
        this.sensorName = sensorName;
    }

    @XMLInfo(elementType="element", elementName="EventReadingTypeCode", elementOrder=6, dataPowerType="dmIPMISensorEventReadingTypeCode", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="eventReadingTypeCode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Event type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEventReadingTypeCode() {
        return this.eventReadingTypeCode;
    }

    @XMLInfo(elementType="element", elementName="EventReadingTypeCode", elementOrder=6, dataPowerType="dmIPMISensorEventReadingTypeCode", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="eventReadingTypeCode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Event type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEventReadingTypeCode(String eventReadingTypeCode) {
        if (eventReadingTypeCode == null || Comparison.isIn(eventReadingTypeCode, DPEnumerations.IPMISENSOR_EVENT_READING_TYPE_CODE)) {
            this.eventReadingTypeCode = eventReadingTypeCode;
        }
    }

    @XMLInfo(elementType="element", elementName="EventData2", elementOrder=7, dataPowerType="dmIPMISensorEventData2", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="eventData2", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Event data 2", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEventData2() {
        return this.eventData2;
    }

    @XMLInfo(elementType="element", elementName="EventData2", elementOrder=7, dataPowerType="dmIPMISensorEventData2", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="eventData2", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Event data 2", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEventData2(String eventData2) {
        if (eventData2 == null || Comparison.isIn(eventData2, DPEnumerations.IPMISENSOR_EVENT_DATA2)) {
            this.eventData2 = eventData2;
        }
    }

    @XMLInfo(elementType="element", elementName="EventDirection", elementOrder=8, dataPowerType="dmIPMISensorEventDir", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="eventDirection", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Event direction", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEventDirection() {
        return this.eventDirection;
    }

    @XMLInfo(elementType="element", elementName="EventDirection", elementOrder=8, dataPowerType="dmIPMISensorEventDir", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="eventDirection", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Event direction", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEventDirection(String eventDirection) {
        if (eventDirection == null || Comparison.isIn(eventDirection, DPEnumerations.IPMISENSOR_EVENT_DIR)) {
            this.eventDirection = eventDirection;
        }
    }

    @XMLInfo(elementType="element", elementName="Extra", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="extra", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Extra", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getExtra() {
        return this.extra;
    }

    @XMLInfo(elementType="element", elementName="Extra", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="extra", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Extra", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public int compareTo(StatusIPMISelEvents that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "index", "timestamp", "recordType", "sensorType", "sensorNumber", "sensorName", "eventReadingTypeCode", "eventData2", "eventDirection", "extra");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.index, this.timestamp, this.recordType, this.sensorType, this.sensorNumber, this.sensorName, this.eventReadingTypeCode, this.eventData2, this.eventDirection, this.extra);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "index", "timestamp", "recordType", "sensorType", "sensorNumber", "sensorName", "eventReadingTypeCode", "eventData2", "eventDirection", "extra");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("index", "timestamp", "recordType", "sensorType", "sensorNumber", "sensorName", "eventReadingTypeCode", "eventData2", "eventDirection", "extra"));
    }
}

