/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.types;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCryptoValCred;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class CRLFetchConfig
extends JMBean
implements Comparable<CRLFetchConfig> {
    private String name;
    private String fetchType;
    private ObjectReference<ConfigCryptoValCred> issuerValcred;
    private long refreshInterval;
    private String cryptographicProfile;
    private String uRL;
    private String remoteAddress;
    private int remotePort;
    private String dN;
    private String bindDN;
    private String bindPass;
    private ObjectReference<ConfigPasswordAlias> bindPassAlias;
    private String lDAPVersion;
    private long lDAPReadTimeout;
    private String sSLClientConfigType;
    private ObjectReference<ConfigSSLClientProfile> sSLClient;

    @XMLInfo(elementType="element", elementName="Name", elementOrder=0, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="name", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Policy name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getName() {
        return this.name;
    }

    @XMLInfo(elementType="element", elementName="Name", elementOrder=0, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="name", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Policy name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setName(String name) {
        this.name = name;
    }

    @XMLInfo(elementType="element", elementName="FetchType", elementOrder=1, dataPowerType="dmCRLFetchType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="fetchType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=1, displayValue="Protocol", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFetchType() {
        return this.fetchType;
    }

    @XMLInfo(elementType="element", elementName="FetchType", elementOrder=1, dataPowerType="dmCRLFetchType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="fetchType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=1, defaultValue="", displayValue="Protocol", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFetchType(String fetchType) {
        if (Comparison.isIn(fetchType, DPEnumerations.CRLFETCH_TYPE)) {
            this.fetchType = fetchType;
        }
    }

    @XMLInfo(elementType="element", elementName="IssuerValcred", elementOrder=2, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="issuer", refType="CryptoValCred", isEnumeration=false, javaName="issuerValcred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=2, displayValue="Issuer validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoValCred> getIssuerValcred() {
        return this.issuerValcred;
    }

    @XMLInfo(elementType="element", elementName="IssuerValcred", elementOrder=2, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="issuer", refType="CryptoValCred", isEnumeration=false, javaName="issuerValcred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=2, defaultValue="", displayValue="Issuer validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIssuerValcred(ObjectReference<ConfigCryptoValCred> issuerValcred) {
        this.issuerValcred = issuerValcred;
    }

    @XMLInfo(elementType="element", elementName="RefreshInterval", elementOrder=3, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="refresh", refType="", isEnumeration=false, javaName="refreshInterval", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=1440L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="240", displayOrder=3, displayValue="Refresh interval", units="minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @XMLInfo(elementType="element", elementName="RefreshInterval", elementOrder=3, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="refresh", refType="", isEnumeration=false, javaName="refreshInterval", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=1440L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=3, defaultValue="240", displayValue="Refresh interval", units="minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    @XMLInfo(elementType="element", elementName="CryptographicProfile", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ssl-profile", refType="", isEnumeration=false, javaName="cryptographicProfile", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=6, displayValue="Cryptographic profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCryptographicProfile() {
        return this.cryptographicProfile;
    }

    @XMLInfo(elementType="element", elementName="CryptographicProfile", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ssl-profile", refType="", isEnumeration=false, javaName="cryptographicProfile", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=6, defaultValue="", displayValue="Cryptographic profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCryptographicProfile(String cryptographicProfile) {
        this.cryptographicProfile = cryptographicProfile;
    }

    @XMLInfo(elementType="element", elementName="URL", elementOrder=5, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="fetch-url", refType="", isEnumeration=false, javaName="uRL", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^https?://\\[?[-_a-z0-9A-Z.:]+\\]?(:[0-9]+)?/[ -~]*$", allowedValues={}, defaultValue="", displayOrder=8, displayValue="Fetch URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getURL() {
        return this.uRL;
    }

    @XMLInfo(elementType="element", elementName="URL", elementOrder=5, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="fetch-url", refType="", isEnumeration=false, javaName="uRL", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^https?://\\[?[-_a-z0-9A-Z.:]+\\]?(:[0-9]+)?/[ -~]*$", allowedValues={}, displayOrder=8, defaultValue="", displayValue="Fetch URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setURL(String uRL) {
        if (uRL != null && uRL.matches("^https?://\\[?[-_a-z0-9A-Z.:]+\\]?(:[0-9]+)?/[ -~]*$")) {
            this.uRL = uRL;
        }
    }

    @XMLInfo(elementType="element", elementName="RemoteAddress", elementOrder=6, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="remote-address", refType="", isEnumeration=false, javaName="remoteAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=9, displayValue="LDAP server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @XMLInfo(elementType="element", elementName="RemoteAddress", elementOrder=6, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="remote-address", refType="", isEnumeration=false, javaName="remoteAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=9, defaultValue="", displayValue="LDAP server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @XMLInfo(elementType="element", elementName="RemotePort", elementOrder=7, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="remotePort", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="389", displayOrder=10, displayValue="LDAP port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getRemotePort() {
        return this.remotePort;
    }

    @XMLInfo(elementType="element", elementName="RemotePort", elementOrder=7, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="remotePort", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=10, defaultValue="389", displayValue="LDAP port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    @XMLInfo(elementType="element", elementName="DN", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="read-dn", refType="", isEnumeration=false, javaName="dN", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=11, displayValue="LDAP read DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDN() {
        return this.dN;
    }

    @XMLInfo(elementType="element", elementName="DN", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="read-dn", refType="", isEnumeration=false, javaName="dN", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=11, defaultValue="", displayValue="LDAP read DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDN(String dN) {
        this.dN = dN;
    }

    @XMLInfo(elementType="element", elementName="BindDN", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="bind-dn", refType="", isEnumeration=false, javaName="bindDN", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=12, displayValue="LDAP bind DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getBindDN() {
        return this.bindDN;
    }

    @XMLInfo(elementType="element", elementName="BindDN", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="bind-dn", refType="", isEnumeration=false, javaName="bindDN", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=12, defaultValue="", displayValue="LDAP bind DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    @XMLInfo(elementType="element", elementName="BindPass", elementOrder=10, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="bind-pass", refType="", isEnumeration=false, javaName="bindPass", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=13, displayValue="LDAP bind password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public String getBindPass() {
        return this.bindPass;
    }

    @XMLInfo(elementType="element", elementName="BindPass", elementOrder=10, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="bind-pass", refType="", isEnumeration=false, javaName="bindPass", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=13, defaultValue="", displayValue="LDAP bind password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public void setBindPass(String bindPass) {
        this.bindPass = bindPass;
    }

    @XMLInfo(elementType="element", elementName="BindPassAlias", elementOrder=11, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="bind-pass-alias", refType="PasswordAlias", isEnumeration=false, javaName="bindPassAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=14, displayValue="LDAP bind password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getBindPassAlias() {
        return this.bindPassAlias;
    }

    @XMLInfo(elementType="element", elementName="BindPassAlias", elementOrder=11, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="bind-pass-alias", refType="PasswordAlias", isEnumeration=false, javaName="bindPassAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=14, defaultValue="", displayValue="LDAP bind password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBindPassAlias(ObjectReference<ConfigPasswordAlias> bindPassAlias) {
        this.bindPassAlias = bindPassAlias;
    }

    @XMLInfo(elementType="element", elementName="LDAPVersion", elementOrder=12, dataPowerType="dmLDAPVersion", subType="", benign=false, isPassword=false, cliAlias="ldap-version", refType="", isEnumeration=true, javaName="lDAPVersion", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="v2", displayOrder=15, displayValue="LDAP version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPVersion() {
        return this.lDAPVersion;
    }

    @XMLInfo(elementType="element", elementName="LDAPVersion", elementOrder=12, dataPowerType="dmLDAPVersion", subType="", benign=false, isPassword=false, cliAlias="ldap-version", refType="", isEnumeration=true, javaName="lDAPVersion", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=15, defaultValue="v2", displayValue="LDAP version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPVersion(String lDAPVersion) {
        if (Comparison.isIn(lDAPVersion, DPEnumerations.LDAPVERSION)) {
            this.lDAPVersion = lDAPVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPReadTimeout", elementOrder=13, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ldap-readtimeout", refType="", isEnumeration=false, javaName="lDAPReadTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="60", displayOrder=16, displayValue="LDAP Read Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getLDAPReadTimeout() {
        return this.lDAPReadTimeout;
    }

    @XMLInfo(elementType="element", elementName="LDAPReadTimeout", elementOrder=13, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ldap-readtimeout", refType="", isEnumeration=false, javaName="lDAPReadTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=16, defaultValue="60", displayValue="LDAP Read Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPReadTimeout(long lDAPReadTimeout) {
        this.lDAPReadTimeout = lDAPReadTimeout;
    }

    @XMLInfo(elementType="element", elementName="SSLClientConfigType", elementOrder=14, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-client-type", refType="", isEnumeration=true, javaName="sSLClientConfigType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="proxy", displayOrder=5, displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLClientConfigType() {
        return this.sSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="SSLClientConfigType", elementOrder=14, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-client-type", refType="", isEnumeration=true, javaName="sSLClientConfigType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=5, defaultValue="proxy", displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClientConfigType(String sSLClientConfigType) {
        if (Comparison.isIn(sSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.sSLClientConfigType = sSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=7, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=7, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(ObjectReference<ConfigSSLClientProfile> sSLClient) {
        this.sSLClient = sSLClient;
    }

    @Override
    public int compareTo(CRLFetchConfig that) {
        return this.compareTo(that, "name", "fetchType", "issuerValcred", "refreshInterval", "cryptographicProfile", "uRL", "remoteAddress", "remotePort", "dN", "bindDN", "bindPass", "bindPassAlias", "lDAPVersion", "lDAPReadTimeout", "sSLClientConfigType", "sSLClient");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.fetchType, this.issuerValcred, this.refreshInterval, this.cryptographicProfile, this.uRL, this.remoteAddress, this.remotePort, this.dN, this.bindDN, this.bindPass, this.bindPassAlias, this.lDAPVersion, this.lDAPReadTimeout, this.sSLClientConfigType, this.sSLClient);
    }

    public boolean equals(Object that) {
        return this.equals(that, "name", "fetchType", "issuerValcred", "refreshInterval", "cryptographicProfile", "uRL", "remoteAddress", "remotePort", "dN", "bindDN", "bindPass", "bindPassAlias", "lDAPVersion", "lDAPReadTimeout", "sSLClientConfigType", "sSLClient");
    }

    @Override
    public String toString() {
        return this.toString("name", "fetchType", "issuerValcred", "refreshInterval", "cryptographicProfile", "uRL", "remoteAddress", "remotePort", "dN", "bindDN", "bindPass", "bindPassAlias", "lDAPVersion", "lDAPReadTimeout", "sSLClientConfigType", "sSLClient");
    }
}

