/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.InvocationEvent;
import com.jmorgan.lang.InvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.config.ConfigIPInterface;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ModifyTool;
import java.util.ArrayList;

public abstract class AbstractIPManager
extends AbstractTool
implements InvocationListener {
    protected Appliance appliance;
    private Domain domain;
    protected ConfigIPInterface ipInterface;
    protected ArrayList<String> ipsToManage;
    private AsynchMethodInvoker<Void> processThread;

    public AbstractIPManager(Appliance appliance, ConfigIPInterface ipInterface, ArrayList<String> ipsToManage) {
        this.setAppliance(appliance);
        this.setIpInterface(ipInterface);
        this.setIpsToManage(ipsToManage);
        this.domain = this.appliance.getDomain("default");
        this.processThread = new AsynchMethodInvoker((Object)this, "configureInterface", 250);
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public void setAppliance(Appliance appliance) {
        this.appliance = appliance;
    }

    public ConfigIPInterface getIpInterface() {
        return this.ipInterface;
    }

    public void setIpInterface(ConfigIPInterface ipInterface) {
        this.ipInterface = ipInterface;
    }

    public ArrayList<String> getIpsToManage() {
        return this.ipsToManage;
    }

    public void setIpsToManage(ArrayList<String> ipsToManage) {
        this.ipsToManage = ipsToManage;
    }

    public AsynchMethodInvoker<Void> getProcessThread() {
        return this.processThread;
    }

    protected abstract void configureInterface();

    protected void addSubscribers(ModifyTool modifyTool) {
        if (CollectionUtility.isEmpty(this.managementCommandSubscribers)) {
            return;
        }
        for (ManagementCommandSubscriber subscriber : this.managementCommandSubscribers) {
            modifyTool.addManagementCommandSubscriber(subscriber);
        }
    }

    protected void modifyInterface() {
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        ModifyTool modifyTool = new ModifyTool(this.appliance, this.domain, this.ipInterface);
        modifyTool.getProcessThread().addInvocationListener(stil);
        modifyTool.setCommandDescription(this.getCommandDescription());
        modifyTool.addInvocationListener(this);
        this.addSubscribers(modifyTool);
        stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
    }

    protected abstract String getCommandDescription();

    @Override
    public boolean methodInvocationNotice(InvocationEvent invocationEvent) {
        return true;
    }

    @Override
    public void methodInvoked(InvocationEvent invocationEvent) {
    }

    @Override
    public void methodInvocationCancelled(InvocationEvent invocationEvent) {
    }
}

