/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractXMLManagementTool;
import java.util.ArrayList;

public class ActionTool
extends AbstractXMLManagementTool<JMBean> {
    public ActionTool(Appliance appliance, JMBean xmlManagementObject) {
        this(appliance, xmlManagementObject, false);
    }

    public ActionTool(Appliance appliance, JMBean xmlManagementObject, boolean runSynchronously) {
        this(appliance, appliance.getDomain("default"), xmlManagementObject, runSynchronously);
    }

    public ActionTool(Appliance appliance, Domain domain, JMBean xmlManagementObject) {
        super(appliance, domain, xmlManagementObject);
    }

    public ActionTool(Appliance appliance, Domain domain, JMBean xmlManagementObject, boolean runSynchronously) {
        super(appliance, domain, xmlManagementObject, runSynchronously);
    }

    public ActionTool(StatusObjectStatus objectStatus, JMBean xmlManagementObject) {
        super(objectStatus.getAppliance(), objectStatus.getSourceDomain(), xmlManagementObject);
    }

    public ActionTool(StatusObjectStatus objectStatus, JMBean xmlManagementObject, boolean runSynchronously) {
        super(objectStatus.getAppliance(), objectStatus.getSourceDomain(), xmlManagementObject, runSynchronously);
    }

    @Override
    protected String getRequestMessage() {
        logger.finer(() -> LMG.log("(): Initiating ActionTool for %s", () -> this.xmlManagementObjectType));
        String requestXML = this.prepareXMLTemplate("ActionTemplate.xml");
        requestXML = requestXML.replace("${actionName}", this.xmlManagementObjectType);
        ArrayList<String> actionProperties = BeanService.getPropertyNames(this.xmlManagementObjects.get(0));
        if (actionProperties.size() == 0) {
            logger.finer(() -> LMG.log("(): %s has no properties", () -> this.xmlManagementObjectType));
            String beginActionElement = String.format("<%s>", this.xmlManagementObjectType);
            String newActionElement = String.format("<%s/>", this.xmlManagementObjectType);
            requestXML = requestXML.replace(beginActionElement, newActionElement);
            String endActionElement = String.format("</%s>", this.xmlManagementObjectType);
            requestXML = requestXML.replace(endActionElement, "");
            this.requestXML = requestXML = requestXML.replace("${actionBody}", "");
            return requestXML;
        }
        requestXML = this.buildXMLRequestFromProperties(requestXML, "${actionBody}", (JMBean)this.xmlManagementObjects.get(0));
        String finalRequest = requestXML = this.cleanupRequestXML(requestXML);
        return requestXML;
    }
}

