/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CommandSubscriptionBean;
import com.kumbasoft.core.beans.CopyMoveType;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ExportOptions;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.AbstractConfigurationActionTool;
import com.kumbasoft.core.tools.DeleteObjectConfiguration;
import com.kumbasoft.core.tools.ExportConfiguration;
import com.kumbasoft.core.tools.ImportConfiguration;

public class ConfigurationCopyMove
extends AbstractConfigurationActionTool {
    private CopyMoveType actionType;
    private StatusObjectStatus target;
    private boolean includeReferences;
    private boolean includeFiles;
    private long sessionStartTime;
    private boolean complete;

    public ConfigurationCopyMove(CopyMoveType actionType, StatusObjectStatus source, StatusObjectStatus target, boolean includeReferences, boolean includeFiles, long sessionStartTime) {
        super(source);
        this.actionType = actionType;
        this.target = target;
        this.includeReferences = includeReferences;
        this.includeFiles = includeFiles;
        this.sessionStartTime = sessionStartTime;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    @Reflected
    public void performProcess() {
        logger.finer("(): Starting)");
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFiles(this.includeFiles);
        exportOptions.setExportFormat(DPEnumerations.EXPORT_FORMAT[0]);
        exportOptions.setExportObjects(this.includeReferences);
        exportOptions.setSessionTime(this.sessionStartTime);
        CommandSubscriptionBean exportSubscriber = new CommandSubscriptionBean();
        logger.fine(() -> LMG.log("(): Exporting %s %s from the %s domain of %s", () -> this.source.getDataPowerClass(), () -> this.source.getName(), () -> this.source.getSourceDomain().getName(), () -> this.source.getAppliance().getName()));
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        ExportConfiguration exportConfiguration = new ExportConfiguration(this.source, exportOptions);
        exportConfiguration.getProcessThread().addInvocationListener(stil);
        String exportFileName = exportConfiguration.getExportFileName();
        if (exportConfiguration.getProcessThread().wasCanceled()) {
            this.importConfiguration(exportFileName);
        } else {
            exportConfiguration.addAdditionalCommandInfo("source", this.source);
            exportConfiguration.addAdditionalCommandInfo("target", this.target);
            exportConfiguration.addManagementCommandSubscriber(exportSubscriber);
            for (ManagementCommandSubscriber subscriber : this.managementCommandSubscribers) {
                exportConfiguration.addManagementCommandSubscriber(subscriber);
            }
            stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
            if (exportConfiguration.getRequestStatus()) {
                this.importConfiguration(exportFileName);
            } else {
                this.complete = true;
                return;
            }
        }
        if (this.actionType == CopyMoveType.MOVE) {
            stil.clearCompletionStatus();
            Appliance appliance = this.source.getAppliance();
            Domain domain = this.source.getSourceDomain();
            logger.info(() -> LMG.log("(): Deleting %s %s from the %s domain of %s", () -> this.source.getDataPowerClass(), () -> this.source.getName(), () -> this.source.getSourceDomain().getName(), () -> this.source.getAppliance().getName()));
            DeleteObjectConfiguration deleteConfig = new DeleteObjectConfiguration(appliance, domain, this.source.getDataPowerClass(), this.source.getName());
            deleteConfig.getProcessThread().addInvocationListener(stil);
            deleteConfig.setCommandDescription(String.format("Move %s %s to %s domain of %s", this.source.getDataPowerClass(), this.source.getName(), this.target.getSourceDomain().getName(), this.target.getAppliance().getName()));
            for (ManagementCommandSubscriber subscriber : this.managementCommandSubscribers) {
                deleteConfig.addManagementCommandSubscriber(subscriber);
            }
            stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        }
        this.complete = true;
        logger.finer("(): Done)");
    }

    private void importConfiguration(String exportFileName) {
        logger.info(() -> LMG.log("(exportFileName='%s'): Importing %s %s into the %s domain of %s", () -> exportFileName, () -> this.source.getDataPowerClass(), () -> this.source.getName(), () -> this.target.getSourceDomain().getName(), () -> this.target.getAppliance().getName()));
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        ImportConfiguration importConfiguration = new ImportConfiguration(this.target.getAppliance(), this.target.getSourceDomain(), "zip", true, true, exportFileName);
        importConfiguration.getProcessThread().addInvocationListener(stil);
        importConfiguration.setCommandDescription(String.format("Copy %s %s to %s domain of %s", this.source.getDataPowerClass(), this.source.getName(), this.target.getSourceDomain().getName(), this.target.getAppliance().getName()));
        for (ManagementCommandSubscriber subscriber : this.managementCommandSubscribers) {
            importConfiguration.addManagementCommandSubscriber(subscriber);
        }
        stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
    }
}

