/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.ConfigurationRelationship;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigParseSettings;
import com.kumbasoft.core.beans.config.ConfigStylePolicyAction;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.DynamicParseSettingsReference;
import com.kumbasoft.core.beans.types.StylesheetParameter;
import com.kumbasoft.core.tools.AbstractConfigurationActionTool;
import com.kumbasoft.core.tools.ConfigTool;
import com.kumbasoft.core.tools.ConfigurationRename;
import com.kumbasoft.core.tools.DeleteObjectConfiguration;
import com.kumbasoft.core.tools.ThreadManager;
import java.io.Serializable;
import java.util.ArrayList;

public class ConfigurationReplace
extends AbstractConfigurationActionTool {
    protected SingleThreadInvocationListener configRelationshipListener;
    protected ConfigurationRelationship configurationRelationship;
    protected String newName;
    protected boolean keepOriginal;

    public ConfigurationReplace(StatusObjectStatus source, String replaceObjectName) {
        this(source, replaceObjectName, true);
    }

    public ConfigurationReplace(StatusObjectStatus source, String replaceObjectName, boolean keepOriginal) {
        super(source);
        this.newName = replaceObjectName;
        this.keepOriginal = keepOriginal;
        new AsynchMethodInvoker((Object)this, "createConfigurationRelationship");
    }

    @Override
    public void performProcess() {
        logger.finer("(): Starting.  Waiting for configuration relationship to complete");
        while (!this.configRelationshipListener.invocationComplete()) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        logger.finer("(): Configuration relationships complete.");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        ArrayList<ConfigurationRelationship> relationships = this.configurationRelationship.getReferences();
        logger.finer("(): Got Relationships");
        for (ConfigurationRelationship relationship : relationships) {
            DataPowerConfig referencingObject = relationship.getObjectInFocus();
            String refactoringDescription = String.format("Refactoring References in %s %s", referencingObject.getConfigObjectType(), referencingObject.getName());
            logger.info(refactoringDescription);
            ManagementCommandStatus managementCommandStatus = new ManagementCommandStatus(this.source.getAppliance(), this.source.getSourceDomain(), refactoringDescription, null, "Starting");
            this.notifyManagementCommandSubscribers(managementCommandStatus);
            this.refactorReference(referencingObject);
            logger.info(() -> LMG.log("(): Done refactoring references in %s %s.  Saving Config.", () -> referencingObject.getConfigObjectType(), () -> referencingObject.getName()));
            ConfigTool configTool = new ConfigTool(referencingObject.getAppliance(), referencingObject.getSourceDomain(), referencingObject);
            mtil.addThread(configTool.getProcessThread());
            configTool.addManagementCommandSubscriber(this.managementCommandSubscribers);
        }
        logger.finer("(): Waiting until all save configs are complete.");
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ConfigurationRename.performProcess()", mtil, relationships.size(), 0);
        if (!completedOnTime) {
            logger.warning("(): No all save configs completed in time.  Continuing, but unexpected results may occur.");
        } else {
            logger.fine("(): All save configs are complete.");
        }
        if (!this.keepOriginal) {
            mtil.resetThreadCount();
            logger.info(() -> LMG.log("(): Deleting %s %s.", () -> this.source.getDataPowerClass(), () -> this.source.getName()));
            DeleteObjectConfiguration deleteObjectConfiguration = new DeleteObjectConfiguration(this.source);
            mtil.addThread(deleteObjectConfiguration.getProcessThread());
            deleteObjectConfiguration.addManagementCommandSubscriber(this.managementCommandSubscribers);
            logger.finer(() -> LMG.log("(): Waiting for Delete of %s %s to complete.", () -> this.source.getDataPowerClass(), () -> this.source.getName()));
            ThreadManager.monitorAsynchThreadLifeCycle("ConfigurationRename.performProcess()", mtil, KumbaCoreConstants.STARTUP_DELAY + 50, 0);
            logger.info(() -> LMG.log("(): Delete of %s %s complete.", () -> this.source.getDataPowerClass(), () -> this.source.getName()));
        }
        logger.finer("(): Done");
    }

    String getNewName(ConfigurationRename configurationRename) {
        return this.newName;
    }

    void setNewName(String newName, ConfigurationRename configurationRename) {
        this.newName = newName;
    }

    boolean keepOriginal(ConfigurationRename configurationRename) {
        return this.keepOriginal;
    }

    void setKeepOriginal(boolean keepOriginal, ConfigurationRename configurationRename) {
        this.keepOriginal = keepOriginal;
    }

    protected void refactorReference(Object referencingObject) {
        logger.finer("(Object referencingObject):  Starting");
        if (referencingObject instanceof ConfigStylePolicyAction) {
            ConfigStylePolicyAction stylePolicyAction = (ConfigStylePolicyAction)referencingObject;
            logger.finer(() -> LMG.log("(Object referencingObject): Referencing object is a style policy action '%s'.  Trying possible non-object references.", () -> stylePolicyAction.getName()));
            this.refactorReferencesOfStylePolicyAction(stylePolicyAction);
        }
        ArrayList<String> propertyNames = BeanService.getPropertyNames(referencingObject);
        String sourceType = this.source.getDataPowerClass();
        String sourceName = this.source.getName();
        logger.finer(() -> LMG.log("(Object referencingObject): Checking all properties of %s %s.", () -> sourceType, () -> sourceName));
        for (String propertyName : propertyNames) {
            Class<Serializable> propertyType = BeanService.getPropertyType(referencingObject, propertyName);
            logger.finer(() -> LMG.log("(Object referencingObject): Checking %s %s of %s %s.", () -> propertyType.getSimpleName(), () -> propertyName, () -> sourceType, () -> sourceName));
            if (propertyType.isAssignableFrom(ObjectReference.class)) {
                ObjectReference objectReference = (ObjectReference)BeanService.getPropertyValue(referencingObject, propertyName);
                if (objectReference == null) continue;
                String typeOfThisReference = objectReference.getClassName();
                String nameOfThisReference = objectReference.getName();
                logger.finer(() -> LMG.log("(Object referencingObject): Reference is an object reference of %s %s within the %s %s of %s %s.", () -> typeOfThisReference, () -> nameOfThisReference, () -> propertyType.getSimpleName(), () -> propertyName, () -> sourceType, () -> sourceName));
                if (typeOfThisReference == null || nameOfThisReference == null || !typeOfThisReference.equals(sourceType) || !nameOfThisReference.equals(sourceName)) continue;
                logger.config(() -> LMG.log("(Object referencingObject): Object Reference %s %s within %s %s references %s %s.  Refactoring.", () -> typeOfThisReference, () -> nameOfThisReference, () -> propertyType.getSimpleName(), () -> propertyName, () -> sourceType, () -> sourceName));
                objectReference.setName(this.newName);
                continue;
            }
            if (!propertyType.isAssignableFrom(ArrayList.class)) continue;
            logger.finer(() -> LMG.log("(Object referencingObject): %s %s of %s %s is a list.  Checking members.", () -> propertyType.getSimpleName(), () -> propertyName, () -> sourceType, () -> sourceName));
            ArrayList listOfObjects = (ArrayList)BeanService.getPropertyValue(referencingObject, propertyName);
            if (listOfObjects == null) continue;
            int i = 0;
            while (i < listOfObjects.size()) {
                int index = i;
                Object object = listOfObjects.get(i);
                if (object instanceof ObjectReference) {
                    ObjectReference objectReference = (ObjectReference)object;
                    String typeOfThisReference = objectReference.getClassName();
                    String nameOfThisReference = objectReference.getName();
                    logger.finer(() -> LMG.log("(Object referencingObject): Member %d is an object reference of %s %s within the %s %s of %s %s.  Checking", () -> index, () -> typeOfThisReference, () -> nameOfThisReference, () -> propertyType.getSimpleName(), () -> propertyName, () -> sourceType, () -> sourceName));
                    if (typeOfThisReference.equals(sourceType) && nameOfThisReference.equals(sourceName)) {
                        logger.config(() -> LMG.log("(Object referencingObject): Member %d is an Object Reference %s %s within %s %s references %s %s.  Refactoring.", () -> index, () -> typeOfThisReference, () -> nameOfThisReference, () -> propertyType.getSimpleName(), () -> propertyName, () -> sourceType, () -> sourceName));
                        objectReference.setName(this.newName);
                    }
                } else if (object instanceof StylesheetParameter) {
                    StylesheetParameter styleSheetParameter = (StylesheetParameter)object;
                    logger.finer(() -> LMG.log("(Object referencingObject): Member %d is a stylesheet parameter within the %s %s of %s %s.  Checking", () -> index, () -> propertyType.getSimpleName(), () -> propertyName, () -> sourceType, () -> sourceName));
                    this.refactorReferencesInStylesheetParameter(styleSheetParameter);
                } else if (object instanceof JMBean) {
                    logger.finer(() -> LMG.log("(Object referencingObject): Member %d is a non-object type within the %s %s of %s %s.  Checking", () -> index, () -> propertyType.getSimpleName(), () -> propertyName, () -> sourceType, () -> sourceName));
                    this.refactorReference(object);
                }
                ++i;
            }
        }
        logger.finer("(Object referencingObject):  Done");
    }

    private void refactorReferencesOfStylePolicyAction(ConfigStylePolicyAction stylePolicyAction) {
        String actionType;
        logger.finer(() -> LMG.log("(stylePolicyAction=%s): Starting.", () -> stylePolicyAction.getName()));
        String sourceType = this.source.getDataPowerClass();
        String sourceName = this.source.getName();
        switch (actionType = stylePolicyAction.getType()) {
            case "call": 
            case "on-error": {
                String objectName;
                if (!sourceType.equals("StylePolicyRule") || !(objectName = stylePolicyAction.getRule()).equals(sourceName)) break;
                logger.config(() -> LMG.log("(stylePolicyAction=%s): Action of type %s references %s %s.  Refactoring.", () -> stylePolicyAction.getName(), () -> actionType, () -> sourceType, () -> sourceName));
                stylePolicyAction.setRule(this.newName);
                break;
            }
            case "event-sink": {
                if (!sourceType.equals("StylePolicyAction")) break;
                ArrayList<String> asynchActions = stylePolicyAction.getAsyncAction();
                ArrayList<String> newActions = new ArrayList<String>(asynchActions.size());
                if (CollectionUtility.isNotEmpty(asynchActions)) {
                    for (String objectName : asynchActions) {
                        if (objectName.equals(sourceName)) {
                            logger.config(() -> LMG.log("(stylePolicyAction=%s): Action of type %s references %s %s.  Refactoring.", () -> stylePolicyAction.getName(), () -> actionType, () -> sourceType, () -> sourceName));
                            newActions.add(this.newName);
                            continue;
                        }
                        newActions.add(objectName);
                    }
                }
                stylePolicyAction.setAsyncAction(newActions);
                break;
            }
            case "parse": {
                DynamicParseSettingsReference parseSettingsReference;
                ObjectReference<ConfigParseSettings> parseSettingsRef;
                String parseSettingsName;
                if (!sourceType.equals("ParseSettings") || !sourceName.equals(parseSettingsName = (parseSettingsRef = (parseSettingsReference = stylePolicyAction.getParseSettingsReference()).getDefaultType()).getName())) break;
                logger.config(() -> LMG.log("(stylePolicyAction=%s): Action of type %s references %s %s.  Refactoring.", () -> stylePolicyAction.getName(), () -> actionType, () -> sourceType, () -> sourceName));
                parseSettingsRef.setName(this.newName);
            }
        }
        logger.finer(() -> LMG.log("(stylePolicyAction=%s): Done.", () -> stylePolicyAction.getName()));
    }

    private void refactorReferencesInStylesheetParameter(StylesheetParameter stylesheetParameter) {
        String value;
        String name;
        String sourceObjectName;
        String sourceObjectType;
        block42: {
            String objectName;
            String objectType;
            block43: {
                sourceObjectType = this.source.getDataPowerClass();
                sourceObjectName = this.source.getName();
                name = stylesheetParameter.getParameterName();
                value = stylesheetParameter.getParameterValue();
                logger.finer(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Starting checking for references for %s %s.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                if (!name.startsWith("{http://www.datapower.com/param/config}")) break block42;
                objectType = StringUtility.substringAfter(name, "}");
                objectName = value;
                if (!Comparison.isIn(objectType, DPEnumerations.CONFIG_ENUM)) break block43;
                if (objectType.equals(sourceObjectType) && objectName.equals(sourceObjectName)) {
                    logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter references %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                    stylesheetParameter.setParameterValue(this.newName);
                }
                break block42;
            }
            switch (objectType) {
                case "additional-certificates": {
                    if (!sourceObjectType.equals("CryptoCertificate")) break;
                    if (value.contains("+")) {
                        String[] objectNames = value.split("\\+");
                        StringBuilder sb = new StringBuilder();
                        int i = 0;
                        while (i < objectNames.length) {
                            if (i > 0) {
                                sb.append("+");
                            }
                            if (objectNames[i].equals(objectName)) {
                                logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                                sb.append(this.newName);
                            }
                            ++i;
                        }
                        String newDelimitedValue = sb.toString();
                        stylesheetParameter.setParameterName(newDelimitedValue);
                        break;
                    }
                    if (!value.equals(objectName)) break;
                    logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                    stylesheetParameter.setParameterValue(this.newName);
                    break;
                }
                case "keypair-cert": {
                    if (!sourceObjectType.equals("CryptoCertificate") || !sourceObjectName.equals(objectName)) break;
                    logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                    stylesheetParameter.setParameterValue(this.newName);
                    break;
                }
                case "keypair-key": {
                    if (!sourceObjectType.equals("CryptoKey") || !sourceObjectName.equals(objectName)) break;
                    logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                    stylesheetParameter.setParameterValue(this.newName);
                    break;
                }
                case "recipients": 
                case "signers": {
                    if (!sourceObjectType.equals("CryptoIdentCred")) break;
                    if (value.contains("+")) {
                        String[] objectNames = value.split("\\+");
                        StringBuilder sb = new StringBuilder();
                        int i = 0;
                        while (i < objectNames.length) {
                            if (i > 0) {
                                sb.append("+");
                            }
                            if (objectNames[i].equals(objectName)) {
                                logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                                sb.append(this.newName);
                            }
                            ++i;
                        }
                        String newDelimitedValue = sb.toString();
                        stylesheetParameter.setParameterName(newDelimitedValue);
                        break;
                    }
                    if (!value.equals(objectName)) break;
                    logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                    stylesheetParameter.setParameterValue(this.newName);
                    break;
                }
                case "remote-token-retrieval-idcred": {
                    if (!sourceObjectType.equals("CryptoIdentCred") || !sourceObjectName.equals(objectName)) break;
                    logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                    stylesheetParameter.setParameterValue(this.newName);
                    break;
                }
                case "remote-token-sslclientprofile": {
                    if (!sourceObjectType.equals("SSLClientProfile") || !sourceObjectName.equals(objectName)) break;
                    logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                    stylesheetParameter.setParameterValue(this.newName);
                    break;
                }
                case "remote-token-sslprofile": {
                    if (!sourceObjectType.equals("SSLProxyProfile") || !sourceObjectName.equals(objectName)) break;
                    logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                    stylesheetParameter.setParameterValue(this.newName);
                    break;
                }
                case "signer": {
                    String signerCertName;
                    if (!sourceObjectType.equals("CryptoCertificate") || !objectName.startsWith("name:") || !(signerCertName = StringUtility.substringAfter(objectName, "name:").trim()).equals(sourceObjectName)) break;
                    logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                    stylesheetParameter.setParameterValue(String.format("name:%s", this.newName));
                    break;
                }
                case "valcred": {
                    if (!sourceObjectType.equals("CryptoValCred") || !sourceObjectName.equals(objectName)) break;
                    logger.config(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter contains a reference to %s %s.  Refactoring.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
                    stylesheetParameter.setParameterValue(this.newName);
                    break;
                }
                default: {
                    logger.info(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Parameter Not Mapped.", () -> name, () -> value));
                }
            }
        }
        logger.finer(() -> LMG.log("(stylesheetParameter=[%s,%s]):  Done checking for references for %s %s.", () -> name, () -> value, () -> sourceObjectType, () -> sourceObjectName));
    }

    @Reflected
    private void createConfigurationRelationship() {
        logger.finer("(): Starting.");
        this.configRelationshipListener = new SingleThreadInvocationListener();
        this.configurationRelationship = new ConfigurationRelationship(this.source, ConfigurationRelationshipType.CHILD_UP);
        this.configurationRelationship.getSetupThread().addInvocationListener(this.configRelationshipListener);
        logger.finer("(): Done.");
    }
}

