/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerObject;
import com.kumbasoft.core.beans.DataPowerStatus;
import com.kumbasoft.core.beans.DataPowerStatusListener;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerStatusParser;
import com.kumbasoft.core.tools.DataPowerXMLManagement;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.FileUtility;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DataPowerStatusMonitor<StatusProviderType extends DataPowerStatus>
extends DataPowerXMLManagement {
    private static final String BASE_STATUS_CLASS_FQN = "com.kumbasoft.core.beans.status.";
    private String statusClass;
    private String statusRequestMessage;
    private DateTime currentStatusTime;
    private long monitorInterval;
    private ArrayList<DataPowerStatusListener<StatusProviderType>> statusListeners;
    private boolean stop;
    private boolean stopped;
    protected StatusProviderType lastStatus;
    private String statusObjectClassName;
    private HashMap<String, XMLInfo> xmlProcessingInfo;
    private DataPowerStatusParser<DataPowerStatus> parser;
    private AsynchMethodInvoker<Void> processThread;

    public DataPowerStatusMonitor(Appliance appliance, Domain domain, String statusClass, long monitorInterval) {
        super(appliance, domain);
        AbstractTool.logger.finer(() -> LMG.log("(appliance='%s', domain='%s', statusClass='%s', monitorInterval=%d): Starting", () -> appliance.getName(), () -> domain.getName(), () -> statusClass, () -> monitorInterval));
        this.setStatusClass(statusClass);
        this.setMonitorInterval(monitorInterval);
        this.setRetryCount(2);
        this.parser = new DataPowerStatusParser(appliance, domain, statusClass, null);
        AbstractTool.logger.finer(() -> LMG.log("(appliance='%s', domain='%s', statusClass='%s', monitorInterval=%d): Invoking thread on 'monitor'.", () -> appliance.getName(), () -> domain.getName(), () -> statusClass, () -> monitorInterval));
        this.processThread = ThreadManager.getThread(appliance, this, "monitor", KumbaCoreConstants.STARTUP_DELAY, null);
        AbstractTool.logger.finer(() -> LMG.log("(appliance='%s', domain='%s', statusClass='%s', monitorInterval=%d): Done", () -> appliance.getName(), () -> domain.getName(), () -> statusClass, () -> monitorInterval));
    }

    public AsynchMethodInvoker<Void> getProcessThread() {
        return this.processThread;
    }

    @Reflected
    private void monitor() {
        AbstractTool.logger.finer("(): Starting");
        if (this.stop) {
            AbstractTool.logger.finer("(): Stop flag set.  Stopping.");
            return;
        }
        this.stopped = false;
        this.stop = false;
        try {
            this.parser.setStatusTime(new DateTime());
            XMLElement rootElement = this.runRequest();
            if (rootElement == null) {
                logger.severe(() -> LMG.log("(): Failed to process %s in %s.", () -> this.getStatusClass(), () -> this.applianceName));
                this.stopped = true;
                this.notifyError();
                return;
            }
            if (this.responseXML.contains("Authentication failure")) {
                logger.severe(() -> LMG.log("(): Authentication Failure Connecting to %s domain of %s:  URL=[%s]", () -> this.domainName, () -> this.applianceName, () -> this.getSoapMgmtURL()));
                this.stopped = true;
                this.notifyError();
            } else {
                Collection<DataPowerStatus> statusObjects = this.parser.processStatusData(rootElement);
                if (CollectionUtility.isEmpty(statusObjects)) {
                    String errorMessage = String.format("(): No status elements for \"%s\" exist within the response.", this.statusClass);
                    logger.warning(errorMessage);
                    XMLElement timeStampElement = rootElement.getNode("//dp:timestamp");
                    DateTime statusTime = new DateTime(timeStampElement.getValue());
                    this.notifyListeners(this.getAppliance(), this.getDomain(), this.statusClass, statusTime);
                } else {
                    logger.finer(() -> LMG.log("(): Received %d status objects for \"%s\" from the %s domain of %s", () -> statusObjects.size(), () -> this.statusClass, () -> this.domainName, () -> this.applianceName));
                    for (DataPowerStatus statusObject : statusObjects) {
                        this.notifyListeners(this.lastStatus, statusObject);
                        this.setLastStatus(statusObject);
                    }
                    this.notifyListeners();
                }
            }
        }
        catch (IOException ioe) {
            this.notifyListeners(this.lastStatus, null);
            logger.severe(() -> LMG.log("(): Error processing %s in the %s domain of %s.\n%s", () -> this.domainName, () -> this.applianceName, () -> this.statusClass, () -> ioe.getMessage()));
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.monitorInterval > 0L) {
            AbstractTool.logger.finer(() -> LMG.log("(): Repeating for interval %d", () -> this.monitorInterval));
            this.processThread = new AsynchMethodInvoker((Object)this, "monitor", (int)this.monitorInterval);
        }
        this.stopped = true;
        AbstractTool.logger.finer("(): Done");
    }

    public void stop() {
        AbstractTool.logger.finer("(): Setting stop flag.");
        this.stop = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    protected String getRequestMessage() {
        if (this.statusRequestMessage == null) {
            try {
                String somaFileName = FileUtility.getSOMATemplateFileName("StatusRequest.xml");
                String statusRequest = FileUtility.readFile(somaFileName);
                Domain domain = this.getDomain();
                String domainName = domain == null ? "all-domains" : this.domainName;
                statusRequest = statusRequest.replace("{domain}", domainName);
                this.statusRequestMessage = statusRequest.replace("{statusClass}", this.statusClass);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.statusRequestMessage;
    }

    public void addStatusListener(DataPowerStatusListener statusListener) {
        if (statusListener == null) {
            return;
        }
        if (this.statusListeners == null) {
            this.statusListeners = new ArrayList();
        }
        this.statusListeners.add(statusListener);
    }

    public void removeStatusListener(DataPowerStatusListener statusListener) {
        if (statusListener == null || this.statusListeners == null) {
            return;
        }
        this.statusListeners.remove(statusListener);
    }

    public void notifyListeners(StatusProviderType lastStatus, StatusProviderType newStatus) {
        if (this.statusListeners == null) {
            logger.warning(() -> LMG.log("(StatusProviderType lastStatus, StatusProviderType newStatus): No status listeners registered for \"%s\" for the %s domain of %s", () -> this.statusClass, () -> this.domainName, () -> this.applianceName));
            return;
        }
        for (DataPowerStatusListener<StatusProviderType> statusListener : this.statusListeners) {
            boolean changed;
            if (newStatus == null) {
                statusListener.error(this.getAppliance(), this.getDomain(), this.statusClass, this.errorCode, lastStatus);
                continue;
            }
            statusListener.statusEvent(newStatus);
            boolean bl = lastStatus == null ? true : (changed = !((DataPowerObject)lastStatus).equals(newStatus));
            if (!changed) continue;
            statusListener.statusChanged(lastStatus, newStatus);
        }
    }

    public void notifyListeners() {
        if (this.statusListeners == null) {
            return;
        }
        for (DataPowerStatusListener<StatusProviderType> statusListener : this.statusListeners) {
            statusListener.statusComplete(this.getAppliance(), this.getDomain(), this.statusClass);
        }
    }

    public void notifyListeners(Appliance appliance, Domain domain, String statusClass, DateTime statusTime) {
        if (this.statusListeners == null) {
            return;
        }
        for (DataPowerStatusListener<StatusProviderType> statusListener : this.statusListeners) {
            statusListener.noStatus(appliance, domain, statusClass, statusTime);
        }
    }

    public void notifyError() {
        if (this.statusListeners == null) {
            return;
        }
        for (DataPowerStatusListener<StatusProviderType> statusListener : this.statusListeners) {
            statusListener.error(this.getAppliance(), this.getDomain(), this.statusClass, this.errorCode, this.lastStatus);
        }
        this.notifyListeners();
    }

    public String getStatusClass() {
        return this.statusClass;
    }

    public void setStatusClass(String statusClass) {
        String loggerPrefix = String.format("(statusClass=%s)", statusClass);
        logger.finer(loggerPrefix);
        this.statusClass = statusClass;
        this.xmlProcessingInfo = new HashMap();
        this.statusObjectClassName = String.format("%sStatus%s", BASE_STATUS_CLASS_FQN, statusClass);
        try {
            DataPowerStatus statusObject = (DataPowerStatus)BeanService.getBean(this.statusObjectClassName);
            ArrayList<String> propertyNames = BeanService.getPropertyNames(statusObject);
            for (String propertyName : propertyNames) {
                Method accessor = BeanService.getPropertyAccessor(statusObject, propertyName);
                if (accessor == null) {
                    Application.getApplication().getApplicationLogger().fine(String.format("%s:  Accessor cannot be found in %s for %s", loggerPrefix, this.statusObjectClassName, propertyName));
                    continue;
                }
                XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(accessor, XMLInfo.class);
                if (xmlInfo == null) continue;
                this.xmlProcessingInfo.put(xmlInfo.elementName(), xmlInfo);
            }
        }
        catch (PropertyNotFoundException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public DateTime getCurrentStatusTime() {
        return this.currentStatusTime;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(long monitorInterval) {
        if (monitorInterval < 100L) {
            monitorInterval = 0L;
        }
        this.monitorInterval = monitorInterval;
    }

    public StatusProviderType getLastStatus() {
        return this.lastStatus;
    }

    protected void setLastStatus(StatusProviderType lastStatus) {
        this.lastStatus = lastStatus;
    }
}

