/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerStatus;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.util.FileUtility;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public final class DataPowerStatusParser<StatusProviderType extends DataPowerStatus>
extends AbstractTool {
    private static final String BASE_STATUS_CLASS_FQN = "com.kumbasoft.core.beans.status.";
    private static final HashMap<String, Pair<String, String>> STATUS_OBJECT_NAME_MAP = new HashMap();
    private Appliance appliance;
    private String applianceName;
    private Domain domain;
    private String domainName;
    private String statusClass;
    private String statusClassNodeExpression;
    private DateTime statusTime;
    private String statusObjectClassName;
    private HashMap<String, XMLInfo> xmlProcessingInfo;

    static {
        try {
            String[] nameMaps;
            String nameMapData = FileUtility.readFile("/configs/StatusConfigNameMap.txt");
            String[] stringArray = nameMaps = nameMapData.split("\n");
            int n = nameMaps.length;
            int n2 = 0;
            while (n2 < n) {
                String nameMap = stringArray[n2];
                if (!StringUtility.isEmpty(nameMap) && !nameMap.startsWith("#")) {
                    try {
                        String[] mapInfo = nameMap.split("\t");
                        STATUS_OBJECT_NAME_MAP.put(mapInfo[0], new Pair<String, String>(mapInfo[1], mapInfo[2]));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        logger.severe(() -> LMG.log("DataPowerStatusParser.clinit():  Format error in /configs/StatusConfigNameMap.txt.  Problem parsing name map entry '%s'", () -> nameMap));
                    }
                }
                ++n2;
            }
        }
        catch (IOException e) {
            logger.config("DataPowerStatusParser.clinit():  Error reading /configs/StatusConfigNameMap.txt");
            e.printStackTrace();
        }
    }

    public DataPowerStatusParser(Appliance appliance, Domain domain, String statusClass, DateTime statusTime) {
        this.setAppliance(appliance);
        this.setDomain(domain);
        this.setStatusClass(statusClass);
        this.setStatusTime(statusTime);
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public void setAppliance(Appliance appliance) {
        this.appliance = appliance;
        this.applianceName = appliance == null ? "-- null --" : this.appliance.getName();
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
        this.domainName = domain == null ? "-- null --" : this.domain.getName();
    }

    public String getStatusClass() {
        return this.statusClass;
    }

    public void setStatusClass(String statusClass) {
        this.statusClass = statusClass;
        this.statusClassNodeExpression = String.format("//%s", statusClass);
        this.xmlProcessingInfo = new HashMap();
        this.statusObjectClassName = String.format("%sStatus%s", BASE_STATUS_CLASS_FQN, statusClass);
        try {
            DataPowerStatus statusObject = (DataPowerStatus)BeanService.getBean(this.statusObjectClassName);
            ArrayList<String> propertyNames = BeanService.getPropertyNames(statusObject);
            for (String propertyName : propertyNames) {
                Method accessor = BeanService.getPropertyAccessor(statusObject, propertyName);
                if (accessor == null) {
                    AbstractTool.logger.fine(() -> LMG.log("(statusClass=%s):  Accessor cannot be found in %s for %s", () -> statusClass, () -> this.statusObjectClassName, () -> propertyName));
                    continue;
                }
                XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(accessor, XMLInfo.class);
                if (xmlInfo == null) continue;
                this.xmlProcessingInfo.put(xmlInfo.elementName(), xmlInfo);
            }
        }
        catch (PropertyNotFoundException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public DateTime getStatusTime() {
        return this.statusTime;
    }

    public void setStatusTime(DateTime statusTime) {
        this.statusTime = statusTime;
    }

    public Collection<StatusProviderType> processStatusData(String statusData) {
        XMLElement domainStatusXML = XMLElement.parseXMLString(statusData);
        if (domainStatusXML != null) {
            return this.processStatusData(domainStatusXML);
        }
        return null;
    }

    public Collection<StatusProviderType> processStatusData(XMLElement rootElement) {
        String statusIdentifier = String.format("\"%s\" for the %s domain of %s", this.statusClass, this.domainName, this.applianceName);
        String entryExitMessage = String.format("(XMLElement rootElement): %s", statusIdentifier);
        logger.finer(() -> LMG.log("%s - Starting", () -> entryExitMessage));
        Collection<XMLElement> statusElements = rootElement.getNodes(this.statusClassNodeExpression);
        ArrayList<StatusProviderType> statusObjects = new ArrayList<StatusProviderType>();
        int elementCount = statusElements.size();
        if (elementCount == 0) {
            String errorMessage = String.format("(XMLElement rootElement): No status elements for the %s within the provided XML document.", statusIdentifier);
            logger.warning(errorMessage);
            return statusObjects;
        }
        logger.finer(() -> LMG.log("%s - Processing %d elements for %s", () -> entryExitMessage, () -> statusElements.size(), () -> statusIdentifier));
        for (XMLElement element : statusElements) {
            StatusProviderType statusObject = this.processStatusNode(element);
            if (statusObject == null) {
                String errorMessage = String.format("(XMLElement rootElement): Parsed status object is null for %s for element:\n%s\n", statusIdentifier, element.toString());
                logger.warning(errorMessage);
                continue;
            }
            statusObjects.add(statusObject);
        }
        logger.finer(() -> LMG.log("%s - Ending", () -> entryExitMessage));
        return statusObjects;
    }

    private StatusProviderType processStatusNode(XMLElement element) {
        AbstractTool.logger.finer("(XMLElement): Starting");
        try {
            DataPowerStatus statusObject = (DataPowerStatus)BeanService.getBean(this.statusObjectClassName);
            statusObject.setAppliance(this.appliance);
            statusObject.setSourceDomain(this.domain);
            statusObject.setStatusTime(this.statusTime);
            String dataPowerClass = null;
            Collection<XMLElement> childNodes = element.getNodes();
            AbstractTool.logger.finer(() -> LMG.log("(XMLElement): Processing %d child nodes.", () -> childNodes.size()));
            for (XMLElement childNode : childNodes) {
                Pair<String, String> mapInfo;
                String nodeName = childNode.getName();
                AbstractTool.logger.finer(() -> LMG.log("(XMLElement): Processing node '%s'.", () -> nodeName));
                XMLInfo xmlInfo = this.xmlProcessingInfo.get(nodeName);
                if (xmlInfo == null) {
                    AbstractTool.logger.warning(() -> LMG.log("(XMLElement): No XMLInfo for node '%s'.  Is there something different in the firmware?", () -> nodeName));
                    continue;
                }
                String javaName = xmlInfo.javaName();
                String javaType = xmlInfo.javaType();
                Object elementValue = childNode.getValue();
                if (nodeName.equals("Class")) {
                    dataPowerClass = elementValue;
                }
                if (javaType.startsWith("ObjectReference")) {
                    ObjectReference ref = new ObjectReference();
                    ref.setClassName(childNode.getAttributeValue("class"));
                    ref.setName((String)elementValue);
                    elementValue = ref;
                }
                if (javaName.equals("name") && (mapInfo = STATUS_OBJECT_NAME_MAP.get(dataPowerClass)) != null) {
                    String dataPowerName = (String)mapInfo.first;
                    String actualName = (String)mapInfo.second;
                    if (elementValue.equals(dataPowerName)) {
                        elementValue = actualName;
                    }
                }
                BeanService.setPropertyValue(statusObject, javaName, elementValue);
            }
            return (StatusProviderType)statusObject;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            AbstractTool.logger.finer("(XMLElement): Done - Returning NULL.");
            return null;
        }
    }
}

