/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.io.FileHierarchy;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.actions.ActionCreateDir;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.ThreadManager;
import java.io.File;
import java.util.ArrayList;

public class LocalFileSystemImporter
extends AbstractTool {
    private Appliance appliance;
    private Domain domain;
    private FileHierarchy localSystemFiles;
    private DataPowerFileInfo dpFSTarget;

    public LocalFileSystemImporter(Appliance appliance, Domain domain, String localSystemPath, DataPowerFileInfo dpFSTarget) {
        this(appliance, domain, new FileHierarchy(localSystemPath), dpFSTarget);
    }

    public LocalFileSystemImporter(Appliance appliance, Domain domain, File localSystemDirectory, DataPowerFileInfo dpFSTarget) {
        this(appliance, domain, new FileHierarchy(localSystemDirectory), dpFSTarget);
    }

    public LocalFileSystemImporter(Appliance appliance, Domain domain, FileHierarchy localSystemFiles, DataPowerFileInfo dpFSTarget) {
        this.appliance = appliance;
        this.domain = domain;
        this.localSystemFiles = localSystemFiles;
        this.dpFSTarget = dpFSTarget;
    }

    public void uploadFiles() {
        String baseDirectory = this.dpFSTarget.getAbsolutePath();
        AbstractTool.logger.finer(() -> LMG.log("():  Uploading to %s domain of %s into %s", () -> this.domain.getName(), () -> this.appliance.getName(), () -> baseDirectory));
        this.createDataPowerDirectory(baseDirectory);
        ArrayList<File> files = this.localSystemFiles.getFiles();
        if (CollectionUtility.isEmpty(files)) {
            AbstractTool.logger.severe("No local files to upload.");
            return;
        }
        ArrayList<DataPowerFileInfo> filesToUpload = new ArrayList<DataPowerFileInfo>();
        for (File file : files) {
            if (file.isDirectory()) {
                AbstractTool.logger.finer(() -> LMG.log("():  Creating %s into %s domain of %s\n", () -> baseDirectory + file.getName() + file.getName(), () -> this.domain.getName(), () -> this.appliance.getName()));
            } else {
                AbstractTool.logger.info(() -> LMG.log("():  Uploading file %s into %s domain of %s\n", () -> baseDirectory + file.getName(), () -> this.domain.getName(), () -> this.appliance.getName()));
                DataPowerFileInfo newFile = new DataPowerFileInfo(this.appliance, this.domain, null, 0L, baseDirectory, file.getName());
                newFile.setLocalFile(file);
                filesToUpload.add(newFile);
            }
            MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
            FileUploader.upload(filesToUpload, mtil);
            FileUploader.addCommandSubscribers(this.managementCommandSubscribers);
            ThreadManager.monitorAsynchThreadLifeCycle("LocalFileSystemImporter.uploadFiles()", mtil, filesToUpload.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        }
    }

    private void createDataPowerDirectory(String directory) {
        String loggerPrefix = String.format("(String directory=%s)", directory);
        AbstractTool.logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        ActionCreateDir createDirAction = new ActionCreateDir();
        createDirAction.setDir(directory);
        ActionTool actionTool = new ActionTool(this.appliance, this.domain, createDirAction, true);
        actionTool.addManagementCommandSubscriber(this.managementCommandSubscribers);
        AbstractTool.logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
    }
}

