/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.j2ee.xml.XMLElement;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.tools.AbstractDataPowerManagementRequest;
import com.kumbasoft.core.util.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public class RestoreDomainBackup
extends AbstractDataPowerManagementRequest {
    private File backupFile;
    private String sourceType = "ZIP";
    private boolean dryRun = false;
    private boolean overwriteFiles = true;
    private boolean overwriteObjects = true;
    private boolean importDomain = true;
    private boolean resetDomain = false;
    private String fileContents;

    public RestoreDomainBackup(Appliance appliance, Domain domain, File backupFile) {
        super(appliance, domain, "Restore domain from backup");
        this.setBackupFile(backupFile);
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isOverwriteFiles() {
        return this.overwriteFiles;
    }

    public void setOverwriteFiles(boolean overwriteFiles) {
        this.overwriteFiles = overwriteFiles;
    }

    public boolean isOverwriteObjects() {
        return this.overwriteObjects;
    }

    public void setOverwriteObjects(boolean overwriteObjects) {
        this.overwriteObjects = overwriteObjects;
    }

    public boolean isImportDomain() {
        return this.importDomain;
    }

    public void setImportDomain(boolean importDomain) {
        this.importDomain = importDomain;
    }

    public boolean isResetDomain() {
        return this.resetDomain;
    }

    public void setResetDomain(boolean resetDomain) {
        this.resetDomain = resetDomain;
    }

    @Override
    protected boolean processResultDocument(XMLElement rootElement) {
        ManagementCommandStatus commandStatus;
        String actionStatusMessage;
        Collection<XMLElement> fileResults = rootElement.getNodes("//file-result");
        for (XMLElement fileResult : fileResults) {
            String fileName = fileResult.getAttributeValue("name");
            String result = fileResult.getAttributeValue("result");
            XMLElement reasonElement = fileResult.getNode("reason");
            String reason = reasonElement.getValue();
            if (reason == null) {
                reason = "OK";
            }
            actionStatusMessage = String.format("File %s %s:  %s", fileName, result, reason);
            commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), this.getCommandDescription(), this, actionStatusMessage);
            this.notifyManagementCommandSubscribers(commandStatus);
        }
        Collection<XMLElement> cfgResults = rootElement.getNodes("//cfg-result");
        for (XMLElement cfgResult : cfgResults) {
            String objectClass = cfgResult.getAttributeValue("class");
            String objectName = cfgResult.getAttributeValue("name");
            String importStatus = cfgResult.getAttributeValue("status");
            actionStatusMessage = String.format("Object %s %s:  %s", objectClass, objectName, importStatus);
            commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), this.getCommandDescription(), this, actionStatusMessage);
            this.notifyManagementCommandSubscribers(commandStatus);
        }
        return true;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public void setBackupFile(File backupFile) {
        if (backupFile == null || !backupFile.exists()) {
            return;
        }
        this.backupFile = backupFile;
        try {
            String base64Contents = FileUtility.readAsBase64(backupFile);
            this.setFileContents(base64Contents);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFileContents() {
        return this.fileContents;
    }

    public void setFileContents(String fileContents) {
        this.fileContents = fileContents;
    }
}

