/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.tools.AbstractPacketCaptureActionTool;

public class StartPacketCapture
extends AbstractPacketCaptureActionTool {
    private String captureMode;
    private int maxDuration;
    private int maxCaptureSize;
    private int maxPacketSize;
    private String filter;
    private String sslKeyLog;

    public StartPacketCapture(Appliance appliance) {
        this(appliance, "timed", 30, 10000, 9000);
    }

    public StartPacketCapture(Appliance appliance, String interfaceType, int maxDuration, int maxCaptureSize, int maxPacketSize) {
        super(appliance, interfaceType, "Start Packet Capture");
        this.setCaptureMode(interfaceType);
        this.setMaxDuration(maxDuration);
        this.setMaxCaptureSize(maxCaptureSize);
        this.setMaxPacketSize(maxPacketSize);
    }

    @Override
    protected String finalizeRequestMessage(String requestXML) {
        requestXML = super.finalizeRequestMessage(requestXML);
        if (StringUtility.isEmpty(this.filter)) {
            requestXML = AbstractPacketCaptureActionTool.removeElement(requestXML, "Filter");
        }
        return requestXML;
    }

    public String getCaptureMode() {
        return this.captureMode;
    }

    public void setCaptureMode(String captureMode) {
        switch (captureMode = captureMode.toLowerCase()) {
            case "timed": 
            case "continuous": {
                this.captureMode = captureMode;
            }
        }
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(int maxDuration) {
        if (maxDuration < 5) {
            maxDuration = 5;
        }
        if (maxDuration > 86400) {
            maxDuration = 86400;
        }
        this.maxDuration = maxDuration;
    }

    public int getMaxCaptureSize() {
        return this.maxCaptureSize;
    }

    public void setMaxCaptureSize(int maxCaptureSize) {
        if (maxCaptureSize < 10) {
            maxCaptureSize = 10;
        }
        if (maxCaptureSize > 500000) {
            maxCaptureSize = 500000;
        }
        this.maxCaptureSize = maxCaptureSize;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getSslKeyLog() {
        return this.sslKeyLog;
    }

    public void setSslKeyLog(String sslKeyLog) {
        this.sslKeyLog = sslKeyLog;
    }
}

