/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMProgressBar;
import com.jmorgan.swing.decorator.OverlayDecorator;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.statusbar.StatusBar;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.beans.DomainGroup;
import com.kumbasoft.core.ui.KumbaCoreFrame;
import com.kumbasoft.core.ui.KumbaCoreGUIApplicationProperties;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.CommandResultsDialog;
import com.kumbasoft.core.ui.panel.ApplianceDomainListPanel;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.security.LicenseManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;

public abstract class AbstractPanel
extends JMPanel {
    protected static Logger logger = Application.getApplication().getApplicationLogger();
    protected static KumbaCoreFrame frame;
    protected static KumbaCoreApplicationProperties applicationProperties;
    protected static String HELP_FILES_DIRECTORY;
    protected StatusBar frameStatusBar;
    protected JMPopupMenu popupMenu;
    protected JMButton popupMenuButton;
    protected CommandResultsDialog commandResultsDialog;
    protected JMProgressBar progressBar;
    private boolean revalidationComplete;
    private int frameWaits;

    static {
        applicationProperties = (KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties();
        HELP_FILES_DIRECTORY = applicationProperties.getHelpFilesDirectory();
    }

    protected AbstractPanel() {
        this(KumbaCoreUIConstants.createBorderLayout());
    }

    protected AbstractPanel(LayoutManager layout) {
        super(layout);
        this.checkEntitlements();
        this.setInsets(InsetsFactory.createFixedInsets(5));
        new AsynchMethodInvoker((Object)this, "waitForFrame", KumbaCoreConstants.THREAD_WAIT * 4);
        new ComponentEventInvoker(this, 2, (Object)this, "revalidateOnVisible");
    }

    protected void createPopupMenu() {
    }

    protected JMButton getPopupMenuButton() {
        logger.finer("(): Starting");
        this.popupMenuButton = new JMButton(KumbaCoreUIConstants.HAMBURGER_ICON);
        new ActionEventInvoker(this.popupMenuButton, this, "showPopupMenu", this.popupMenuButton);
        logger.finer("(): Done");
        return this.popupMenuButton;
    }

    protected JMPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            logger.finer("(): Creating Popup Menu");
            this.popupMenu = new JMPopupMenu();
        }
        return this.popupMenu;
    }

    protected JMPopupMenu getPopupMenu(Component popupMenuClient) {
        logger.finer(() -> LMG.log("(Component popupMenuClient=%s): Starting", () -> popupMenuClient.getClass().getName()));
        JMPopupMenu menu = this.getPopupMenu();
        menu.addPopupMenuClient(popupMenuClient);
        logger.finer(() -> LMG.log("(Component popupMenuClient=%s): Done", () -> popupMenuClient.getClass().getName()));
        return menu;
    }

    protected void showPopupMenu(Component parentComponent) {
        logger.finer(() -> LMG.log("(parentComponent='%s'): Starting.", () -> parentComponent.getClass().getName()));
        if (this.isPopupReady()) {
            logger.finer(() -> LMG.log("(parentComponent='%s'): Popup menu is ready.  Showing popup menu.", () -> parentComponent.getClass().getName()));
            this.popupMenu.show(parentComponent, 10, 10);
        }
        logger.finer(() -> LMG.log("(parentComponent='%s'): Done.", () -> parentComponent.getClass().getName()));
    }

    protected boolean isPopupReady() {
        return false;
    }

    protected void showMessage(String title, String message) {
        if (!message.toLowerCase().startsWith("<html>")) {
            message = StringUtility.wordWrap(message, 50);
            message = LabelUtility.wrapInHTML(message);
        }
        new JMMessageBox((JFrame)frame, title, message);
    }

    protected boolean continueAction(String title, String message) {
        new JMMessageBox((JFrame)frame, title, message, 12);
        return JMMessageBox.getSelection() == 4;
    }

    protected boolean continueAction(String titlePrefix, String messagePrefix, boolean domainsApply) {
        String message;
        String title;
        if (AbstractPanel.areAllAppliancesSelected() && !this.continueAction(title = String.format("%s ALL Appliances", titlePrefix), message = String.format("Do you really want to %s ALL Appliances?", messagePrefix))) {
            return false;
        }
        return !domainsApply || !AbstractPanel.areAllDomainsSelected() || this.continueAction(title = String.format("%s ALL Domains", titlePrefix), message = String.format("Do you really want to %s ALL Domains?", messagePrefix));
    }

    protected static boolean areAllAppliancesSelected() {
        ApplianceDomainListPanel applianceOptionsPane = frame.getApplianceDomainListPanel();
        List<ApplianceGroupObject> selectedAppliances = applianceOptionsPane.getSelectedApplianceGroup();
        boolean allSelected = false;
        for (ApplianceGroupObject ago : selectedAppliances) {
            if (!ago.getGroupName().equals("All")) continue;
            allSelected = true;
            break;
        }
        return allSelected;
    }

    protected static boolean areAllDomainsSelected() {
        ApplianceDomainListPanel applianceOptionsPane = frame.getApplianceDomainListPanel();
        List<DomainGroup> selectedDomainGroups = applianceOptionsPane.getSelectedDomainGroup();
        boolean allSelected = false;
        for (DomainGroup dgo : selectedDomainGroups) {
            if (!dgo.getGroupName().equals("All")) continue;
            allSelected = true;
            break;
        }
        return allSelected;
    }

    @Reflected
    protected void waitForFrame() {
        if (frame != null) {
            return;
        }
        frame = (KumbaCoreFrame)GUIServices.getFrame(this);
        String className = this.getClass().getName();
        if (frame == null) {
            if (this.frameWaits < 20) {
                logger.finer(() -> LMG.log("(): %s waiting for frame %d times.", () -> className, () -> ++this.frameWaits));
                new AsynchMethodInvoker((Object)this, "waitForFrame", KumbaCoreConstants.THREAD_WAIT);
                return;
            }
            logger.warning(() -> LMG.log("(): %s could not find frame after %d times.  Trying to get it from application object.", () -> className, () -> this.frameWaits));
            frame = (KumbaCoreFrame)GUIApplication.getGUIApplication().getApplicationFrame();
        }
        if (frame == null) {
            logger.severe(() -> LMG.log("(): %s could not find application frame anywhere!  Timing?  Forcing to app frame.", () -> className, () -> this.frameWaits));
            frame = (KumbaCoreFrame)GUIApplication.getGUIApplication().getApplicationFrame();
        } else {
            this.frameStatusBar = frame.getStatusBar();
        }
    }

    private void checkEntitlements() {
        if (!LicenseManager.isFeatureEntitlementAllowed(this.getClass())) {
            this.setDecorator(new OverlayDecorator(KumbaCoreUIConstants.OVERLAY_COLOR, KumbaCoreUIConstants.OVERLAY_BACKGROUND, LabelUtility.wrapInHTML("Your free preview of this feature has expired and is no longer\nsupported by your Community Edition license.\n\nPlease contact KumbaSoft LLC sales for an Enterprise license."), KumbaCoreUIConstants.OVERLAY_ICON));
        }
    }

    protected void showProgressBar(int maximum) {
        logger.finer(() -> LMG.log("(maximum=%d):  Starting", () -> maximum));
        if (this.frameStatusBar == null) {
            logger.fine(() -> LMG.log("(maximum=%d):  Frame's status bar is null.  Why?  Trying to get it again.", () -> maximum));
            this.frameStatusBar = frame.getStatusBar();
            if (this.frameStatusBar == null) {
                logger.fine(() -> LMG.log("(maximum=%d):  Frame's status bar is still null.  Why?", () -> maximum));
                return;
            }
        }
        logger.finer(() -> LMG.log("(maximum=%d):  Creating progress bar", () -> maximum));
        this.progressBar = (JMProgressBar)this.frameStatusBar.addProgressBar(maximum);
        logger.finer(() -> LMG.log("(maximum=%d):  Done", () -> maximum));
    }

    protected void hideProgressBar() {
        if (this.frameStatusBar == null || this.progressBar == null) {
            return;
        }
        this.frameStatusBar.removeProgressBar();
    }

    protected void updateProgressBar(int value) {
        if (this.progressBar != null) {
            this.progressBar.setValue(value);
        }
    }

    protected String getPreferencesDirectoryName() {
        logger.finer("(): Starting");
        Application application = Application.getApplication();
        KumbaCoreGUIApplicationProperties appProps = (KumbaCoreGUIApplicationProperties)application.getApplicationProperties();
        String tablePreferencesDirectory = appProps.getUiPreferencesDirectory();
        String panelClassName = this.getClass().getSimpleName();
        String preferencesDirectoryName = String.format("%s%s%s", tablePreferencesDirectory, panelClassName, File.separator);
        logger.finer(() -> LMG.log("(): Done.  Returning '%s'", () -> preferencesDirectoryName));
        return preferencesDirectoryName;
    }

    protected String getHelpFile(String fieldName, String defaultText) {
        String className = this.getClass().getSimpleName();
        String helpFileName = String.format("%s%s_%s.html", HELP_FILES_DIRECTORY, className, fieldName);
        logger.finest(() -> LMG.log("(fieldName=%s, defaultText):  Computed Help File Name: %s\n", () -> fieldName, () -> helpFileName));
        try {
            String helpFileText = FileUtility.readFile(helpFileName);
            return helpFileText;
        }
        catch (IOException e) {
            logger.info(() -> LMG.log("(fieldName=%s, defaultText):  Help file resource '%s' not found\n", () -> fieldName, () -> helpFileName));
            return defaultText;
        }
    }

    protected void openResultsDialogAndSetWaitCursor(String dialogTitle) {
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        Window parentWindow = GUIServices.getParentWindow(this.getDialogSourceComponent());
        this.commandResultsDialog = parentWindow instanceof JFrame ? new CommandResultsDialog((JFrame)parentWindow, dialogTitle) : new CommandResultsDialog((JDialog)parentWindow, dialogTitle);
    }

    protected Component getDialogSourceComponent() {
        return this;
    }

    protected void waitForResultsDialogToCloseAndResetCursor() {
        this.commandResultsDialog.waitingToClose();
        while (this.commandResultsDialog.isShowing()) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        this.commandResultsDialog.dispose();
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    protected <T> WizardDialog<T> createWizardDialog(String title) {
        Component c = this.getDialogSourceComponent();
        Window parentWindow = GUIServices.getParentWindow(c);
        WizardDialog dialog = null;
        logger.finer(() -> LMG.log("(title=%s):  Dialog Source Component: %s, Parent Window: %s", () -> title, () -> c.getClass().getSimpleName(), () -> parentWindow.getClass().getSimpleName()));
        dialog = parentWindow instanceof JFrame ? new WizardDialog((JFrame)parentWindow, title) : new WizardDialog((JDialog)parentWindow, title);
        return dialog;
    }

    protected void revalidateOnVisible() {
        logger.finer(() -> LMG.log("(): Starting for '%s'", () -> this.getClass().getName()));
        if (this.revalidationComplete) {
            logger.finer(() -> LMG.log("(): Revalidation already completed for '%s'.  Done.", () -> this.getClass().getName()));
            return;
        }
        if (!this.isShowing()) {
            logger.finer(() -> LMG.log("(): '%s' is not actually visible.  Returning.", () -> this.getClass().getName()));
            return;
        }
        this.revalidate();
        this.repaint();
        this.revalidationComplete = true;
        logger.finer(() -> LMG.log("(): Done for '%s'", () -> this.getClass().getName()));
    }
}

