/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.beans;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.ui.beans.RelativeAnchor;
import com.kumbasoft.core.ui.beans.RelativeTimeMeasure;

public class AbstractLogSearchOptions
extends AbstractTool {
    private String filterExpression;
    private RelativeAnchor relativeAnchor;
    private RelativeTimeMeasure relativeTimeMeasure;
    private int timeAmount;
    private DateTime beginTime;
    private DateTime endTime;
    private boolean caseSensitive;
    private boolean continuousPoll;
    private int continuousPollDelay;
    private DynamicBean userSelectedOptions = new DynamicBean();

    protected AbstractLogSearchOptions() {
        this.continuousPollDelay = KumbaCoreConstants.LOG_POLLING_INTERVAL;
    }

    public DynamicBean getUserSelectedOptions() {
        return this.userSelectedOptions;
    }

    public void setUserSelectedOptions(DynamicBean userSelectedOptions) {
        this.userSelectedOptions = userSelectedOptions;
    }

    public <T> T getUserSelectedOption(String optionName) {
        if (this.userSelectedOptions.hasProperty(optionName)) {
            return this.userSelectedOptions.getProperty(optionName);
        }
        return null;
    }

    public void setUserSelectedOption(String optionName, Object value) {
        this.userSelectedOptions.setProperty(optionName, value);
    }

    public void computeTimeRange() {
        AbstractTool.logger.finer("(): Entering");
        if (this.relativeAnchor.equals((Object)RelativeAnchor.BETWEEN)) {
            AbstractTool.logger.fine("(): N/A for anchor of Between.  Returning.");
            return;
        }
        DateTime beginTime = new DateTime();
        DateTime endTime = new DateTime();
        int numberOfSecondsOffset = this.relativeTimeMeasure.getNumberOfSeconds();
        String beginTimeString = beginTime.toString();
        String endTimeString = endTime.toString();
        AbstractTool.logger.finer(() -> LMG.log("(): Before Computing:  Begin Time: %s, End Time: %s, Time Amount: %d, Seconds to offset: %d", () -> beginTimeString, () -> endTimeString, () -> this.timeAmount, () -> numberOfSecondsOffset));
        if (this.relativeAnchor.equals((Object)RelativeAnchor.NOW)) {
            AbstractTool.logger.fine("(): Ensuring multiplier is negative for anchor of NOW.");
            multiplier = this.timeAmount < 0 ? this.timeAmount : -this.timeAmount;
            beginTime.addSeconds(numberOfSecondsOffset * multiplier);
            endTime.addDays(1);
        } else if (this.relativeAnchor.equals((Object)RelativeAnchor.BEGIN_TIME)) {
            AbstractTool.logger.fine("(): Simple multiplier relative to BEGIN_TIME.");
            beginTime = this.beginTime;
            endTime.addSeconds(numberOfSecondsOffset * this.timeAmount);
        } else {
            AbstractTool.logger.fine("e(): Ensuring multiplier is negative for anchor of END TIME.");
            endTime = this.endTime;
            multiplier = this.timeAmount < 0 ? this.timeAmount : -this.timeAmount;
            beginTime.addSeconds(numberOfSecondsOffset * multiplier);
        }
        this.setBeginTime(beginTime);
        this.setEndTime(endTime);
        String beginTimeString2 = beginTime.toString();
        String endTimeString2 = endTime.toString();
        AbstractTool.logger.fine(() -> LMG.log("(): After Computing:  Begin Time: %s, End Time: %s, offset: %d", () -> beginTimeString2, () -> endTimeString2, () -> numberOfSecondsOffset));
        AbstractTool.logger.finer("(): Done");
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    public DateTime getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(DateTime beginTime) {
        AbstractTool.logger.finer(() -> LMG.log("(beginTime=%s)", () -> beginTime));
        this.beginTime = beginTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DateTime endTime) {
        AbstractTool.logger.finer(() -> LMG.log("(endTime=%s)", () -> endTime));
        this.endTime = endTime;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isContinuousPoll() {
        return this.continuousPoll;
    }

    public void setContinuousPoll(boolean continuousPoll) {
        this.continuousPoll = continuousPoll;
    }

    public int getContinuousPollDelay() {
        return this.continuousPollDelay;
    }

    public void setContinuousPollDelay(int continuousPollDelay) {
        this.continuousPollDelay = continuousPollDelay;
    }

    public RelativeAnchor getRelativeAnchor() {
        return this.relativeAnchor;
    }

    public void setRelativeAnchor(RelativeAnchor relativeAnchor) {
        this.relativeAnchor = relativeAnchor;
    }

    public RelativeTimeMeasure getRelativeTimeMeasure() {
        return this.relativeTimeMeasure;
    }

    public void setRelativeTimeMeasure(RelativeTimeMeasure relativeTimeMeasure) {
        this.relativeTimeMeasure = relativeTimeMeasure;
    }

    public int getTimeAmount() {
        return this.timeAmount;
    }

    public void setTimeAmount(int timeAmount) {
        this.timeAmount = timeAmount;
    }

    public String toString() {
        return BeanService.toString(this, ", ", "filterExpression", "caseSensitive", "beginTime", "endTime", "relativeAnchor", "relativeTimeMeasure", "timeAmount", "userSelectedOptions");
    }
}

