/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.beans;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.ConfigPropertyUIMetaData;
import java.util.ArrayList;
import java.util.HashMap;

public class ConfigUIMetaData
extends JMBean
implements Comparable<ConfigUIMetaData> {
    private String className;
    private boolean isReady;
    private String uiTitle;
    private HashMap<String, ConfigPropertyUIMetaData> propertyMetaData;

    public String getClassName() {
        return this.className;
    }

    public void setClass(Class<?> type) {
        block27: {
            this.setClassName(type.getName());
            if (this.uiTitle == null) {
                this.setUiTitle(StringUtility.toNameCase(StringUtility.getDisplayableTitle(type.getSimpleName())));
            }
            if (this.propertyMetaData != null) break block27;
            ArrayList<String> propertyNames = BeanService.getPropertyNames(type);
            this.propertyMetaData = new HashMap(propertyNames.size());
            for (String propertyName : propertyNames) {
                String label = StringUtility.getDisplayableTitle(propertyName);
                ConfigPropertyUIMetaData propertyMetaData = new ConfigPropertyUIMetaData();
                propertyMetaData.setUiLabel(label);
                Class<?> propertyType = BeanService.getPropertyType(type, propertyName);
                String uiFieldType = "";
                switch (propertyType.getSimpleName()) {
                    case "boolean": {
                        uiFieldType = "com.jmorgan.swing.JMCheckBox";
                        break;
                    }
                    case "int": 
                    case "long": {
                        uiFieldType = "com.jmorgan.swing.NumberField";
                        break;
                    }
                    case "String": {
                        uiFieldType = "com.jmorgan.swing.JMTextField";
                        break;
                    }
                    case "ObjectReference": {
                        uiFieldType = "com.jmorgan.swing.JMComboBox";
                        propertyMetaData.setObjectReference(true);
                        break;
                    }
                    default: {
                        new JMMessageBox(null, "Property Type Not Mapped to UIType", String.format("%s is not mapped to a ui type", propertyType));
                    }
                    case "Appliance": 
                    case "ArrayList": 
                    case "Domain": 
                }
                propertyMetaData.setUiFieldType(uiFieldType);
                this.propertyMetaData.put(propertyName, propertyMetaData);
            }
        }
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getUiTitle() {
        return this.uiTitle;
    }

    public void setUiTitle(String uiTitle) {
        this.uiTitle = uiTitle;
    }

    public ConfigPropertyUIMetaData getPropertyMetaData(String propertyName) {
        if (this.propertyMetaData == null) {
            return null;
        }
        if (propertyName == null) {
            return null;
        }
        return this.propertyMetaData.get(propertyName);
    }

    public HashMap<String, ConfigPropertyUIMetaData> getPropertyMetaData() {
        return this.propertyMetaData;
    }

    public void setPropertyMetaData(HashMap<String, ConfigPropertyUIMetaData> propertyMetaData) {
        this.propertyMetaData = propertyMetaData;
    }

    @Override
    public int compareTo(ConfigUIMetaData that) {
        return this.compareTo(that, "className");
    }

    public boolean equals(Object that) {
        return this.equals(that, "className");
    }

    @Override
    public int hashCode() {
        return this.hashCode("className");
    }

    @Override
    public String toString() {
        return this.toString("className");
    }
}

