/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.beans.probe;

import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.j2ee.xml.XMLFormatter;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMButton;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.probe.AttachmentTrace;
import com.kumbasoft.core.beans.probe.ProtocolHeader;
import com.kumbasoft.core.beans.probe.TransactionContext;
import com.kumbasoft.core.beans.probe.TransactionIdentity;
import com.kumbasoft.core.beans.probe.Variable;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;

public final class ProbeContextInfo
extends AbstractTool {
    public static final Image AAA_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "AAAAction.png");
    public static final Image ANTI_VIRUS_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "AntivirusAction.png");
    public static final Image BINARY_CONTEXT_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "BinaryContext.png");
    public static final Image CALL_PROCESSING_RULE_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "CallProcessingRuleAction.png");
    public static final Image CONDITIONAL_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "ConditionalAction.png");
    public static final Image CONVERT_HTTP_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "ConvertHTTPAction.png");
    public static final Image CRYPTO_BINARY_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "CryptoBinaryAction.png");
    public static final Image DECRYPT_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "DecryptAction.png");
    public static final Image ENCRYPT_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "EncryptAction.png");
    public static final Image ERROR_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "Deleted.png");
    public static final Image ERROR_CONTEXT_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "ErrorContext.png");
    public static final Image EVENT_SYNC_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "EventSyncAction.png");
    public static final Image EXTRACT_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "ExtractAction.png");
    public static final Image FETCH_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "FetchAction.png");
    public static final Image FILTER_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "FilterAction.png");
    public static final Image FOREACH_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "ForEachAction.png");
    public static final Image GATEWAY_SCRIPT_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "GatewayscriptAction.png");
    public static final Image HEADER_REWRITE_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "HeaderRewriteAction.png");
    public static final Image JSON_CONTEXT_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "JSONContext.png");
    public static final Image JSON_WEB_DECRYPT_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "JSONWebDecryptAction.png");
    public static final Image JSON_WEB_SIGN_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "JSONWebSignAction.png");
    public static final Image JSON_WEB_VERIFY_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "JSONWebVerifyAction.png");
    public static final Image JSON_WEB_ENCRYPT_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "JSONWebEncryptAction.png");
    public static final Image LOG_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "LogAction.png");
    public static final Image METHOD_REWRITE_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "MethodRewriteAction.png");
    public static final Image MQ_HEADER_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "MQHeaderAction.png");
    public static final Image NULL_CONTEXT_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "NullContext.png");
    public static final Image ON_ERROR_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "OnErrorAction.png");
    public static final Image PARSE_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "ParseAction.png");
    public static final Image RESULTS_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "ResultsAction.png");
    public static final Image RESULTS_ASYNCHRONOUS_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "ResultsAsynchronousAction.png");
    public static final Image ROUTE_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "RouteAction.png");
    public static final Image ROUTE_USING_VARIABLE_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "RouteUsingVariableAction.png");
    public static final Image SET_VARIABLE_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "SetVariableAction.png");
    public static final Image SIGN_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "SignAction.png");
    public static final Image SLM_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "SLMAction.png");
    public static final Image SQL_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "SQLAction.png");
    public static final Image STRIP_ATTACHMENTS_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "StripAttachmentsAction.png");
    public static final Image TRANSFORM_BINARY_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "TransformBinaryAction.png");
    public static final Image TRANSFORM_WITH_PROCESSING_CONTROL_FILE_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "TransformWithProcessingControlFileAction.png");
    public static final Image TRANSFORM_WITH_PROCESSING_INSTRUCTIONS_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "TransformWithProcessingInstructionsAction.png");
    public static final Image TRANSFORM_WITH_XSL_STYLESHEET_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "TransformWithXSLStyleSheetAction.png");
    public static final Image UNKNOWN_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "Question.png");
    public static final Image VALIDATE_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "ValidateAction.png");
    public static final Image VERIFY_ACTION_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "VerifyAction.png");
    public static final Image XML_CONTEXT_IMAGE = GUIApplication.getImageResource(KumbaCoreUIConstants.ART_ROOT, "XMLContext.png");
    public static final int NULL_CONTEXT = 0;
    public static final int XML_CONTEXT = 1;
    public static final int JSON_CONTEXT = 2;
    public static final int BINARY_CONTEXT = 3;
    private static final String BINARY_FORMAT_STRING = "%-8s\t%-47s\t\t%-16s\n";

    public static int getInputContextType(String transactionInput) {
        if (transactionInput.contains("<wrap/>")) {
            return 0;
        }
        if (transactionInput.contains("<wrap><hexbin>")) {
            return 3;
        }
        if (transactionInput.startsWith("{")) {
            return 2;
        }
        return 1;
    }

    public static JMButton createContextComponent(TransactionContext transactionContext) {
        Image contextImage = null;
        TransactionIdentity transactionIdentity = transactionContext.getTransactionIdentity();
        String contextName = transactionIdentity.getInputContext();
        String transactionInput = transactionContext.getTransactionInput();
        String contextType = "";
        if (transactionInput == null) {
            contextImage = XML_CONTEXT_IMAGE;
            contextType = "Unknown due to input being NULL. Defaulting to XML";
        } else if (transactionContext.isErrorContext()) {
            contextImage = ERROR_CONTEXT_IMAGE;
            contextType = "null";
        } else if (contextName.equalsIgnoreCase("NULL")) {
            contextImage = NULL_CONTEXT_IMAGE;
            contextType = "null";
        } else {
            switch (ProbeContextInfo.getInputContextType(transactionInput)) {
                case 0: {
                    contextImage = NULL_CONTEXT_IMAGE;
                    contextType = "null";
                    break;
                }
                case 1: {
                    contextImage = XML_CONTEXT_IMAGE;
                    contextType = "XML";
                    break;
                }
                case 2: {
                    contextImage = JSON_CONTEXT_IMAGE;
                    contextType = "JSON";
                    break;
                }
                case 3: {
                    contextImage = BINARY_CONTEXT_IMAGE;
                    contextType = "Binary";
                }
            }
        }
        ArrayList<ProtocolHeader> headers = transactionContext.getProtocolHeaders();
        int headerCount = headers == null ? 0 : headers.size();
        ArrayList<AttachmentTrace> attachments = transactionContext.getAttachmentTraces();
        int attachmentCount = attachments == null ? 0 : attachments.size();
        DateTime timeStamp = transactionIdentity.getTimestamp();
        String contextTime = timeStamp.toString();
        ArrayList<Variable> variables = transactionContext.getVariables();
        int localVariables = 0;
        int contextVariables = 0;
        int globalVariables = 0;
        int serviceVariables = 0;
        String errorCode = null;
        String errorMessage = null;
        for (Variable variable : variables) {
            String scope = variable.getScope();
            String context = variable.getContext();
            switch (scope) {
                case "system": {
                    ++globalVariables;
                    break;
                }
                case "context": {
                    ++contextVariables;
                    break;
                }
                case "service": {
                    byte[] decodedValue;
                    String variableValue;
                    if (StringUtility.isNotEmpty(context)) {
                        ++contextVariables;
                        break;
                    }
                    ++serviceVariables;
                    String variableName = variable.getGlobalURL();
                    AbstractTool.logger.finer(() -> LMG.log("(transactionContext=%s): Variable Name is %s", () -> contextName, () -> variableName));
                    if (variableName.equals("var://service/error-code")) {
                        variableValue = variable.getValue();
                        AbstractTool.logger.finer(() -> LMG.log("(transactionContext=%s): Variable Value is %s", () -> contextName, () -> variableValue));
                        decodedValue = Base64.decodeBase64(variableValue);
                        errorCode = new String(decodedValue);
                        AbstractTool.logger.finer(() -> LMG.log("(transactionContext=%s): Decoded Variable Value is %s", () -> contextName, () -> new String(decodedValue)));
                        break;
                    }
                    if (!variableName.equals("var://service/error-message")) break;
                    variableValue = variable.getValue();
                    AbstractTool.logger.finer(() -> LMG.log("(transactionContext=%s): Variable Value is %s", () -> contextName, () -> variableValue));
                    if (variableValue == null) break;
                    decodedValue = Base64.decodeBase64(variableValue);
                    errorMessage = new String(decodedValue);
                }
            }
        }
        StringBuilder sb = new StringBuilder("<html><body>");
        if (errorMessage == null) {
            sb.append("<p>Context Name: ");
            sb.append(contextName);
            sb.append("</p><p>Context Type: ");
            sb.append(contextType);
            sb.append("</p><p>Headers: ");
            sb.append(headerCount);
            sb.append("</p><p>Attachments: ");
            sb.append(attachmentCount);
            sb.append("</p><p>Local Variables: ");
            sb.append(localVariables);
            sb.append("</p><p>Context Variables: ");
            sb.append(contextVariables);
            sb.append("</p><p>Global Variables: ");
            sb.append(globalVariables);
            sb.append("</p><p>Service Variables: ");
            sb.append(serviceVariables);
        } else {
            sb.append("<p>Error Code: ");
            sb.append(errorCode);
            sb.append("</p><p>Error Message:<br/>");
            sb.append(errorMessage);
        }
        sb.append("</p><p>Time: ");
        sb.append(contextTime);
        sb.append("</p></body></html>");
        JMButton paper = new JMButton(new ImageIcon(contextImage), sb.toString());
        return paper;
    }

    public static String getDisplayableContent(TransactionContext context) {
        String contextName = context.getTransactionIdentity().getInputContext();
        if (contextName.equalsIgnoreCase("NULL")) {
            return "";
        }
        String transactionInput = context.getTransactionInput();
        if (transactionInput == null) {
            return "";
        }
        String displayableContext = "";
        switch (ProbeContextInfo.getInputContextType(transactionInput)) {
            case 0: {
                break;
            }
            case 1: {
                displayableContext = transactionInput.replace("<wrap>", "").replace("</wrap>", "");
                displayableContext = XMLFormatter.format(displayableContext);
                break;
            }
            case 2: {
                displayableContext = transactionInput.replace("<wrap>", "").replace("</wrap>", "");
                break;
            }
            case 3: {
                XMLElement binaryWrapperRoot = XMLElement.parseXMLString(transactionInput);
                XMLElement wrapNode = binaryWrapperRoot.getNode("wrap");
                XMLElement hexBinNode = wrapNode.getNode("hexbin");
                String hexData = hexBinNode.getValue();
                StringBuilder sb = new StringBuilder(String.format(BINARY_FORMAT_STRING, "Offset", "Hexadecimal Data", "ASCII"));
                int start = 0;
                while (start < hexData.length()) {
                    String offset = String.format("0x%06X", start);
                    String subSet = StringUtility.getSubstring(hexData, start, 32);
                    StringBuilder hexDisplay = new StringBuilder(48);
                    StringBuilder ascDisplay = new StringBuilder(16);
                    int h = 0;
                    while (h < subSet.length()) {
                        if (h > 0) {
                            hexDisplay.append(" ");
                        }
                        String hexChar = subSet.substring(h, h + 2);
                        hexDisplay.append(hexChar);
                        char ascChar = (char)Integer.parseInt(hexChar, 16);
                        if (ascChar == '\n' || ascChar == '\r' || ascChar == '\t') {
                            ascChar = ' ';
                        }
                        ascDisplay.append(ascChar);
                        h += 2;
                    }
                    String displayline = String.format(BINARY_FORMAT_STRING, offset, hexDisplay.toString(), ascDisplay.toString());
                    sb.append(displayline);
                    start += 32;
                }
                displayableContext = sb.toString();
            }
        }
        return displayableContext;
    }
}

