/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMFrame;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.component.PreferredSizeComponent;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.SystemClipboard;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.security.LicenseInformation;
import java.awt.Component;
import javax.swing.JFrame;

public class LicenseDialog
extends JMDialog {
    private LicenseInformation licenseInformation;
    private JMLabel licenseInfo;
    private JMButton btnCopyLicenseKey;

    public LicenseDialog(JMFrame frame) {
        super((JFrame)frame, "DPAA License");
    }

    @Override
    public void buildGUI(Object ... arguments) {
        this.licenseInformation = new LicenseInformation();
        String licenseText = LabelUtility.wrapInHTML(this.licenseInformation.getLicenseHTML());
        this.licenseInfo = new JMLabel(licenseText);
        this.contentPane.add((Component)this.licenseInfo, "Center");
        this.btnCopyLicenseKey = new JMButton("Copy License", KumbaCoreUIConstants.COPY_ICON, "Copy the license key to the clipboard.");
        new ActionEventInvoker(this.btnCopyLicenseKey, this, "editCopy");
        this.contentPane.add((Component)new PreferredSizeComponent(this.btnCopyLicenseKey), "South");
    }

    @Reflected
    private void editCopy() {
        String licenseKey = this.licenseInformation.getLicenseForEmail();
        SystemClipboard.setContents(licenseKey);
    }
}

