/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.logSearchOptions;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.swing.util.GUIServices;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.AbstractLogSearchOptions;
import com.kumbasoft.core.ui.dialog.logSearchOptions.DateSelectionPanel;
import com.kumbasoft.core.util.FileUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;

public abstract class AbstractSearchOptionsPanel<SearchOptionsType extends AbstractLogSearchOptions>
extends AbstractPanel
implements DialogPanel {
    protected GenericDialog parentDialog;
    protected DateSelectionPanel dateSelectionPanel;
    protected JMCheckBox cbxCaseSensitive;
    protected JMCheckBox cbxContinuousPoll;
    protected NumberField nfContinuousPollDelay;
    protected SearchOptionsType searchOptions;
    protected JMButton btnOpen;
    protected JMButton btnSave;
    protected JMButton btnReset;
    protected JMButton btnOK;
    protected JMButton btnCancel;

    public AbstractSearchOptionsPanel(SearchOptionsType searchOptions) {
        super(KumbaCoreUIConstants.createVerticalFlowLayout(3));
        this.setSearchOptions(searchOptions);
        this.add(this.createButtonPanel());
        this.createControls();
        this.btnOK = new JMButton("OK");
        new ActionEventInvoker(this.btnOK, this, "okClicked");
        this.btnCancel = new JMButton("Cancel");
        new ActionEventInvoker(this.btnCancel, this, "fileClose");
        JMPanel buttonPanel = new JMPanel(new FlowLayout());
        buttonPanel.addAll(this.btnOK, this.btnCancel);
        this.add(buttonPanel);
    }

    protected void createControls() {
        this.dateSelectionPanel = new DateSelectionPanel((AbstractLogSearchOptions)this.searchOptions);
        this.cbxCaseSensitive = new JMCheckBox("Case Sensitive", ((AbstractLogSearchOptions)this.searchOptions).isCaseSensitive());
        this.cbxContinuousPoll = new JMCheckBox("Poll Until Results Match", ((AbstractLogSearchOptions)this.searchOptions).isContinuousPoll());
        this.nfContinuousPollDelay = new NumberField((double)((AbstractLogSearchOptions)this.searchOptions).getContinuousPollDelay());
        NumberSpinner nsPollDelay = new NumberSpinner(this.nfContinuousPollDelay, 1000.0, 1000.0, 2.147483647E9);
        LabeledComponent lblPollDelay = new LabeledComponent("Poll Delay:", (Component)nsPollDelay, 75, 50);
        JMPanel panel = new JMPanel(new BorderLayout(40, 0));
        panel.add((Component)this.cbxContinuousPoll, "West");
        panel.add((Component)lblPollDelay, "Center");
        panel.add(ComponentFactory.createSpacer(100, 20), "East");
        this.addAll(this.dateSelectionPanel, this.cbxCaseSensitive, panel);
    }

    protected abstract SearchOptionsType createSearchOptions();

    private JMPanel createButtonPanel() {
        this.btnOpen = ComponentFactory.createButton(KumbaCoreUIConstants.OPEN_ICON, null, "Open a saved search", true, this, "fileOpen", new Object[0]);
        this.btnSave = ComponentFactory.createButton(KumbaCoreUIConstants.SAVE_ICON, null, "Save these settings", true, this, "fileSave", new Object[0]);
        this.btnReset = ComponentFactory.createButton(KumbaCoreUIConstants.REFRESH_ICON, null, "Reset to defaults", true, this, "resetToDefaults", new Object[0]);
        JMPanel panel = KumbaCoreUIConstants.createFlowLayoutPanel(2);
        panel.addAll(this.btnOpen, this.btnSave, this.btnReset);
        return panel;
    }

    @Override
    public void setParentDialog(GenericDialog dialog) {
        this.parentDialog = dialog;
    }

    protected SearchOptionsType getSearchOptions() {
        return this.searchOptions;
    }

    protected void setSearchOptions(SearchOptionsType searchOptions) {
        this.searchOptions = searchOptions;
        if (this.dateSelectionPanel != null) {
            this.dateSelectionPanel.setSearchOptions((AbstractLogSearchOptions)this.searchOptions);
        }
        if (this.cbxCaseSensitive != null) {
            this.cbxCaseSensitive.setSelected(((AbstractLogSearchOptions)this.searchOptions).isCaseSensitive());
        }
        if (this.cbxContinuousPoll != null) {
            this.cbxContinuousPoll.setSelected(((AbstractLogSearchOptions)this.searchOptions).isContinuousPoll());
        }
    }

    @Reflected
    protected void fileOpen() {
        File optionsFile = GUIServices.fileOpenDialog(null);
        if (optionsFile == null) {
            return;
        }
        AbstractLogSearchOptions searchOptions = (AbstractLogSearchOptions)FileUtility.readObject(optionsFile, true);
        if (searchOptions == null) {
            return;
        }
        BeanService.copyTo(searchOptions, this.searchOptions);
        this.setSearchOptions(this.searchOptions);
    }

    @Reflected
    protected void fileSave() {
        File saveFile = GUIServices.fileSaveDialog(null);
        if (saveFile == null) {
            return;
        }
        this.saveOptions();
        FileUtility.writeObject(saveFile, this.searchOptions, true);
    }

    protected void saveOptions() {
        AbstractPanel.logger.finer("(): Starting");
        this.dateSelectionPanel.saveOptions();
        ((AbstractLogSearchOptions)this.searchOptions).setCaseSensitive(this.cbxCaseSensitive.isSelected());
        ((AbstractLogSearchOptions)this.searchOptions).setContinuousPoll(this.cbxContinuousPoll.isSelected());
        ((AbstractLogSearchOptions)this.searchOptions).setContinuousPollDelay((int)this.nfContinuousPollDelay.getNumber());
        ((AbstractLogSearchOptions)this.searchOptions).computeTimeRange();
        AbstractPanel.logger.finer("(): Done");
    }

    @Reflected
    protected void resetToDefaults() {
        SearchOptionsType searchOptions = this.createSearchOptions();
        this.setSearchOptions(searchOptions);
    }

    @Reflected
    protected void okClicked() {
        this.parentDialog.closeDialog();
    }

    @Reflected
    protected void fileClose() {
        this.parentDialog.setCancelled(true);
        this.okClicked();
    }

    @Override
    public boolean parentDialogClosing() {
        this.saveOptions();
        return true;
    }
}

