/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.preferences;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.io.filefilter.DirectoryFileFilter;
import com.jmorgan.io.filefilter.ExtensionFileFilter;
import com.jmorgan.io.filefilter.MultiFileFilter;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMFrame;
import com.jmorgan.swing.JMImageIcon;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.ScrollablePanel;
import com.jmorgan.swing.component.NumericalSliderComponent;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.dialog.uiconstants.FontEditorPanel;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.PropertyChangeEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreFrame;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.preferences.Preference;
import com.kumbasoft.core.ui.dialog.preferences.PreferencesPropertyResolver;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class PreferencesPane
extends AbstractPanel
implements DialogPanel {
    private JMTabbedPane tabbedPane;
    private JMPanel buttonPanel;
    private String lastIconDirectory;
    private final MultiFileFilter iconFileFilter;
    private GenericDialog parentDialog;
    private boolean corePreferencesChanged;
    private boolean uiPreferencesChanged;

    public PreferencesPane(KumbaCoreFrame frame) {
        super(KumbaCoreUIConstants.createBorderLayout());
        logger.finer("(frame): Starting");
        AbstractPanel.frame = frame;
        logger.finer("(frame): Building icon file filter.");
        this.iconFileFilter = new MultiFileFilter();
        this.iconFileFilter.addFilter(new DirectoryFileFilter());
        this.iconFileFilter.addFilter(new ExtensionFileFilter(".png", ".jpg", ".jpeg", ".gif", ".ico"));
        this.setInsets(InsetsFactory.createFixedInsets(5));
        this.tabbedPane = new JMTabbedPane(2);
        logger.finer("(frame): Building tabs.");
        this.buildTabs();
        this.add((Component)this.tabbedPane, "Center");
        logger.finer("(frame): Done");
    }

    private JMPanel createButtonPanel() {
        JMPanel panel = new JMPanel();
        JMButton okButton = new JMButton("OK");
        new ActionEventInvoker(okButton, this.parentDialog, "closeDialog");
        JMButton restoreButton = new JMButton("Restore UI Defaults");
        new ActionEventInvoker(restoreButton, this, "restoreToDefaults");
        panel.addAll(okButton, restoreButton);
        return panel;
    }

    private void buildTabs() {
        logger.finer("(): Starting.  Getting Preferences.");
        PreferencesPropertyResolver preferencesPropertyResolver = new PreferencesPropertyResolver();
        List<Preference> preferences = preferencesPropertyResolver.getPreferences();
        BeanComparator sorter = new BeanComparator("categoryOrder", "groupOrder");
        Collections.sort(preferences, sorter);
        HashMap<String, JMPanel> categoryComponents = new HashMap<String, JMPanel>();
        HashMap<CallSite, JMPanel> groupComponents = new HashMap<CallSite, JMPanel>();
        logger.finer(() -> LMG.log("(): Processing %d preferences.", () -> preferences.size()));
        for (Preference preference : preferences) {
            logger.finer(() -> LMG.log("(): Processing preference %s.  Building field.", () -> preference.toString()));
            Component fieldComponent = this.createFieldComponent(preference);
            String categoryName = preference.getCategoryName();
            JMPanel categoryTab = (JMPanel)categoryComponents.get(categoryName);
            if (categoryTab == null) {
                categoryTab = new ScrollablePanel(new VerticalFlowLayout(0, 2));
                JMScrollPane scrollPane = new JMScrollPane(categoryTab);
                scrollPane.setInsets(InsetsFactory.createFixedInsets(10));
                this.tabbedPane.addTab(categoryName, scrollPane);
                categoryComponents.put(categoryName, categoryTab);
            }
            String groupName = preference.getGroupName();
            String fullyQualifedGroupName = categoryName + groupName;
            if (groupName.length() > 0) {
                JMPanel groupComponent = (JMPanel)groupComponents.get(fullyQualifedGroupName);
                if (groupComponent == null) {
                    groupComponent = new ScrollablePanel(new VerticalFlowLayout(0, 2));
                    groupComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(KumbaCoreUIConstants.FOREGROUND), groupName));
                    groupComponents.put((CallSite)((Object)fullyQualifedGroupName), groupComponent);
                    categoryTab.add(groupComponent);
                }
                groupComponent.add(fieldComponent);
                continue;
            }
            categoryTab.add(fieldComponent);
        }
        logger.finer("(): Done");
    }

    private Component createFieldComponent(Preference preference) {
        Field field = preference.getField();
        Class<?> type = field.getType();
        String typeName = type.getSimpleName();
        Class<?> declaringClass = field.getDeclaringClass();
        String label = preference.getDisplayName();
        String helpFileContents = preference.getHelpFileContents();
        int minimum = preference.getMinimum();
        int maximum = preference.getMaximum();
        logger.finer(() -> LMG.log("(Preference preference): Category=%s, Label=%s, Minimum=%d, Maximum=%d", () -> preference.getCategoryName(), () -> label, () -> minimum, () -> maximum));
        LabeledComponent component = null;
        try {
            component = switch (typeName) {
                case "Font" -> {
                    JMLabel fontLabel = new JMLabel(label);
                    fontLabel.setPreferredSize(125, 20);
                    JMButton fontSetButton = this.createChangeButton();
                    new ActionEventInvoker(fontSetButton, this, "changeFont", declaringClass, field, label, fontLabel);
                    JMPanel fontComponent = new JMPanel(KumbaCoreUIConstants.createFlowLayout(0));
                    fontComponent.addAll(fontLabel, fontSetButton);
                    ComponentService.addHelpIcon(fontComponent, helpFileContents);
                    yield fontComponent;
                }
                case "Color" -> {
                    JMLabel colorLabel = new JMLabel(label);
                    colorLabel.setPreferredSize(250, 20);
                    JMLabel currentColorLabel = new JMLabel();
                    currentColorLabel.setPreferredSize(50, 20);
                    Color currentColor = (Color)field.get(declaringClass);
                    currentColorLabel.setOpaque(true);
                    currentColorLabel.setBackground(currentColor);
                    JMButton colorSetButton = this.createChangeButton();
                    new ActionEventInvoker(colorSetButton, this, "changeColor", declaringClass, field, label, currentColorLabel);
                    JMPanel colorComponent = new JMPanel(new FlowLayout(0, 2, 5));
                    colorComponent.addAll(colorLabel, currentColorLabel, colorSetButton);
                    ComponentService.addHelpIcon(colorComponent, helpFileContents);
                    yield colorComponent;
                }
                case "JMImageIcon" -> {
                    JMImageIcon icon = (JMImageIcon)field.get(declaringClass);
                    JMLabel iconLabel = new JMLabel(label);
                    iconLabel.setPreferredSize(200, 20);
                    JMLabel currentIcon = new JMLabel(icon);
                    JMButton iconSetButton = this.createChangeButton();
                    new ActionEventInvoker(iconSetButton, this, "changeIcon", declaringClass, field, label, currentIcon);
                    JMPanel iconComponent = new JMPanel(new FlowLayout(0, 2, 5));
                    iconComponent.addAll(currentIcon, iconLabel, iconSetButton);
                    ComponentService.addHelpIcon(iconComponent, helpFileContents);
                    yield iconComponent;
                }
                case "String" -> {
                    String value = (String)field.get(declaringClass);
                    JMTextField valueField = new JMTextField(value);
                    LabeledComponent textComponent = new LabeledComponent(label + ":", (Component)valueField);
                    ComponentService.addHelpIcon(textComponent, helpFileContents);
                    new PropertyChangeEventInvoker((Object)valueField, "text", this, "coreValueChanged", field, typeName, valueField);
                    yield textComponent;
                }
                case "Long", "long" -> {
                    long value = field.getLong(declaringClass);
                    String fieldName = label + ":";
                    NumericalSliderComponent longComponent = new NumericalSliderComponent(fieldName, (int)value, minimum, maximum, 1);
                    longComponent.getLabel().setPreferredSize(300, 20);
                    new PropertyChangeEventInvoker((Object)longComponent, fieldName, this, "coreValueChanged", field, typeName, longComponent.getNumberField());
                    JMPanel panel = new JMPanel(new FlowLayout(0, 2, 5));
                    panel.add(longComponent);
                    ComponentService.addHelpIcon(panel, helpFileContents);
                    yield panel;
                }
                case "Integer", "int" -> {
                    int value = field.getInt(declaringClass);
                    String fieldName = label + ":";
                    NumericalSliderComponent intComponent = new NumericalSliderComponent(label + ":", value, minimum, maximum, 1);
                    intComponent.getLabel().setPreferredSize(300, 20);
                    new PropertyChangeEventInvoker((Object)intComponent, fieldName, this, "coreValueChanged", field, typeName, intComponent.getNumberField());
                    JMPanel panel = new JMPanel(new FlowLayout(0, 2, 5));
                    panel.add(intComponent);
                    ComponentService.addHelpIcon(panel, helpFileContents);
                    yield panel;
                }
                default -> new LabeledComponent(label + ":", (Component)new JMTextField("Unrecognized preference type '" + typeName + "'"));
            };
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return component;
    }

    private JMButton createChangeButton() {
        JMButton button = new JMButton("Change...");
        button.setPreferredSize(90, 25);
        return button;
    }

    @Reflected
    private void coreValueChanged(Field field, String typeName, Component component) {
        this.corePreferencesChanged = true;
        if (component instanceof JMTextField) {
            JMTextField textField = (JMTextField)component;
            String value = textField.getText();
            BeanService.setPropertyValue(KumbaCoreConstants.class, field.getName(), value);
        } else if (component instanceof NumberField) {
            NumberField numberField = (NumberField)component;
            if (typeName.equals("Long") || typeName.equals("long")) {
                long value = (long)numberField.getNumber();
                BeanService.setPropertyValue(KumbaCoreConstants.class, field.getName(), value);
            } else {
                int value = (int)numberField.getNumber();
                BeanService.setPropertyValue(KumbaCoreConstants.class, field.getName(), value);
            }
        }
    }

    @Reflected
    private void changeFont(Class<?> declaringClass, Field field, String label, JMLabel fontLabel) {
        this.uiPreferencesChanged = true;
        logger.finer(() -> LMG.log("(%s, %s, label=%s, fontLabel):  Starting", () -> declaringClass.getName(), () -> field.getName(), () -> label));
        try {
            Font font = (Font)field.get(declaringClass);
            logger.finer(() -> LMG.log("(%s, %s, label=%s, fontLabel):  Existing font is: %s.  Opening dialog.", () -> declaringClass.getName(), () -> field.getName(), () -> label, () -> font.toString()));
            FontEditorPanel fontEditorPanel = new FontEditorPanel(font);
            GenericDialog genericDialog = new GenericDialog(GUIServices.getFrame(this), (DialogPanel)fontEditorPanel, true);
            genericDialog.pack();
            genericDialog.setVisible(true);
            logger.finer(() -> LMG.log("(%s, %s, label=%s, fontLabel):  Font dialog closed.", () -> declaringClass.getName(), () -> field.getName(), () -> label));
            if (!genericDialog.wasCancelled()) {
                Font newFont = fontEditorPanel.getFontValue();
                logger.finer(() -> LMG.log("(%s, %s, label=%s, fontLabel):  User selected font is: %s.", () -> declaringClass.getName(), () -> field.getName(), () -> label, () -> newFont.toString()));
                fontLabel.setFont(newFont);
                field.set(declaringClass, newFont);
                logger.finer(() -> LMG.log("(%s, %s, label=%s, fontLabel):  Core Font Is Now: %s.  Resetting default UI.", () -> declaringClass.getName(), () -> field.getName(), () -> label, () -> KumbaCoreUIConstants.FONT.toString()));
                GUIApplication guiApplication = GUIApplication.getGUIApplication();
                JMFrame frame = guiApplication.getApplicationFrame();
                guiApplication.setFontForComponentTypes(newFont);
                logger.finer(() -> LMG.log("(%s, %s, label=%s, fontLabel):  Updating Component Tree UI", () -> declaringClass.getName(), () -> field.getName(), () -> label));
                SwingUtilities.updateComponentTreeUI(this);
                SwingUtilities.updateComponentTreeUI(frame);
                logger.finer(() -> LMG.log("(%s, %s, label=%s, fontLabel):  Updating List Renderer Fonts", () -> declaringClass.getName(), () -> field.getName(), () -> label));
                GUIServices.updateListRendererFonts(frame, newFont);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        logger.finer(() -> LMG.log("(%s, %s, label=%s, fontLabel):  Done.", () -> declaringClass.getName(), () -> field.getName(), () -> label));
    }

    @Reflected
    private void changeColor(Class<?> declaringClass, Field field, String label, JMLabel currentColorLabel) {
        block12: {
            this.uiPreferencesChanged = true;
            logger.finer(() -> LMG.log("(%s, %s, label=%s, currentColorLabel):  Starting", () -> declaringClass.getName(), () -> field.getName(), () -> label));
            try {
                Color color = (Color)field.get(declaringClass);
                logger.finer(() -> LMG.log("(%s, %s, label=%s, currentColorLabel):  Old Color Is: %s", () -> declaringClass.getName(), () -> field.getName(), () -> label, () -> color.toString()));
                Color newColor = JColorChooser.showDialog(this, "Select the color for " + label, color);
                if (newColor == null) break block12;
                logger.finer(() -> LMG.log("(%s, %s, label=%s, currentColorLabel):  User chosen Color Is: %s", () -> declaringClass.getName(), () -> field.getName(), () -> label, () -> newColor.toString()));
                currentColorLabel.setBackground(newColor);
                field.set(declaringClass, newColor);
                GUIApplication guiApplication = GUIApplication.getGUIApplication();
                MethodInvoker setupApplicationColorsPointer = new MethodInvoker((Object)guiApplication, "setApplicationColors", new Object[0]);
                setupApplicationColorsPointer.invoke();
                JMFrame frame = guiApplication.getApplicationFrame();
                SwingUtilities.updateComponentTreeUI(frame);
                switch (field.getName()) {
                    case "BACKGROUND": {
                        GUIServices.updateContainerBackgroundColor(this, newColor);
                        GUIServices.updateContainerBackgroundColor(frame, newColor);
                        break;
                    }
                    case "FOREGROUND": {
                        GUIServices.updateContainerForegroundColor(this, newColor);
                        GUIServices.updateContainerForegroundColor(frame, newColor);
                    }
                }
                this.repaint();
                frame.repaint();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        logger.finer(() -> LMG.log("(%s, %s, label=%s, currentColorLabel):  Done", () -> declaringClass.getName(), () -> field.getName(), () -> label));
    }

    @Reflected
    private void changeIcon(Class<?> declaringClass, Field field, String label, JMLabel currentIconLabel) {
        this.uiPreferencesChanged = true;
        logger.finer(() -> LMG.log("(%s, %s, label=%s, currentIconLabel):  Starting", () -> declaringClass.getName(), () -> field.getName(), () -> label));
        try {
            File iconFile;
            JMImageIcon icon = (JMImageIcon)field.get(declaringClass);
            String oldDescription = icon.getDescription();
            if (oldDescription.startsWith("file:")) {
                oldDescription = StringUtility.substringAfter(oldDescription, "file:");
            }
            if ((iconFile = GUIServices.fileOpenDialog(this.lastIconDirectory, this.iconFileFilter)) == null) {
                logger.finer(() -> LMG.log("(%s, %s, label=%s, currentIconLabel):  No icon selected.  Returning.", () -> declaringClass.getName(), () -> field.getName(), () -> label));
                return;
            }
            logger.finer(() -> LMG.log("(%s, %s, label=%s, currentIconLabel):  User selected '%s'", () -> declaringClass.getName(), () -> field.getName(), () -> label, () -> iconFile.getAbsolutePath()));
            this.lastIconDirectory = iconFile.getParent();
            JMImageIcon imageIcon = new JMImageIcon(iconFile.getAbsolutePath());
            currentIconLabel.setIcon(imageIcon);
            icon.setImage(imageIcon.getImage());
            icon.setDescription(imageIcon.getDescription());
            GUIApplication guiApplication = GUIApplication.getGUIApplication();
            JMFrame frame = guiApplication.getApplicationFrame();
            GUIServices.updateMenuIcons(frame, icon, imageIcon);
            frame.repaint();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        logger.finer(() -> LMG.log("(%s, %s, label=%s, currentIconLabel):  Done.", () -> declaringClass.getName(), () -> field.getName(), () -> label));
    }

    @Override
    public void setParentDialog(GenericDialog dialog) {
        this.parentDialog = dialog;
        this.buttonPanel = this.createButtonPanel();
        this.add((Component)this.buttonPanel, "South");
    }

    @Override
    public boolean parentDialogClosing() {
        if (this.corePreferencesChanged) {
            KumbaCoreConstants.savePreferences();
        }
        if (this.uiPreferencesChanged) {
            KumbaCoreUIConstants.savePreferences();
        }
        return true;
    }

    @Reflected
    private void restoreToDefaults() {
        new JMMessageBox((JDialog)this.parentDialog, "Restore Defaults", LabelUtility.wrapInHTML("This will restore all UI defaults\nIncluding colors, fonts and icons.\n\nContinue?"), 12);
        if (JMMessageBox.getSelection() == 8) {
            return;
        }
        this.uiPreferencesChanged = false;
        KumbaCoreUIConstants.deleteLastUsedThemeFile();
        KumbaCoreUIConstants.setNonFinalStaticDefaults();
        GUIApplication guiApplication = GUIApplication.getGUIApplication();
        MethodInvoker setupApplicationColorsPointer = new MethodInvoker((Object)guiApplication, "setApplicationColors", new Object[0]);
        setupApplicationColorsPointer.invoke();
        JMFrame applicationFrame = guiApplication.getApplicationFrame();
        GUIServices.updateContainerBackgroundColor(frame, KumbaCoreUIConstants.BACKGROUND);
        GUIServices.updateContainerForegroundColor(frame, KumbaCoreUIConstants.FOREGROUND);
        guiApplication.setFontForComponentTypes(KumbaCoreUIConstants.FONT);
        GUIServices.updateListRendererFonts(applicationFrame, KumbaCoreUIConstants.FONT);
        SwingUtilities.updateComponentTreeUI(applicationFrame);
        guiApplication.getApplicationFrame().repaint();
        this.parentDialog.closeDialog();
    }
}

