/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.editors;

import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.SimpleBeanListCellValueRenderer;
import com.jmorgan.util.comparator.BeanComparator;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigUserGroup;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class UserGroupTableCellEditor
extends DefaultCellEditor
implements TableCellRenderer {
    private DefaultComboBoxModel<ObjectReference<ConfigUserGroup>> cbxModel;
    private JComboBox<ObjectReference<ConfigUserGroup>> editor = (JComboBox)this.getComponent();
    private JTextField renderer;
    private BeanComparator<ConfigUserGroup> groupSorter;
    private ObjectReference<ConfigUserGroup> nullReference;

    public UserGroupTableCellEditor() {
        super(new JComboBox(new DefaultComboBoxModel()));
        this.editor.setRenderer(new JMListCellRenderer(new SimpleBeanListCellValueRenderer("name")));
        this.cbxModel = (DefaultComboBoxModel)this.editor.getModel();
        this.groupSorter = new BeanComparator("name");
        this.nullReference = new ObjectReference();
        this.nullReference.setClassName("UserGroup");
        this.nullReference.setName("");
        this.renderer = new JTextField();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String columnName = table.getColumnName(column);
        if (columnName.equals("groupName")) {
            this.editor.setSelectedItem(value);
        }
        return this.getComponent();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String columnName = table.getColumnName(column);
        if (columnName.equals("groupName")) {
            if (value == null) {
                this.renderer.setText("");
            } else {
                this.renderer.setText(((ObjectReference)value).getName());
            }
        }
        return this.renderer;
    }

    public void setUserGroups(ArrayList<ConfigUserGroup> userGroups) {
        this.cbxModel.removeAllElements();
        Collections.sort(userGroups, this.groupSorter);
        this.cbxModel.addElement(this.nullReference);
        HashSet<String> usedNames = new HashSet<String>();
        for (ConfigUserGroup userGroup : userGroups) {
            String groupName = userGroup.getName();
            if (usedNames.contains(groupName)) continue;
            usedNames.add(groupName);
            ObjectReference ref = new ObjectReference();
            ref.setClassName("UserGroup");
            ref.setName(groupName);
            this.cbxModel.addElement(ref);
        }
        this.cbxModel.setSelectedItem(this.nullReference);
    }
}

