/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util;

import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.ListFiles;
import com.kumbasoft.core.tools.ThreadManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

public final class DataPowerFileUtility
extends AbstractTool {
    public static final String[] DEFAULT_DOMAIN_FILESTORES = new String[]{"pubcert:", "sharedcert:", "store:", "image:", "tasktemplates:"};
    public static final String[] FILESTORE_EXCLUSIONS = new String[]{"policyframework:"};
    public static final String[] CRYPTO_FILESTORES = new String[]{"cert:", "isamcert:", "sharedcert:", "pubcert:"};
    public static final String[] NORMAL_FILE_FILESTORES = new String[]{"local:", "store:", "temporary:"};
    public static final String VALID_FILE_NAME_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-.";
    public static final String[] SECURE_BACKUP_FILES = new String[]{"backupmanifest.xml", "cert.tgz", "chkpoints.tgz", "config.tgz", "local.tgz", "password-map.tgz", "root.tgz", "sharedcert.tgz", "store.tgz", "raid-volume.tgz"};

    private DataPowerFileUtility() {
    }

    public static ArrayList<String> getDomainFiles(Appliance appliance, Domain domain) {
        ConfigObjectCache<DataPowerFileInfo> fileCache = new ConfigObjectCache<DataPowerFileInfo>();
        DataPowerFileUtility.loadDomainFiles(appliance, appliance.getDomain("default"), "hsm:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, appliance.getDomain("default"), "store:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, appliance.getDomain("default"), "pubcert:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, appliance.getDomain("default"), "sharedcert:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, domain, "local:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, domain, "cert:", fileCache);
        DataPowerFileUtility.loadDomainFiles(appliance, domain, "temporary:", fileCache);
        Vector<DataPowerFileInfo> files = fileCache.getObjectCache();
        ArrayList<String> fileNames = new ArrayList<String>(files.size());
        for (DataPowerFileInfo file : files) {
            String fileName = file.getAbsolutePath();
            fileNames.add(fileName);
        }
        Collections.sort(fileNames);
        return fileNames;
    }

    public static final void loadDomainFiles(Appliance appliance, Domain domain, String fileStore, ConfigObjectCache<DataPowerFileInfo> fileCache) {
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        ListFiles listFiles = new ListFiles(appliance, domain, fileStore, null);
        listFiles.addConfigObjectSubscriber(DataPowerFileInfo.class, fileCache);
        listFiles.getProcessThread().addInvocationListener(stil);
        while (!stil.invocationComplete()) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
    }

    public static final boolean isFileNameValid(String fileName) {
        if (fileName.length() > 128) {
            return false;
        }
        if (fileName.startsWith(" ") || fileName.endsWith(" ")) {
            return false;
        }
        if (fileName.contains("..")) {
            return false;
        }
        String ucaseFileName = fileName.toUpperCase();
        String validFileName = StringUtility.removeAllExcept(ucaseFileName, VALID_FILE_NAME_CHARACTERS);
        return validFileName.equals(ucaseFileName);
    }

    public static final void saveDataPowerFiles(DataPowerFileInfo ... files) {
        logger.finer("(DataPowerFileInfo...files): Starting");
        if (ArrayUtility.isEmpty(files)) {
            logger.finer("(DataPowerFileInfo...files): There are no files to save.  Nothing to do.  Done.");
            return;
        }
        logger.finer(() -> LMG.log("(DataPowerFileInfo...files): Saving %d files", () -> files.length));
        DataPowerFileUtility.saveDataPowerFiles(Arrays.asList(files), null);
        logger.finer("(DataPowerFileInfo...files): Done");
    }

    public static final void saveDataPowerFiles(Collection<DataPowerFileInfo> files, ManagementCommandSubscriber commandSubscriber) {
        logger.finer("(Collection<DataPowerFileInfo>): Starting");
        for (DataPowerFileInfo file : files) {
            logger.finer(() -> LMG.log("(Collection<DataPowerFileInfo>): Processing '%s'", () -> file.getFQON()));
            try {
                String FQFN = file.getFQON().replace("->", "_");
                File tempFile = File.createTempFile(FQFN, "txt");
                new ASCFileWriter(tempFile, file.getFileContent());
                file.setLocalFile(tempFile);
            }
            catch (IOException e) {
                logger.severe(() -> LMG.log("(Collection<DataPowerFileInfo>): Error writing DataPower File '%s' - '%s'", () -> file.getFQON(), () -> e.getMessage()));
                e.printStackTrace();
            }
        }
        logger.finer("(Collection<DataPowerFileInfo>): Uploading.");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        ArrayList<FileUploader> uploaders = FileUploader.upload(files, mtil);
        if (uploaders == null) {
            logger.info("(Collection<DataPowerFileInfo>): Uploaders is null!   How?");
        }
        int uploaderCount = uploaders == null ? 0 : uploaders.size();
        logger.finer(() -> LMG.log("(Collection<DataPowerFileInfo>): %d uploaders created.", () -> uploaderCount));
        if (uploaderCount > 0 && commandSubscriber != null) {
            logger.finer("(Collection<DataPowerFileInfo>): Registering subscribers.");
            for (FileUploader uploader : uploaders) {
                uploader.addManagementCommandSubscriber(commandSubscriber);
            }
        }
        logger.finer("(Collection<DataPowerFileInfo>): Waiting for uploads to complete.");
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("DataPowerFileUtility.saveDataPowerFiles(DataPowerFileInfo...files)", mtil, KumbaCoreConstants.THREAD_WAIT, 0);
        if (!completedOnTime) {
            logger.warning("(Collection<DataPowerFileInfo>): Timed out waiting for uploads to complete.");
        }
        logger.finer("(Collection<DataPowerFileInfo>): Done");
    }
}

