/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusHSMKeyStatus;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.tools.ThreadManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public class HSMFSUtil
extends AbstractTool {
    private static final String[] HSM_DIRECTORIES = new String[]{"hsm:/", "hsm://hsm3"};

    private HSMFSUtil() {
    }

    public static Collection<StatusHSMKeyStatus> getHSMKeys(Collection<Appliance> appliances) {
        logger.finer("(Collection<Appliance>): Starting.");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        DataPowerStatusCache hsmKeyStatus = new DataPowerStatusCache();
        for (Appliance appliance : appliances) {
            logger.finer(() -> LMG.log("(Collection<Appliance>): Getting HSM Key Status for appliance '%s'.", () -> appliance.getName()));
            Domain defaultDomain = appliance.getDomain("default");
            DataPowerStatusMonitor statusMonitor = new DataPowerStatusMonitor(appliance, defaultDomain, "HSMKeyStatus", 0L);
            statusMonitor.addStatusListener(hsmKeyStatus);
            mtil.addThread(statusMonitor.getProcessThread());
        }
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (completedOnTime) {
            logger.finer("(Collection<Appliance>): All threads for getting HSM keys complete.");
        } else {
            logger.warning("(Collection<Appliance>): Not all threads for getting HSM keys completed on time.  Moving on, but results may not be complete.");
        }
        ArrayList<StatusHSMKeyStatus> keyCache = hsmKeyStatus.getStatusCache();
        if (((Boolean)BeanService.getPropertyValue(applicationParameters, "testingMode")).booleanValue()) {
            logger.finer("(Collection<Appliance>): Testing mode is on.  Faking it.");
            keyCache = HSMFSUtil.getFakeHSMKeyStatus(appliances);
        }
        int keyCount = keyCache.size();
        logger.finer(() -> LMG.log("(Collection<Appliance>): Returning %d keys.", () -> keyCount));
        return keyCache;
    }

    public static Collection<DataPowerFileInfo> getHSMDirectories(Appliance appliance) {
        Date date = new Date();
        date.setFormat(Date.SQL_FORMAT);
        ArrayList<DataPowerFileInfo> hsmDirectories = new ArrayList<DataPowerFileInfo>(2);
        String[] stringArray = HSM_DIRECTORIES;
        int n = HSM_DIRECTORIES.length;
        int n2 = 0;
        while (n2 < n) {
            String hsmDirectory = stringArray[n2];
            DataPowerFileInfo hsmKeyFile = new DataPowerFileInfo(appliance, appliance.getDomain("default"), null, 0L, hsmDirectory, "");
            hsmKeyFile.setDeleteable(false);
            hsmKeyFile.setAdminState(DPEnumerations.ADMIN_STATE[0]);
            hsmKeyFile.setIsReadOnly(true);
            hsmKeyFile.setIsExternal(false);
            hsmKeyFile.setConfigObjectType("file");
            hsmDirectories.add(hsmKeyFile);
            ++n2;
        }
        return hsmDirectories;
    }

    public static Collection<DataPowerFileInfo> getHSMFiles(Collection<Appliance> appliances) {
        logger.finer("(Collection<Appliance>): Starting.");
        Collection<StatusHSMKeyStatus> hsmKeys = HSMFSUtil.getHSMKeys(appliances);
        int hsmKeyCount = hsmKeys.size();
        ArrayList<DataPowerFileInfo> hsmKeyFiles = new ArrayList<DataPowerFileInfo>(hsmKeys.size());
        for (StatusHSMKeyStatus hsmKey : hsmKeys) {
            String keyLabel = hsmKey.getKeyLabel();
            String keyType = hsmKey.getKeyType();
            boolean exportable = hsmKey.getExportable().equals("on");
            Date date = new Date();
            date.setFormat(Date.SQL_FORMAT);
            DataPowerFileInfo hsmKeyFile = new DataPowerFileInfo(hsmKey.getAppliance(), hsmKey.getSourceDomain(), date.toString(), 100L, keyLabel);
            hsmKeyFile.setDeleteable(true);
            hsmKeyFile.setAdminState(DPEnumerations.ADMIN_STATE[0]);
            hsmKeyFile.setIsReadOnly(keyType.equals("public"));
            hsmKeyFile.setIsExternal(false);
            hsmKeyFile.setConfigObjectType("file");
            StatusObjectStatus objectStatus = new StatusObjectStatus();
            objectStatus.setAdminState(DPEnumerations.ADMIN_STATE[0]);
            objectStatus.setAppliance(hsmKey.getAppliance());
            objectStatus.setSourceDomain(hsmKey.getSourceDomain());
            objectStatus.setDataPowerClass("DataPowerFileInfo");
            objectStatus.setOpState(DPEnumerations.OP_STATE[0]);
            objectStatus.setName(hsmKeyFile.getName());
            objectStatus.setEventCode("");
            objectStatus.setErrorCode("");
            objectStatus.setConfigState(DPEnumerations.CONFIG_STATE[1]);
            hsmKeyFile.setStatus(objectStatus);
            hsmKeyFiles.add(hsmKeyFile);
        }
        logger.finer(() -> LMG.log("(Collection<Appliance>): Returning %d keys.", () -> hsmKeyCount));
        return hsmKeyFiles;
    }

    private static Collection<StatusHSMKeyStatus> getFakeHSMKeyStatus(Collection<Appliance> appliances) {
        Random r = new Random();
        int num = r.nextInt(1, 25);
        if (num % 2 == 1) {
            ++num;
        }
        ArrayList<Appliance> applianceList = new ArrayList<Appliance>(appliances);
        int applianceCount = appliances.size();
        ArrayList<StatusHSMKeyStatus> fakeData = new ArrayList<StatusHSMKeyStatus>(num);
        String type = "public";
        int i = 0;
        while (i < num) {
            int randomAppliance = r.nextInt(0, applianceCount);
            Appliance appliance = applianceList.get(randomAppliance);
            Domain domain = appliance.getDomain("default");
            StatusHSMKeyStatus key = new StatusHSMKeyStatus();
            key.setAppliance(appliance);
            key.setSourceDomain(domain);
            key.setBitLength(2048L);
            key.setExportable("on");
            key.setKeyHandle(String.format("%016x", i));
            key.setKeyType(type);
            key.setKeyLabel(String.format("hsm://hsm3/client.%d.com", i));
            key.setStatusTime(new DateTime());
            type = type.equals("public") ? "private" : "public";
            fakeData.add(key);
            ++i;
        }
        return fakeData;
    }
}

